/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.conversion.smile;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.stream.Collectors;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.Relation;

public class SmileConverter {
    private final Relation table;

    public SmileConverter(Relation table) {
        this.table = table;
    }

    public DataFrame toDataFrame() {
        StructType schema = DataTypes.struct(this.table.columns().stream().map(col -> new StructField(col.name(), this.toSmileType(col.type()))).collect(Collectors.toList()));
        return this.toDataFrame(schema);
    }

    public DataFrame toDataFrame(StructType schema) {
        ArrayList<Tuple> rows = new ArrayList<Tuple>();
        int colCount = this.table.columnCount();
        for (int rowIndex = 0; rowIndex < this.table.rowCount(); ++rowIndex) {
            Object[] row = new Object[colCount];
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                Column<?> col = this.table.column(colIndex);
                if (col.isMissing(rowIndex)) continue;
                row[colIndex] = col.type().equals(ColumnType.INSTANT) ? LocalDateTime.ofInstant(((InstantColumn)col).get(rowIndex), ZoneOffset.UTC) : col.get(rowIndex);
            }
            rows.add(Tuple.of((Object[])row, (StructType)schema));
        }
        return DataFrame.of(rows, (StructType)schema.boxed(rows));
    }

    private DataType toSmileType(ColumnType type) {
        if (type.equals(ColumnType.BOOLEAN)) {
            return DataTypes.BooleanType;
        }
        if (type.equals(ColumnType.DOUBLE)) {
            return DataTypes.DoubleType;
        }
        if (type.equals(ColumnType.FLOAT)) {
            return DataTypes.FloatType;
        }
        if (type.equals(ColumnType.INSTANT)) {
            return DataTypes.DateTimeType;
        }
        if (type.equals(ColumnType.INTEGER)) {
            return DataTypes.IntegerType;
        }
        if (type.equals(ColumnType.LOCAL_DATE)) {
            return DataTypes.DateType;
        }
        if (type.equals(ColumnType.LOCAL_DATE_TIME)) {
            return DataTypes.DateTimeType;
        }
        if (type.equals(ColumnType.LOCAL_TIME)) {
            return DataTypes.TimeType;
        }
        if (type.equals(ColumnType.LONG)) {
            return DataTypes.LongType;
        }
        if (type.equals(ColumnType.SHORT)) {
            return DataTypes.ShortType;
        }
        if (type.equals(ColumnType.STRING)) {
            return DataTypes.StringType;
        }
        throw new IllegalStateException("Unsupported column type " + type);
    }
}

