/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.text.ParseException;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.io.ReadOptions;

public class DoubleParser
extends AbstractColumnParser<Double> {
    public DoubleParser(ColumnType columnType) {
        super(columnType);
    }

    public DoubleParser(DoubleColumnType doubleColumnType, ReadOptions readOptions) {
        super(doubleColumnType);
        if (readOptions.missingValueIndicators().length > 0) {
            this.missingValueStrings = Lists.newArrayList((Object[])readOptions.missingValueIndicators());
        }
    }

    @Override
    public boolean canParse(String s) {
        if (this.isMissing(s)) {
            return true;
        }
        try {
            if (this.isPercent(AbstractColumnParser.remove(s, ','))) {
                s = AbstractColumnParser.remove(s, ',');
                NumberFormat.getPercentInstance().parse(s);
            } else {
                Double.parseDouble(AbstractColumnParser.remove(s, ','));
            }
            return true;
        }
        catch (IndexOutOfBoundsException | NumberFormatException | ParseException e) {
            return false;
        }
    }

    @Override
    public Double parse(String s) {
        return this.parseDouble(s);
    }

    @Override
    public double parseDouble(String s) {
        if (this.isMissing(s)) {
            return DoubleColumnType.missingValueIndicator();
        }
        if (this.isPercent(AbstractColumnParser.remove(s, ','))) {
            s = AbstractColumnParser.remove(s, ',').substring(0, s.length() - 1);
            return Double.parseDouble(s) / 100.0;
        }
        return Double.parseDouble(AbstractColumnParser.remove(s, ','));
    }

    private boolean isPercent(String s) {
        boolean containsPercentSymbol;
        boolean bl = containsPercentSymbol = s.charAt(s.length() - 1) == '%';
        if (containsPercentSymbol) {
            String percentageValue = s.substring(0, s.length() - 1);
            try {
                double value = Double.parseDouble(percentageValue);
                return !Double.isNaN(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }
}

