/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.ByteDictionaryMap;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.NoKeysAvailableException;
import tech.tablesaw.columns.strings.StringColumnFormatter;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.strings.StringFilters;
import tech.tablesaw.columns.strings.StringMapFunctions;
import tech.tablesaw.columns.strings.StringReduceUtils;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class StringColumn
extends AbstractColumn<StringColumn, String>
implements CategoricalColumn<String>,
StringFilters,
StringMapFunctions,
StringReduceUtils {
    private DictionaryMap data;
    private StringColumnFormatter printFormatter = new StringColumnFormatter();
    private final IntComparator rowComparator = (i, i1) -> {
        String f1 = this.get(i);
        String f2 = this.get(i1);
        return f1.compareTo(f2);
    };

    public static boolean valueIsMissing(String string) {
        return StringColumnType.valueIsMissing(string);
    }

    public StringColumn appendMissing() {
        this.data.appendMissing();
        return this;
    }

    @Override
    public int valueHash(int rowNumber) {
        return this.get(rowNumber).hashCode();
    }

    @Override
    public boolean equals(int rowNumber1, int rowNumber2) {
        return this.getDictionary().getKeyAtIndex(rowNumber1) == this.getDictionary().getKeyAtIndex(rowNumber2);
    }

    public static StringColumn create(String name) {
        return new StringColumn(name);
    }

    public static StringColumn create(String name, String ... strings) {
        return new StringColumn(name, strings);
    }

    public static StringColumn create(String name, Collection<String> strings) {
        return new StringColumn(name, strings);
    }

    public static StringColumn createInternal(String name, DictionaryMap map) {
        return new StringColumn(name, map);
    }

    public static StringColumn create(String name, int size) {
        StringColumn column = new StringColumn(name);
        for (int i = 0; i < size; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static StringColumn create(String name, Stream<String> stream) {
        StringColumn column = StringColumn.create(name);
        stream.forEach(column::append);
        return column;
    }

    private StringColumn(String name, Collection<String> strings) {
        super(StringColumnType.instance(), name, StringColumnType.DEFAULT_PARSER);
        this.data = new ByteDictionaryMap();
        for (String s : strings) {
            this.append(s);
        }
    }

    private StringColumn(String name, DictionaryMap map) {
        super(StringColumnType.instance(), name, StringColumnType.DEFAULT_PARSER);
        this.data = map;
    }

    private StringColumn(String name) {
        super(StringColumnType.instance(), name, StringColumnType.DEFAULT_PARSER);
        this.data = new ByteDictionaryMap();
    }

    private StringColumn(String name, String[] strings) {
        super(StringColumnType.instance(), name, StringColumnType.DEFAULT_PARSER);
        this.data = new ByteDictionaryMap();
        for (String string : strings) {
            this.append(string);
        }
    }

    public void setPrintFormatter(StringColumnFormatter formatter) {
        Preconditions.checkNotNull((Object)formatter);
        this.printFormatter = formatter;
    }

    public StringColumnFormatter getPrintFormatter() {
        return this.printFormatter;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.data.isMissing(rowNumber);
    }

    public StringColumn emptyCopy() {
        StringColumn empty = StringColumn.create(this.name());
        empty.setPrintFormatter(this.getPrintFormatter());
        return empty;
    }

    public StringColumn emptyCopy(int rowSize) {
        return StringColumn.create(this.name(), rowSize);
    }

    @Override
    public void sortAscending() {
        this.data.sortAscending();
    }

    @Override
    public void sortDescending() {
        this.data.sortDescending();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public String get(int rowIndex) {
        return this.data.get(rowIndex);
    }

    @Override
    public List<String> asList() {
        ArrayList<String> strings = new ArrayList<String>();
        for (String category : this) {
            strings.add(category);
        }
        return strings;
    }

    @Override
    public Table summary() {
        Table summary = Table.create(this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        summary.addColumns(new Column[]{measure});
        summary.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Unique");
        value.append(String.valueOf(this.countUnique()));
        Table countByCategory = this.countByCategory().sortDescendingOn("Count");
        measure.append("Top");
        value.append(countByCategory.stringColumn("Category").getString(0));
        measure.append("Top Freq.");
        value.appendObj(countByCategory.intColumn("Count").getString(0));
        return summary;
    }

    @Override
    public Table countByCategory() {
        return this.data.countByCategory(this.name());
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public StringColumn lead(int n) {
        StringColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public StringColumn lag(int n) {
        StringColumn copy = this.emptyCopy();
        copy.setName(this.name() + " lag(" + n + ")");
        if (n >= 0) {
            for (int m = 0; m < n; ++m) {
                copy.appendMissing();
            }
            for (int i = 0; i < this.size() && i + n < this.size(); ++i) {
                copy.append(this.get(i));
            }
        } else {
            for (int i = -n; i < this.size(); ++i) {
                copy.append(this.get(i));
            }
            for (int m = 0; m > n; --m) {
                copy.appendMissing();
            }
        }
        return copy;
    }

    @Override
    public StringColumn set(Selection rowSelection, String newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public StringColumn set(int rowIndex, String stringValue) {
        if (stringValue == null) {
            return this.setMissing(rowIndex);
        }
        try {
            this.data.set(rowIndex, stringValue);
        }
        catch (NoKeysAvailableException ex) {
            this.data = this.data.promoteYourself();
            try {
                this.data.set(rowIndex, stringValue);
            }
            catch (NoKeysAvailableException e) {
                throw new IllegalStateException(e);
            }
        }
        return this;
    }

    @Override
    public int countUnique() {
        return this.data.countUnique();
    }

    @Override
    public boolean contains(String aString) {
        return this.firstIndexOf(aString) >= 0;
    }

    public StringColumn setMissing(int i) {
        return this.set(i, StringColumnType.missingValueIndicator());
    }

    public StringColumn addAll(List<String> stringValues) {
        for (String stringValue : stringValues) {
            this.append(stringValue);
        }
        return this;
    }

    public StringColumn appendCell(String object) {
        return this.appendCell(object, this.parser());
    }

    public StringColumn appendCell(String object, AbstractColumnParser<?> parser) {
        return this.appendObj(parser.parse(object));
    }

    @Override
    public IntComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public Selection isMissing() {
        return this.data.isMissing();
    }

    @Override
    public Selection isNotMissing() {
        return this.data.isNotMissing();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Selection isEqualTo(String string) {
        return this.data.isEqualTo(string);
    }

    @Override
    public Selection isNotEqualTo(String string) {
        return this.data.isNotEqualTo(string);
    }

    public List<BooleanColumn> getDummies() {
        return this.data.getDummies();
    }

    public StringColumn unique() {
        ArrayList<String> strings = new ArrayList<String>(this.data.asSet());
        return new StringColumn(this.name(), strings);
    }

    public DoubleColumn asDoubleColumn() {
        return DoubleColumn.create(this.name(), this.asDoubleArray());
    }

    public StringColumn where(Selection selection) {
        return (StringColumn)this.subset(selection.toArray());
    }

    public StringColumn copy() {
        StringColumn newCol = StringColumn.create(this.name(), this.size());
        int r = 0;
        for (String string : this) {
            newCol.set(r, string);
            ++r;
        }
        newCol.setPrintFormatter(this.getPrintFormatter());
        return newCol;
    }

    public StringColumn append(Column<String> column) {
        Preconditions.checkArgument((boolean)column.type().equals(ColumnType.STRING), (String)"Column '%s' has type %s, but column '%s' has type %s.", (Object)this.name(), (Object)this.type(), (Object)column.name(), (Object)column.type());
        int size = column.size();
        for (int i = 0; i < size; ++i) {
            this.append(column.getString(i));
        }
        return this;
    }

    @Override
    public int countMissing() {
        return this.data.countMissing();
    }

    public StringColumn removeMissing() {
        StringColumn noMissing = this.emptyCopy();
        for (String v : this) {
            if (StringColumnType.valueIsMissing(v)) continue;
            noMissing.append(v);
        }
        return noMissing;
    }

    @Override
    public Iterator<String> iterator() {
        return this.data.iterator();
    }

    @Override
    public Set<String> asSet() {
        return this.data.asSet();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return this.data.asBytes(rowNumber);
    }

    public double getDouble(int i) {
        return (double)this.data.uniqueValuesAt(this.data.firstIndexOf(this.data.getValueForIndex(i))) - 1.0;
    }

    public double[] asDoubleArray() {
        return Arrays.stream(this.data.asIntArray()).asDoubleStream().toArray();
    }

    public StringColumn append(String value) {
        try {
            this.data.append(value);
        }
        catch (NoKeysAvailableException ex) {
            this.data = this.data.promoteYourself();
            try {
                this.data.append(value);
            }
            catch (NoKeysAvailableException e) {
                throw new IllegalStateException(e);
            }
        }
        return this;
    }

    public StringColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to StringColumn");
        }
        return this.append((String)obj);
    }

    @Override
    public Selection isIn(String ... strings) {
        return this.data.isIn(strings);
    }

    @Override
    public Selection isIn(Collection<String> strings) {
        return this.data.isIn((Collection)strings);
    }

    @Override
    public Selection isNotIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(strings));
        return results;
    }

    @Override
    public Selection isNotIn(Collection<String> strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot((Selection)this.isIn((Collection)strings));
        return results;
    }

    public int firstIndexOf(String value) {
        return this.data.firstIndexOf(value);
    }

    public int countOccurrences(String value) {
        return this.data.countOccurrences(value);
    }

    public String[] asObjectArray() {
        return this.data.asObjectArray();
    }

    @Override
    public StringColumn asStringColumn() {
        return this.copy();
    }

    @Nullable
    public DictionaryMap getDictionary() {
        return this.data;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.get(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return String.valueOf(this.get(row));
    }

    public List<String> top(int n) {
        ArrayList<String> top = new ArrayList<String>();
        StringColumn copy = this.copy();
        copy.sortDescending();
        for (int i = 0; i < n; ++i) {
            top.add((String)copy.get(i));
        }
        return top;
    }

    public List<String> bottom(int n) {
        ArrayList<String> bottom = new ArrayList<String>();
        StringColumn copy = this.copy();
        copy.sortAscending();
        for (int i = 0; i < n; ++i) {
            bottom.add((String)copy.get(i));
        }
        return bottom;
    }

    @Override
    public Column<String> append(Column<String> column, int row) {
        return this.append(column.getUnformattedString(row));
    }

    @Override
    public Column<String> set(int row, Column<String> column, int sourceRow) {
        return this.set(row, column.getUnformattedString(sourceRow));
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public int compare(String o1, String o2) {
        return o1.compareTo(o2);
    }
}

