/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tech.tablesaw.api.Table;
import tech.tablesaw.joining.AbstractJoiner;
import tech.tablesaw.joining.CrossProductJoin;
import tech.tablesaw.joining.JoinStrategy;
import tech.tablesaw.joining.JoinType;
import tech.tablesaw.joining.SortMergeJoin;

public class DataFrameJoiner
extends AbstractJoiner {
    private JoinStrategy strategy;
    private final Table table;
    private final String[] leftJoinColumnNames;
    private String[] rightJoinColumnNames;
    private int[] leftJoinColumnPositions;
    private List<Table> rightTables = new ArrayList<Table>();
    private JoinType joinType = JoinType.INNER;
    private boolean allowDuplicateColumnNames = false;
    private boolean keepAllJoinKeyColumns = false;

    public DataFrameJoiner(Table table, String ... leftJoinColumnNames) {
        this.table = table;
        this.leftJoinColumnNames = leftJoinColumnNames;
        this.rightJoinColumnNames = leftJoinColumnNames;
        this.leftJoinColumnPositions = this.getJoinIndexes(table, leftJoinColumnNames);
    }

    @Override
    public DataFrameJoiner type(JoinType joinType) {
        this.joinType = joinType;
        return this;
    }

    @Override
    public DataFrameJoiner keepAllJoinKeyColumns(boolean keep) {
        this.keepAllJoinKeyColumns = keep;
        return this;
    }

    @Override
    public DataFrameJoiner allowDuplicateColumnNames(boolean allow) {
        this.allowDuplicateColumnNames = allow;
        return this;
    }

    @Override
    public DataFrameJoiner rightJoinColumns(String ... rightJoinColumnNames) {
        Preconditions.checkNotNull((Object)rightJoinColumnNames);
        this.rightJoinColumnNames = rightJoinColumnNames;
        return this;
    }

    @Override
    public DataFrameJoiner with(Table ... tables) {
        Preconditions.checkNotNull((Object)tables);
        this.rightTables = Arrays.stream(tables).collect(Collectors.toList());
        return this;
    }

    @Override
    public Table join() {
        this.selectJoinStrategy();
        if (!this.allowDuplicateColumnNames) {
            Set<String> rightJoinColumns = Set.of(this.rightJoinColumnNames);
            Set<String> leftJoinColumns = Set.of(this.leftJoinColumnNames);
            Set nonJoinColumns = this.table.columnNames().stream().filter(e -> !leftJoinColumns.contains(e)).collect(Collectors.toSet());
            for (Table t : this.rightTables) {
                List names = t.columnNames().stream().filter(e -> !rightJoinColumns.contains(e)).collect(Collectors.toList());
                for (String nm : names) {
                    if (!nonJoinColumns.contains(nm)) {
                        nonJoinColumns.add(nm);
                        continue;
                    }
                    throw new IllegalArgumentException("Attempting to join tables containing non-join columns with at least one name: " + nm + " appears in more than one table. If you would like to join tables containing columns with duplicate names,  the value of 'allowDuplicateColumnNames' must be true");
                }
            }
        }
        return this.performJoin(this.table, this.rightTables);
    }

    private void selectJoinStrategy() {
        int leftRowCount = this.table.rowCount();
        int rightRowCount = this.rightTables.get(0).rowCount();
        int minCardinalityLeft = Integer.MAX_VALUE;
        int minCardinalityRight = Integer.MAX_VALUE;
        for (int i = 0; i < this.rightJoinColumnNames.length; ++i) {
            int cardinality = this.table.column(this.leftJoinColumnNames[i]).countUnique();
            if (cardinality >= minCardinalityLeft) continue;
            minCardinalityLeft = cardinality;
        }
        for (String rightJoinColumnName : this.rightJoinColumnNames) {
            int cardinality = this.rightTables.get(0).column(rightJoinColumnName).countUnique();
            if (cardinality >= minCardinalityRight) continue;
            minCardinalityRight = cardinality;
        }
        this.strategy = (double)leftRowCount / ((double)minCardinalityLeft * 1.0) > 1000.0 || (double)rightRowCount / ((double)minCardinalityRight * 1.0) > 1000.0 ? new SortMergeJoin(this.table, this.leftJoinColumnNames) : new CrossProductJoin(this.table, this.leftJoinColumnNames);
    }

    private int[] getJoinIndexes(Table table, String[] columnNames) {
        int[] results = new int[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String nm = columnNames[i];
            results[i] = table.columnIndex(nm);
        }
        return results;
    }

    private Table performJoin(Table left, List<Table> rightTables) {
        Table result = this.joinInternal(left, rightTables.remove(0), this.joinType, this.allowDuplicateColumnNames, this.keepAllJoinKeyColumns, this.rightJoinColumnNames);
        if (rightTables.isEmpty()) {
            return result;
        }
        this.leftJoinColumnPositions = this.getJoinIndexes(result, this.leftJoinColumnNames);
        return this.performJoin(result, rightTables);
    }

    @Override
    Table joinInternal(Table table1, Table table2, JoinType joinType, boolean allowDuplicates, boolean keepAllJoinKeyColumns, String[] rightJoinColumnPositions) {
        return this.strategy.performJoin(table1, table2, joinType, allowDuplicates, keepAllJoinKeyColumns, this.leftJoinColumnPositions, rightJoinColumnPositions);
    }
}

