/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.booleans;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import java.util.BitSet;
import tech.tablesaw.columns.booleans.BooleanColumnType;
import tech.tablesaw.columns.booleans.BooleanData;
import tech.tablesaw.selection.BitSetBackedSelection;
import tech.tablesaw.selection.Selection;

public class BitSetBooleanData
implements BooleanData {
    private BitSet trueValues = new BitSet();
    private BitSet falseValues = new BitSet();
    private BitSet missingValues = new BitSet();

    public BitSetBooleanData(BitSet trueValues, BitSet falseValues, BitSet missingValues) {
        this.trueValues = trueValues;
        this.falseValues = falseValues;
        this.missingValues = missingValues;
    }

    public BitSetBooleanData(ByteArrayList values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i == 1) {
                this.trueValues.set(i);
                continue;
            }
            if (i == 0) {
                this.falseValues.set(i);
                continue;
            }
            if (i != BooleanColumnType.MISSING_VALUE) continue;
            this.missingValues.set(i);
        }
    }

    public BitSetBooleanData() {
    }

    @Override
    public int size() {
        return Math.max(Math.max(this.trueValues.length(), this.falseValues.length()), this.missingValues.length());
    }

    @Override
    public void add(byte b) {
        int size = this.size();
        if (b == 1) {
            this.trueValues.set(size);
        } else if (b == 0) {
            this.falseValues.set(size);
        } else if (b == BooleanColumnType.MISSING_VALUE) {
            this.missingValues.set(size);
        }
    }

    @Override
    public void clear() {
        this.trueValues.clear();
        this.falseValues.clear();
        this.missingValues.clear();
    }

    @Override
    public void sortAscending() {
        int t = this.trueValues.cardinality();
        int f = this.falseValues.cardinality();
        int m = this.missingValues.cardinality();
        this.trueValues.clear();
        this.falseValues.clear();
        this.missingValues.clear();
        this.missingValues.set(0, m);
        this.falseValues.set(m, m + f);
        this.trueValues.set(m + f, m + f + t);
    }

    @Override
    public void sortDescending() {
        int t = this.trueValues.cardinality();
        int f = this.falseValues.cardinality();
        int m = this.missingValues.cardinality();
        this.trueValues.clear();
        this.falseValues.clear();
        this.missingValues.clear();
        this.trueValues.set(0, t);
        this.falseValues.set(t, t + f);
        this.missingValues.set(t + f, m + f + t);
    }

    @Override
    public BooleanData copy() {
        return new BitSetBooleanData((BitSet)this.trueValues.clone(), (BitSet)this.falseValues.clone(), (BitSet)this.missingValues.clone());
    }

    @Override
    public byte getByte(int i) {
        if (this.trueValues.get(i)) {
            return 1;
        }
        if (this.falseValues.get(i)) {
            return 0;
        }
        return BooleanColumnType.MISSING_VALUE;
    }

    @Override
    public int countFalse() {
        return this.falseValues.cardinality();
    }

    @Override
    public int countTrue() {
        return this.trueValues.cardinality();
    }

    @Override
    public int countMissing() {
        return this.missingValues.cardinality();
    }

    @Override
    public int countUnique() {
        boolean m;
        boolean t = !this.trueValues.isEmpty();
        boolean f = !this.falseValues.isEmpty();
        boolean bl = m = !this.missingValues.isEmpty();
        if (m && f && t) {
            return 3;
        }
        if (m && f || m && t || t && f) {
            return 2;
        }
        if (m || f || t) {
            return 1;
        }
        return 0;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArrayList().toByteArray();
    }

    @Override
    public ByteArrayList toByteArrayList() {
        ByteArrayList arrayList = new ByteArrayList(new byte[this.size()]);
        for (int i = 0; i < this.size(); ++i) {
            if (this.trueValues.get(i)) {
                arrayList.set(i, (byte)1);
                continue;
            }
            if (!this.missingValues.get(i)) continue;
            arrayList.set(i, BooleanColumnType.MISSING_VALUE);
        }
        return arrayList;
    }

    @Override
    public void set(int i, byte b) {
        if (b == 1) {
            this.trueValues.set(i);
            this.falseValues.clear(i);
            this.missingValues.clear(i);
        } else if (b == 0) {
            this.trueValues.clear(i);
            this.falseValues.set(i);
            this.missingValues.clear(i);
        } else if (b == BooleanColumnType.MISSING_VALUE) {
            this.trueValues.clear(i);
            this.falseValues.clear(i);
            this.missingValues.set(i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.trueValues.isEmpty() && this.falseValues.isEmpty();
    }

    @Override
    public boolean contains(byte b) {
        if (b == 1) {
            return !this.trueValues.isEmpty();
        }
        if (b == 0) {
            return !this.falseValues.isEmpty();
        }
        if (b == BooleanColumnType.MISSING_VALUE) {
            return !this.missingValues.isEmpty();
        }
        throw new IllegalArgumentException("The value " + b + " is not a legal byte representation of a boolean value. Only 0, 1, and -1 are valid.");
    }

    @Override
    public Selection asSelection() {
        return this.isTrue();
    }

    @Override
    public Selection isFalse() {
        return new BitSetBackedSelection((BitSet)this.falseValues.clone());
    }

    @Override
    public Selection isTrue() {
        return new BitSetBackedSelection((BitSet)this.trueValues.clone());
    }

    @Override
    public Selection isMissing() {
        return new BitSetBackedSelection((BitSet)this.missingValues.clone());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ size: " + this.size() + ", true: " + this.trueValues.cardinality() + ", false: " + this.falseValues.cardinality() + ", missing: " + this.missingValues.cardinality() + "}";
    }

    @Override
    public byte[] falseBytes() {
        return this.falseValues.toByteArray();
    }

    @Override
    public byte[] trueBytes() {
        return this.trueValues.toByteArray();
    }

    @Override
    public byte[] missingBytes() {
        return this.missingValues.toByteArray();
    }

    @Override
    public void setTrueBytes(byte[] bytes) {
        this.trueValues = BitSet.valueOf(bytes);
    }

    @Override
    public void setFalseBytes(byte[] bytes) {
        this.falseValues = BitSet.valueOf(bytes);
    }

    @Override
    public void setMissingBytes(byte[] bytes) {
        this.missingValues = BitSet.valueOf(bytes);
    }

    public ByteIterator iterator() {
        return new BitSetByteIterator(this);
    }

    static class BitSetByteIterator
    implements ByteIterator {
        final BitSetBooleanData data;
        int current = -1;

        BitSetByteIterator(BitSetBooleanData data) {
            this.data = data;
        }

        public byte nextByte() {
            ++this.current;
            if (this.data.trueValues.get(this.current)) {
                return 1;
            }
            if (this.data.falseValues.get(this.current)) {
                return 0;
            }
            return BooleanColumnType.MISSING_VALUE;
        }

        public boolean hasNext() {
            return this.current < this.data.size() - 1;
        }
    }
}

