/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class Stats {
    private long n;
    private double sum;
    private double mean;
    private double min;
    private double max;
    private double variance;
    private double standardDeviation;
    private double geometricMean;
    private double quadraticMean;
    private double secondMoment;
    private double populationVariance;
    private double sumOfLogs;
    private double sumOfSquares;
    private final String name;

    private Stats(String name) {
        this.name = name;
    }

    public static Stats create(NumericColumn<?> values) {
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        for (int i = 0; i < values.size(); ++i) {
            summaryStatistics.addValue(values.getDouble(i));
        }
        return Stats.getStats(values, summaryStatistics);
    }

    private static Stats getStats(NumericColumn<?> values, SummaryStatistics summaryStatistics) {
        Stats stats = new Stats("Column: " + values.name());
        stats.min = summaryStatistics.getMin();
        stats.max = summaryStatistics.getMax();
        stats.n = summaryStatistics.getN();
        stats.sum = summaryStatistics.getSum();
        stats.variance = summaryStatistics.getVariance();
        stats.populationVariance = summaryStatistics.getPopulationVariance();
        stats.quadraticMean = summaryStatistics.getQuadraticMean();
        stats.geometricMean = summaryStatistics.getGeometricMean();
        stats.mean = summaryStatistics.getMean();
        stats.standardDeviation = summaryStatistics.getStandardDeviation();
        stats.sumOfLogs = summaryStatistics.getSumOfLogs();
        stats.sumOfSquares = summaryStatistics.getSumsq();
        stats.secondMoment = summaryStatistics.getSecondMoment();
        return stats;
    }

    public double range() {
        return this.max - this.min;
    }

    public double standardDeviation() {
        return this.standardDeviation;
    }

    public long n() {
        return this.n;
    }

    public double mean() {
        return this.mean;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double sum() {
        return this.sum;
    }

    public double variance() {
        return this.variance;
    }

    public double sumOfSquares() {
        return this.sumOfSquares;
    }

    public double populationVariance() {
        return this.populationVariance;
    }

    public double sumOfLogs() {
        return this.sumOfLogs;
    }

    public double geometricMean() {
        return this.geometricMean;
    }

    public double quadraticMean() {
        return this.quadraticMean;
    }

    public double secondMoment() {
        return this.secondMoment;
    }

    public Table asTable() {
        Table t = Table.create(this.name);
        StringColumn measure = StringColumn.create("Measure");
        DoubleColumn value = DoubleColumn.create("Value");
        t.addColumns(new Column[]{measure});
        t.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(this.n);
        measure.append("sum");
        value.append(this.sum());
        measure.append("Mean");
        value.append(this.mean());
        measure.append("Min");
        value.append(this.min());
        measure.append("Max");
        value.append(this.max());
        measure.append("Range");
        value.append(this.range());
        measure.append("Variance");
        value.append(this.variance());
        measure.append("Std. Dev");
        value.append(this.standardDeviation());
        return t;
    }

    public Table asTableComplete() {
        Table t = this.asTable();
        StringColumn measure = t.stringColumn("Measure");
        DoubleColumn value = t.doubleColumn("Value");
        measure.append("Sum of Squares");
        value.append(this.sumOfSquares());
        measure.append("Sum of Logs");
        value.append(this.sumOfLogs());
        measure.append("Population Variance");
        value.append(this.populationVariance());
        measure.append("Geometric Mean");
        value.append(this.geometricMean());
        measure.append("Quadratic Mean");
        value.append(this.quadraticMean());
        measure.append("Second Moment");
        value.append(this.secondMoment());
        return t;
    }
}

