/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

final class WindowFrame {
    private final WindowBoundTypes leftBoundType;
    private final int initialLeftBound;
    private final WindowBoundTypes rightBoundType;
    private final int initialRightBound;

    private WindowFrame(WindowBoundTypes leftBoundType, int initialLeftBound, WindowBoundTypes rightBoundType, int initialRightBound) {
        this.leftBoundType = leftBoundType;
        this.initialLeftBound = initialLeftBound;
        this.rightBoundType = rightBoundType;
        this.initialRightBound = initialRightBound;
        this.validateWindow();
    }

    static Builder builder() {
        return new Builder();
    }

    WindowBoundTypes getLeftBoundType() {
        return this.leftBoundType;
    }

    int getInitialLeftBound() {
        return this.initialLeftBound;
    }

    WindowBoundTypes getRightBoundType() {
        return this.rightBoundType;
    }

    int getInitialRightBound() {
        return this.initialRightBound;
    }

    private void validateWindow() {
        String errorMsg = "Invalid Window: " + this.toString() + ".";
        if (this.rightBoundType == this.leftBoundType) {
            Preconditions.checkArgument((this.leftBoundType == WindowBoundTypes.PRECEDING || this.leftBoundType == WindowBoundTypes.FOLLOWING ? 1 : 0) != 0, (Object)errorMsg);
            if (this.leftBoundType == WindowBoundTypes.PRECEDING) {
                Preconditions.checkArgument((this.initialLeftBound < this.initialRightBound ? 1 : 0) != 0, (Object)(errorMsg + " The number preceding at start of the window '" + Math.abs(this.initialLeftBound) + "' must be greater than the number preceding at the end of the window '" + Math.abs(this.initialRightBound) + "'"));
            } else {
                Preconditions.checkArgument((this.initialRightBound > this.initialLeftBound ? 1 : 0) != 0, (Object)(errorMsg + " The number following at start of the window '" + this.initialLeftBound + "' must be less than the number following at the end of the window '" + this.initialRightBound + "'"));
            }
        }
        Preconditions.checkArgument((this.rightBoundType.order >= this.leftBoundType.order ? 1 : 0) != 0, (Object)(errorMsg + ". " + this.leftBoundType + " cannot come before " + this.rightBoundType));
    }

    WindowGrowthType windowGrowthType() {
        if (this.leftBoundType == WindowBoundTypes.UNBOUNDED_PRECEDING && this.rightBoundType == WindowBoundTypes.UNBOUNDED_FOLLOWING) {
            return WindowGrowthType.FIXED;
        }
        if (!(this.leftBoundType != WindowBoundTypes.PRECEDING && this.leftBoundType != WindowBoundTypes.FOLLOWING && this.leftBoundType != WindowBoundTypes.CURRENT_ROW || this.rightBoundType != WindowBoundTypes.PRECEDING && this.rightBoundType != WindowBoundTypes.FOLLOWING && this.rightBoundType != WindowBoundTypes.CURRENT_ROW)) {
            return WindowGrowthType.SLIDING;
        }
        if (this.leftBoundType == WindowBoundTypes.UNBOUNDED_PRECEDING) {
            return WindowGrowthType.FIXED_LEFT;
        }
        return WindowGrowthType.FIXED_RIGHT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowFrame that = (WindowFrame)o;
        return this.initialLeftBound == that.initialLeftBound && this.initialRightBound == that.initialRightBound && this.leftBoundType == that.leftBoundType && this.rightBoundType == that.rightBoundType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.leftBoundType, this.initialLeftBound, this.rightBoundType, this.initialRightBound});
    }

    String toSqlString() {
        Object formatedStart = this.leftBoundType.toString();
        if (this.leftBoundType == WindowBoundTypes.PRECEDING || this.leftBoundType == WindowBoundTypes.FOLLOWING) {
            formatedStart = Math.abs(this.initialLeftBound) + " " + (String)formatedStart;
        }
        Object formattedRightBound = this.rightBoundType.toString();
        if (this.rightBoundType == WindowBoundTypes.PRECEDING || this.rightBoundType == WindowBoundTypes.FOLLOWING) {
            formattedRightBound = Math.abs(this.initialRightBound) + " " + (String)formattedRightBound;
        }
        return "ROWS BETWEEN " + (String)formatedStart + " AND " + (String)formattedRightBound;
    }

    public String toString() {
        return this.toSqlString();
    }

    static final class Builder {
        private WindowBoundTypes leftBoundType = WindowBoundTypes.UNBOUNDED_PRECEDING;
        private int initialLeftBound = 0;
        private WindowBoundTypes rightBoundType = WindowBoundTypes.UNBOUNDED_FOLLOWING;
        private int initialRightBound = 0;

        private Builder() {
        }

        Builder setLeftPreceding(int nRows) {
            Preconditions.checkArgument((nRows > 0 ? 1 : 0) != 0);
            this.leftBoundType = WindowBoundTypes.PRECEDING;
            this.initialLeftBound = nRows * -1;
            return this;
        }

        Builder setLeftCurrentRow() {
            this.leftBoundType = WindowBoundTypes.CURRENT_ROW;
            return this;
        }

        Builder setLeftFollowing(int nRows) {
            Preconditions.checkArgument((nRows > 0 ? 1 : 0) != 0);
            this.leftBoundType = WindowBoundTypes.FOLLOWING;
            this.initialLeftBound = nRows;
            return this;
        }

        Builder setRightPreceding(int nRows) {
            Preconditions.checkArgument((nRows > 0 ? 1 : 0) != 0);
            this.rightBoundType = WindowBoundTypes.PRECEDING;
            this.initialRightBound = nRows * -1;
            return this;
        }

        Builder setRightCurrentRow() {
            this.rightBoundType = WindowBoundTypes.CURRENT_ROW;
            return this;
        }

        Builder setRightFollowing(int nRows) {
            Preconditions.checkArgument((nRows > 0 ? 1 : 0) != 0);
            this.rightBoundType = WindowBoundTypes.FOLLOWING;
            this.initialRightBound = nRows;
            return this;
        }

        public WindowFrame build() {
            return new WindowFrame(this.leftBoundType, this.initialLeftBound, this.rightBoundType, this.initialRightBound);
        }
    }

    static enum WindowGrowthType {
        FIXED,
        FIXED_LEFT,
        FIXED_RIGHT,
        SLIDING;

    }

    static enum WindowBoundTypes {
        UNBOUNDED_PRECEDING(0),
        PRECEDING(1),
        CURRENT_ROW(2),
        FOLLOWING(3),
        UNBOUNDED_FOLLOWING(4);

        private final int order;

        private WindowBoundTypes(int order) {
            this.order = order;
        }
    }
}

