/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import java.util.function.Supplier;
import tech.tablesaw.analytic.FunctionMetaData;
import tech.tablesaw.analytic.NumberingFunction;
import tech.tablesaw.api.ColumnType;

enum NumberingFunctions implements FunctionMetaData
{
    ROW_NUMBER(Implementations::rowNumber),
    RANK(Implementations::rank),
    DENSE_RANK(Implementations::denseRank);

    private final Supplier<NumberingFunction> supplier;

    private NumberingFunctions(Supplier<NumberingFunction> supplier) {
        this.supplier = supplier;
    }

    public NumberingFunction getImplementation() {
        return this.supplier.get();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String functionName() {
        return this.name();
    }

    @Override
    public ColumnType returnType() {
        return ColumnType.INTEGER;
    }

    @Override
    public boolean isCompatibleColumn(ColumnType type) {
        return true;
    }

    static class Implementations {
        Implementations() {
        }

        static NumberingFunction rowNumber() {
            return new NumberingFunction(){
                private int count = 0;

                @Override
                void addEqualRow() {
                    ++this.count;
                }

                @Override
                void addNextRow() {
                    ++this.count;
                }

                @Override
                int getValue() {
                    return this.count;
                }
            };
        }

        static NumberingFunction denseRank() {
            return new NumberingFunction(){
                private int rank = 0;

                @Override
                void addNextRow() {
                    ++this.rank;
                }

                @Override
                void addEqualRow() {
                }

                @Override
                int getValue() {
                    return this.rank;
                }
            };
        }

        static NumberingFunction rank() {
            return new NumberingFunction(){
                private int rank = 0;
                private int numInPrevRank = 1;

                @Override
                void addEqualRow() {
                    ++this.numInPrevRank;
                }

                @Override
                void addNextRow() {
                    this.rank += this.numInPrevRank;
                    this.numInPrevRank = 1;
                }

                @Override
                int getValue() {
                    return this.rank;
                }
            };
        }
    }
}

