/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.NoKeysAvailableException;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class IntDictionaryMap
implements DictionaryMap {
    private static final int MAX_UNIQUE = Integer.MAX_VALUE;
    private static final int MISSING_VALUE = Integer.MAX_VALUE;
    private static final int DEFAULT_RETURN_VALUE = Integer.MIN_VALUE;
    private final IntComparator reverseDictionarySortComparator = (i, i1) -> Comparator.reverseOrder().compare(this.getValueForKey(i), this.getValueForKey(i1));
    private final IntComparator dictionarySortComparator = (i, i1) -> this.getValueForKey(i).compareTo(this.getValueForKey(i1));
    private IntArrayList values = new IntArrayList();
    private AtomicInteger nextIndex = new AtomicInteger(Integer.MIN_VALUE);
    private Int2ObjectMap<String> keyToValue = new Int2ObjectOpenHashMap();
    private Object2IntOpenHashMap<String> valueToKey = new Object2IntOpenHashMap();
    private Int2IntOpenHashMap keyToCount = new Int2IntOpenHashMap();

    IntDictionaryMap(DictionaryMap original) throws NoKeysAvailableException {
        this.valueToKey.defaultReturnValue(Integer.MIN_VALUE);
        this.keyToCount.defaultReturnValue(0);
        for (int i2 = 0; i2 < original.size(); ++i2) {
            String value = original.getValueForIndex(i2);
            this.append(value);
        }
    }

    private IntDictionaryMap(IntDictionaryBuilder builder) {
        this.nextIndex = builder.nextIndex;
        this.keyToValue = builder.keyToValue;
        this.valueToKey = builder.valueToKey;
        this.keyToCount = builder.keyToCount;
        this.values = builder.values;
    }

    private void put(int key, String value) {
        this.keyToValue.put(key, (Object)value);
        this.valueToKey.put((Object)value, key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntDictionaryMap that = (IntDictionaryMap)o;
        boolean a = Objects.equal((Object)this.values, (Object)that.values);
        boolean b = Objects.equal(this.keyToValue, that.keyToValue);
        boolean c = Objects.equal(this.valueToKey, that.valueToKey);
        boolean d = Objects.equal((Object)this.keyToCount, (Object)that.keyToCount);
        boolean e = Objects.equal((Object)this.nextIndex.get(), (Object)that.nextIndex.get());
        return a && b && c && d && e;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reverseDictionarySortComparator, this.dictionarySortComparator, this.values, this.nextIndex, this.keyToValue, this.valueToKey, this.keyToCount});
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public IntArrayList values() {
        return this.values;
    }

    private int getKeyForValue(String value) {
        return this.valueToKey.getInt((Object)value);
    }

    public Int2IntMap.FastEntrySet getKeyCountEntries() {
        return this.keyToCount.int2IntEntrySet();
    }

    public ObjectSet<Int2ObjectMap.Entry<String>> getKeyValueEntries() {
        return this.keyToValue.int2ObjectEntrySet();
    }

    @Override
    public String getValueForIndex(int rowIndex) {
        int k = this.values.getInt(rowIndex);
        return this.getValueForKey(k);
    }

    @Override
    public int getKeyForIndex(int rowIndex) {
        return this.values.getInt(rowIndex);
    }

    private Set<String> categories() {
        return this.valueToKey.keySet();
    }

    private Int2ObjectMap<String> keyToValueMap() {
        return this.keyToValue;
    }

    @Override
    public void sortAscending() {
        int[] elements = this.values.toIntArray();
        IntArrays.parallelQuickSort((int[])elements, (IntComparator)this.dictionarySortComparator);
        this.values = new IntArrayList(elements);
    }

    @Override
    public String getValueForKey(int key) {
        return (String)this.keyToValue.get(key);
    }

    @Override
    public void sortDescending() {
        int[] elements = this.values.toIntArray();
        IntArrays.parallelQuickSort((int[])elements, (IntComparator)this.reverseDictionarySortComparator);
        this.values = new IntArrayList(elements);
    }

    @Override
    public int countOccurrences(String value) {
        return this.keyToCount.get(this.getKeyForValue(value));
    }

    @Override
    public Set<String> asSet() {
        return new HashSet<String>(this.categories());
    }

    @Override
    public int firstIndexOf(String value) {
        return this.values.indexOf(this.getKeyForValue(value));
    }

    @Override
    public String[] asObjectArray() {
        String[] output = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.getValueForIndex(i);
        }
        return output;
    }

    @Override
    public int countUnique() {
        return this.keyToValueMap().size();
    }

    @Override
    public Selection selectIsIn(String ... strings) {
        IntOpenHashSet keys = new IntOpenHashSet(strings.length);
        for (String string : strings) {
            int key = this.getKeyForValue(string);
            if (key == Integer.MIN_VALUE) continue;
            keys.add(key);
        }
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!keys.contains(this.values.getInt(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection selectIsIn(Collection<String> strings) {
        IntOpenHashSet keys = new IntOpenHashSet(strings.size());
        for (String string : strings) {
            int key = this.getKeyForValue(string);
            if (key == Integer.MIN_VALUE) continue;
            keys.add(key);
        }
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!keys.contains(this.values.getInt(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public void append(String value) throws NoKeysAvailableException {
        int key;
        if (value == null || StringColumnType.missingValueIndicator().equals(value)) {
            key = Integer.MAX_VALUE;
            this.put(key, StringColumnType.missingValueIndicator());
        } else {
            key = this.getKeyForValue(value);
        }
        if (key == Integer.MIN_VALUE) {
            key = this.getValueId();
            this.put(key, value);
        }
        this.values.add(key);
        this.keyToCount.addTo(key, 1);
    }

    private int getValueId() throws NoKeysAvailableException {
        int nextValue = this.nextIndex.incrementAndGet();
        if (nextValue >= Integer.MAX_VALUE) {
            String msg = String.format("String column can only contain %d unique values.", Integer.MAX_VALUE);
            throw new NoKeysAvailableException(msg);
        }
        return nextValue;
    }

    private void addValuesToSelection(Selection results, int key) {
        if (key != Integer.MIN_VALUE) {
            int i = 0;
            IntListIterator intListIterator = this.values.iterator();
            while (intListIterator.hasNext()) {
                int next = (Integer)intListIterator.next();
                if (key == next) {
                    results.add(i);
                }
                ++i;
            }
        }
    }

    @Override
    public void set(int rowIndex, String stringValue) throws NoKeysAvailableException {
        int valueId;
        String str = StringColumnType.missingValueIndicator();
        if (stringValue != null) {
            str = stringValue;
        }
        if ((valueId = this.getKeyForValue(str)) == Integer.MIN_VALUE) {
            valueId = this.getValueId();
            this.put(valueId, str);
        }
        int oldKey = this.values.set(rowIndex, valueId);
        this.keyToCount.addTo(valueId, 1);
        if (this.keyToCount.addTo(oldKey, -1) == 1) {
            String obsoleteValue = (String)this.keyToValue.remove(oldKey);
            this.valueToKey.removeInt((Object)obsoleteValue);
            this.keyToCount.remove(oldKey);
        }
    }

    @Override
    public void clear() {
        this.nextIndex = new AtomicInteger(Integer.MIN_VALUE);
        this.values.clear();
        this.keyToValue.clear();
        this.valueToKey.clear();
        this.keyToCount.clear();
    }

    @Override
    public Table countByCategory(String columnName) {
        Table t = Table.create("Column: " + columnName);
        StringColumn categories = StringColumn.create("Category");
        IntColumn counts = IntColumn.create("Count");
        for (Map.Entry entry : this.keyToCount.int2IntEntrySet()) {
            categories.append(this.getValueForKey((Integer)entry.getKey()));
            counts.append((Integer)entry.getValue());
        }
        t.addColumns(new Column[]{categories});
        t.addColumns(new Column[]{counts});
        return t;
    }

    @Override
    public Selection isEqualTo(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int key = this.getKeyForValue(string);
        this.addValuesToSelection(results, key);
        return results;
    }

    @Override
    public List<BooleanColumn> getDummies() {
        ArrayList<BooleanColumn> results = new ArrayList<BooleanColumn>();
        for (Int2ObjectMap.Entry entry : this.keyToValueMap().int2ObjectEntrySet()) {
            BooleanColumn column = BooleanColumn.create((String)entry.getValue());
            results.add(column);
        }
        ObjectIterator objectIterator = this.values.iterator();
        while (objectIterator.hasNext()) {
            int next = (Integer)objectIterator.next();
            String category = this.getValueForKey(next);
            for (BooleanColumn column : results) {
                if (category.equals(column.name())) {
                    column.append(true);
                    continue;
                }
                column.append(false);
            }
        }
        return results;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putInt(this.getKeyForIndex(rowNumber)).array();
    }

    private int byteSize() {
        return 4;
    }

    @Override
    public int countMissing() {
        return this.keyToCount.get(Integer.MAX_VALUE);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private final IntListIterator valuesIt;
            {
                this.valuesIt = IntDictionaryMap.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.valuesIt.hasNext();
            }

            @Override
            public String next() {
                return IntDictionaryMap.this.getValueForKey(this.valuesIt.nextInt());
            }
        };
    }

    @Override
    public void appendMissing() {
        try {
            this.append(StringColumnType.missingValueIndicator());
        }
        catch (NoKeysAvailableException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.getKeyForIndex(rowNumber) == Integer.MAX_VALUE;
    }

    @Override
    public DictionaryMap promoteYourself() {
        return this;
    }

    @Override
    public int nextKeyWithoutIncrementing() {
        return this.nextIndex.get();
    }

    public static class IntDictionaryBuilder {
        private AtomicInteger nextIndex;
        private IntArrayList values;
        private Int2ObjectMap<String> keyToValue;
        private Object2IntOpenHashMap<String> valueToKey;
        private Int2IntOpenHashMap keyToCount;

        public IntDictionaryBuilder setNextIndex(int value) {
            this.nextIndex = new AtomicInteger(value);
            return this;
        }

        public IntDictionaryBuilder setKeyToValue(Int2ObjectMap<String> keyToValue) {
            this.keyToValue = keyToValue;
            return this;
        }

        public IntDictionaryBuilder setValueToKey(Object2IntOpenHashMap<String> valueToKey) {
            this.valueToKey = valueToKey;
            return this;
        }

        public IntDictionaryBuilder setKeyToCount(Int2IntOpenHashMap keyToCount) {
            this.keyToCount = keyToCount;
            return this;
        }

        public IntDictionaryBuilder setValues(int[] data) {
            this.values = new IntArrayList(data);
            return this;
        }

        public IntDictionaryMap build() {
            Preconditions.checkNotNull((Object)this.nextIndex);
            Preconditions.checkNotNull((Object)this.keyToCount);
            Preconditions.checkNotNull(this.keyToValue);
            Preconditions.checkNotNull(this.valueToKey);
            Preconditions.checkNotNull((Object)this.values);
            return new IntDictionaryMap(this);
        }
    }
}

