/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringColumnFormatter;
import tech.tablesaw.columns.strings.StringFilters;
import tech.tablesaw.columns.strings.StringMapFunctions;
import tech.tablesaw.columns.strings.StringReduceUtils;

public abstract class AbstractStringColumn<C extends AbstractColumn<C, String>>
extends AbstractColumn<C, String>
implements CategoricalColumn<String>,
StringFilters,
StringMapFunctions,
StringReduceUtils {
    private StringColumnFormatter printFormatter = new StringColumnFormatter();

    public AbstractStringColumn(ColumnType type, String name, AbstractColumnParser<String> parser) {
        super(type, name, parser);
    }

    public void setPrintFormatter(StringColumnFormatter formatter) {
        Preconditions.checkNotNull((Object)formatter);
        this.printFormatter = formatter;
    }

    public StringColumnFormatter getPrintFormatter() {
        return this.printFormatter;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format((String)this.get(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return String.valueOf(this.get(row));
    }

    public List<String> top(int n) {
        ArrayList<String> top = new ArrayList<String>();
        Column copy = this.copy();
        copy.sortDescending();
        for (int i = 0; i < n; ++i) {
            top.add((String)copy.get(i));
        }
        return top;
    }

    public List<String> bottom(int n) {
        ArrayList<String> bottom = new ArrayList<String>();
        Column copy = this.copy();
        copy.sortAscending();
        for (int i = 0; i < n; ++i) {
            bottom.add((String)copy.get(i));
        }
        return bottom;
    }

    @Override
    public Column<String> append(Column<String> column, int row) {
        return this.append(column.getUnformattedString(row));
    }

    @Override
    public Column<String> set(int row, Column<String> column, int sourceRow) {
        return this.set(row, column.getUnformattedString(sourceRow));
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public int compare(String o1, String o2) {
        return o1.compareTo(o2);
    }
}

