/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import tech.tablesaw.analytic.AggregateFunctions;
import tech.tablesaw.analytic.AnalyticQueryEngine;
import tech.tablesaw.analytic.AnalyticQuerySteps;
import tech.tablesaw.analytic.ArgumentList;
import tech.tablesaw.analytic.NumberingFunctions;
import tech.tablesaw.analytic.WindowFrame;
import tech.tablesaw.analytic.WindowSpecification;
import tech.tablesaw.api.Table;
import tech.tablesaw.sorting.Sort;

public final class AnalyticQuery {
    private final Table table;
    private final WindowSpecification windowSpecification;
    private final WindowFrame windowFrame;
    private final ArgumentList argumentList;

    private AnalyticQuery(Table table, WindowSpecification windowSpecification, WindowFrame windowFrame, ArgumentList argumentList) {
        this.table = table;
        this.windowSpecification = windowSpecification;
        this.windowFrame = windowFrame;
        this.argumentList = argumentList;
    }

    @Beta
    public static AnalyticQuerySteps.FullAnalyticQuerySteps.FromStep query() {
        return new FullQueryBuilder();
    }

    @Beta
    public static AnalyticQuerySteps.NumberingQuerySteps.FromStep numberingQuery() {
        return new NumberingQueryBuilder();
    }

    @Beta
    public static AnalyticQuerySteps.QuickQuerySteps.FromStep quickQuery() {
        return new QuickQueryBuilder();
    }

    public Table getTable() {
        return this.table;
    }

    ArgumentList getArgumentList() {
        return this.argumentList;
    }

    Set<String> getPartitionColumns() {
        return this.windowSpecification.getPartitionColumns();
    }

    Optional<Sort> getSort() {
        return this.windowSpecification.getSort();
    }

    WindowSpecification getWindowSpecification() {
        return this.windowSpecification;
    }

    WindowFrame getWindowFrame() {
        return this.windowFrame;
    }

    public String toSqlLikeString() {
        StringBuilder sb = new StringBuilder();
        if (!this.argumentList.getNewColumnNames().isEmpty()) {
            sb.append("SELECT").append(System.lineSeparator()).append(this.argumentList.toSqlString(this.windowSpecification.getWindowName())).append(System.lineSeparator());
        }
        sb.append("FROM ").append(this.table.name()).append(System.lineSeparator()).append("Window ").append(this.windowSpecification.getWindowName()).append(" AS (").append(System.lineSeparator());
        if (!this.windowSpecification.isEmpty()) {
            sb.append(this.windowSpecification.toSqlString());
        }
        if (this.windowFrame != null) {
            if (!this.windowSpecification.isEmpty()) {
                sb.append(System.lineSeparator());
            }
            sb.append(this.windowFrame.toSqlString());
        }
        sb.append(");");
        return sb.toString();
    }

    public String toString() {
        return this.toSqlLikeString();
    }

    public Table execute() {
        return AnalyticQueryEngine.create(this).execute();
    }

    public void executeInPlace() {
        Table result = this.execute();
        this.table.concat(result);
    }

    static class QuickQueryBuilder
    extends AnalyticBuilder
    implements AnalyticQuerySteps.QuickQuerySteps.FromStep {
        QuickQueryBuilder() {
        }

        @Override
        public AnalyticQuerySteps.DefineWindowFame from(Table table) {
            ((AnalyticBuilder)this).table = table;
            return this;
        }
    }

    static class FullQueryBuilder
    extends AnalyticBuilder
    implements AnalyticQuerySteps.FullAnalyticQuerySteps.FromStep {
        FullQueryBuilder() {
        }

        @Override
        public AnalyticQuerySteps.FullAnalyticQuerySteps.PartitionByStep from(Table table) {
            ((AnalyticBuilder)this).table = table;
            return this;
        }
    }

    static abstract class AnalyticBuilder
    implements AnalyticQuerySteps.FullAnalyticQuerySteps.OrderByOptionalStep,
    AnalyticQuerySteps.FullAnalyticQuerySteps.PartitionByStep,
    AnalyticQuerySteps.DefineWindowFame,
    AnalyticQuerySteps.SetWindowStart,
    AnalyticQuerySteps.SetWindowEndOptionOne,
    AnalyticQuerySteps.SetWindowEndOptionTwo,
    AnalyticQuerySteps.NameStepAggregate,
    AnalyticQuerySteps.AddAggregateFunctions,
    AnalyticQuerySteps.AddAggregateFunctionsWithExecute {
        private Table table;
        private final WindowFrame.Builder frameBuilder = WindowFrame.builder();
        private final WindowSpecification.Builder windowSpecificationBuilder = WindowSpecification.builder();
        private final ArgumentList.Builder argumentsListBuilder = ArgumentList.builder();

        AnalyticBuilder() {
        }

        @Override
        public AnalyticQuerySteps.NameStepAggregate sum(String columnName) {
            this.argumentsListBuilder.stageFunction(columnName, AggregateFunctions.SUM);
            return this;
        }

        @Override
        public AnalyticQuerySteps.NameStepAggregate mean(String columnName) {
            this.argumentsListBuilder.stageFunction(columnName, AggregateFunctions.MEAN);
            return this;
        }

        @Override
        public AnalyticQuerySteps.NameStepAggregate max(String columnName) {
            this.argumentsListBuilder.stageFunction(columnName, AggregateFunctions.MAX);
            return this;
        }

        @Override
        public AnalyticQuerySteps.NameStepAggregate min(String columnName) {
            this.argumentsListBuilder.stageFunction(columnName, AggregateFunctions.MIN);
            return this;
        }

        @Override
        public AnalyticQuerySteps.NameStepAggregate count(String columnName) {
            this.argumentsListBuilder.stageFunction(columnName, AggregateFunctions.COUNT);
            return this;
        }

        @Override
        public AnalyticQuerySteps.FullAnalyticQuerySteps.OrderByOptionalStep partitionBy(String ... columns) {
            this.windowSpecificationBuilder.setPartitionColumns(Arrays.asList(columns));
            return this;
        }

        @Override
        public AnalyticQuerySteps.DefineWindowFame orderBy(String ... columnNames) {
            this.windowSpecificationBuilder.setSort(Sort.create(this.table, columnNames));
            return this;
        }

        @Override
        public AnalyticQuerySteps.SetWindowStart rowsBetween() {
            return this;
        }

        @Override
        public AnalyticQuerySteps.SetWindowEndOptionOne unboundedPreceding() {
            return this;
        }

        @Override
        public AnalyticQuerySteps.SetWindowEndOptionOne preceding(int nRows) {
            this.frameBuilder.setLeftPreceding(nRows);
            return this;
        }

        @Override
        public AnalyticQuerySteps.SetWindowEndOptionTwo currentRow() {
            this.frameBuilder.setLeftCurrentRow();
            return this;
        }

        @Override
        public AnalyticQuerySteps.SetWindowEndOptionTwo following(int nRows) {
            this.frameBuilder.setLeftFollowing(nRows);
            return this;
        }

        @Override
        public AnalyticQuerySteps.AddAggregateFunctions andPreceding(int nRows) {
            this.frameBuilder.setRightPreceding(nRows);
            return this;
        }

        @Override
        public AnalyticQuerySteps.AddAggregateFunctions andCurrentRow() {
            this.frameBuilder.setRightCurrentRow();
            return this;
        }

        @Override
        public AnalyticQuerySteps.AddAggregateFunctions andFollowing(int nRows) {
            this.frameBuilder.setRightFollowing(nRows);
            return this;
        }

        @Override
        public AnalyticQuerySteps.AddAggregateFunctions andUnBoundedFollowing() {
            return this;
        }

        @Override
        public AnalyticQuerySteps.AddAggregateFunctionsWithExecute as(String columnName) {
            this.argumentsListBuilder.unStageFunction(columnName);
            return this;
        }

        @Override
        public AnalyticQuery build() {
            Preconditions.checkNotNull((Object)this.table);
            return new AnalyticQuery(this.table, this.windowSpecificationBuilder.build(), this.frameBuilder.build(), this.argumentsListBuilder.build());
        }

        @Override
        public Table execute() {
            return this.build().execute();
        }

        @Override
        public void executeInPlace() {
            this.build().executeInPlace();
        }
    }

    static class NumberingQueryBuilder
    implements AnalyticQuerySteps.NumberingQuerySteps.FromStep,
    AnalyticQuerySteps.NumberingQuerySteps.OrderByRequiredStep,
    AnalyticQuerySteps.NumberingQuerySteps.PartitionByStep,
    AnalyticQuerySteps.AddNumberingFunction,
    AnalyticQuerySteps.AddNumberingFunctionWithExecute,
    AnalyticQuerySteps.NameStepNumbering {
        private Table table;
        private final WindowSpecification.Builder windowSpecificationBuilder = WindowSpecification.builder();
        private final ArgumentList.Builder argumentsListBuilder = ArgumentList.builder();

        NumberingQueryBuilder() {
        }

        @Override
        public AnalyticQuerySteps.NumberingQuerySteps.PartitionByStep from(Table table) {
            this.table = table;
            return this;
        }

        @Override
        public AnalyticQuerySteps.NumberingQuerySteps.OrderByRequiredStep partitionBy(String ... columnNames) {
            this.windowSpecificationBuilder.setPartitionColumns(Arrays.asList(columnNames));
            return this;
        }

        @Override
        public AnalyticQuerySteps.AddNumberingFunction orderBy(String columnName, String ... columnNames) {
            String[] cols = new String[columnNames.length + 1];
            cols[0] = columnName;
            System.arraycopy(columnNames, 0, cols, 1, columnNames.length);
            this.windowSpecificationBuilder.setSort(Sort.create(this.table, cols));
            return this;
        }

        @Override
        public AnalyticQuerySteps.AddNumberingFunctionWithExecute as(String columnName) {
            this.argumentsListBuilder.unStageFunction(columnName);
            return this;
        }

        @Override
        public AnalyticQuerySteps.NameStepNumbering rowNumber() {
            this.argumentsListBuilder.stageFunction(NumberingFunctions.ROW_NUMBER);
            return this;
        }

        @Override
        public AnalyticQuerySteps.NameStepNumbering rank() {
            this.argumentsListBuilder.stageFunction(NumberingFunctions.RANK);
            return this;
        }

        @Override
        public AnalyticQuerySteps.NameStepNumbering denseRank() {
            this.argumentsListBuilder.stageFunction(NumberingFunctions.DENSE_RANK);
            return this;
        }

        @Override
        public AnalyticQuery build() {
            return new AnalyticQuery(this.table, this.windowSpecificationBuilder.build(), null, this.argumentsListBuilder.build());
        }

        @Override
        public Table execute() {
            return this.build().execute();
        }

        @Override
        public void executeInPlace() {
            this.build().executeInPlace();
        }
    }
}

