/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortComparators;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.numbers.ShortColumnType;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class ShortColumn
extends NumberColumn<ShortColumn, Short>
implements CategoricalColumn<Short> {
    private final ShortArrayList data;

    protected ShortColumn(String name, ShortArrayList data) {
        super(ShortColumnType.instance(), name, ShortColumnType.DEFAULT_PARSER);
        this.setPrintFormatter(NumberColumnFormatter.ints());
        this.data = data;
    }

    public static ShortColumn create(String name) {
        return new ShortColumn(name, new ShortArrayList());
    }

    public static ShortColumn create(String name, short ... arr) {
        return new ShortColumn(name, new ShortArrayList(arr));
    }

    public static ShortColumn create(String name, int initialSize) {
        ShortColumn column = new ShortColumn(name, new ShortArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static ShortColumn create(String name, Short[] arr) {
        return new ShortColumn(name, new ShortArrayList(Shorts.toArray(Arrays.asList(arr))));
    }

    public static ShortColumn create(String name, Stream<Short> stream) {
        ShortColumn column = ShortColumn.create(name);
        stream.forEach(column::append);
        return column;
    }

    @Override
    public ShortColumn createCol(String name, int initialSize) {
        return ShortColumn.create(name, initialSize);
    }

    @Override
    public ShortColumn createCol(String name) {
        return ShortColumn.create(name);
    }

    public static boolean valueIsMissing(int value) {
        return ShortColumnType.valueIsMissing(value);
    }

    @Override
    public Short get(int index) {
        short result = this.getShort(index);
        return this.isMissingValue(result) ? null : Short.valueOf(result);
    }

    public short getShort(int index) {
        return this.data.getShort(index);
    }

    @Override
    public ShortColumn subset(int[] rows) {
        ShortColumn c = this.emptyCopy();
        for (int row : rows) {
            c.append(this.getShort(row));
        }
        return c;
    }

    public Selection isIn(int ... numbers) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntRBTreeSet intSet = new IntRBTreeSet(numbers);
        for (int i = 0; i < this.size(); ++i) {
            if (!intSet.contains(this.getInt(i))) continue;
            results.add(i);
        }
        return results;
    }

    public Selection isNotIn(int ... numbers) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(numbers));
        return results;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public ShortColumn unique() {
        ShortOpenHashSet values = new ShortOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.getShort(i));
        }
        ShortColumn column = ShortColumn.create(this.name() + " Unique values");
        ShortIterator shortIterator = values.iterator();
        while (shortIterator.hasNext()) {
            short value = (Short)shortIterator.next();
            column.append(value);
        }
        return column;
    }

    public ShortColumn top(int n) {
        ShortArrayList top = new ShortArrayList();
        short[] values = this.data.toShortArray();
        ShortArrays.parallelQuickSort((short[])values, (ShortComparator)ShortComparators.OPPOSITE_COMPARATOR);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new ShortColumn(this.name() + "[Top " + n + "]", top);
    }

    public ShortColumn bottom(int n) {
        ShortArrayList bottom = new ShortArrayList();
        short[] values = this.data.toShortArray();
        ShortArrays.parallelQuickSort((short[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new ShortColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public ShortColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        short[] dest = new short[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = ShortColumnType.missingValueIndicator();
        }
        short[] array = this.data.toShortArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new ShortColumn(this.name() + " lag(" + n + ")", new ShortArrayList(dest));
    }

    public ShortColumn removeMissing() {
        ShortColumn result = this.copy();
        result.clear();
        ShortListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            short v = iterator.nextShort();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public ShortColumn append(short i) {
        this.data.add(i);
        return this;
    }

    public ShortColumn append(Short val) {
        if (val == null) {
            this.appendMissing();
        } else {
            this.append((short)val);
        }
        return this;
    }

    @Override
    public ShortColumn emptyCopy() {
        return (ShortColumn)super.emptyCopy();
    }

    @Override
    public ShortColumn emptyCopy(int rowSize) {
        return (ShortColumn)super.emptyCopy(rowSize);
    }

    @Override
    public ShortColumn copy() {
        return new ShortColumn(this.name(), this.data.clone());
    }

    @Override
    public Iterator<Short> iterator() {
        return this.data.iterator();
    }

    public Short[] asObjectArray() {
        Short[] output = new Short[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = !this.isMissing(i) ? Short.valueOf(this.getShort(i)) : null;
        }
        return output;
    }

    @Override
    public int compare(Short o1, Short o2) {
        return Short.compare(o1, o2);
    }

    public ShortColumn set(int i, Short val) {
        return val == null ? this.setMissing(i) : this.set(i, (short)val);
    }

    public ShortColumn set(int i, short val) {
        this.data.set(i, val);
        return this;
    }

    @Override
    public Column<Short> set(int row, String stringValue, AbstractColumnParser<?> parser) {
        return this.set(row, parser.parseShort(stringValue));
    }

    public ShortColumn append(Column<Short> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        ShortColumn numberColumn = (ShortColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getShort(i));
        }
        return this;
    }

    @Override
    public String getString(int row) {
        short value = this.getShort(row);
        return String.valueOf(this.getPrintFormatter().format(value));
    }

    public ShortColumn append(Column<Short> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.append(((ShortColumn)column).getShort(row));
    }

    public ShortColumn set(int row, Column<Short> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((ShortColumn)column).getShort(sourceRow));
    }

    @Override
    public ShortColumn appendMissing() {
        return this.append(ShortColumnType.missingValueIndicator());
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(ShortColumnType.instance().byteSize()).putShort(this.getShort(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        ShortOpenHashSet uniqueElements = new ShortOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            uniqueElements.add(this.getShort(i));
        }
        return uniqueElements.size();
    }

    public int getInt(int row) {
        return this.data.getShort(row);
    }

    @Override
    public double getDouble(int row) {
        short value = this.data.getShort(row);
        if (this.isMissingValue(value)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return value;
    }

    public boolean isMissingValue(short value) {
        return ShortColumnType.valueIsMissing(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getShort(rowNumber));
    }

    public ShortColumn setMissing(int i) {
        return this.set(i, ShortColumnType.missingValueIndicator());
    }

    @Override
    public void sortAscending() {
        this.data.sort(ShortComparators.NATURAL_COMPARATOR);
    }

    @Override
    public void sortDescending() {
        this.data.sort(ShortComparators.OPPOSITE_COMPARATOR);
    }

    public ShortColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Short) {
            return this.append((short)((Short)obj));
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public ShortColumn appendCell(String value) {
        try {
            return this.append(this.parser().parseShort(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public ShortColumn appendCell(String value, AbstractColumnParser<?> parser) {
        try {
            return this.append(parser.parseShort(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        int value = this.getInt(row);
        if (ShortColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public LongColumn asLongColumn() {
        LongColumn result = LongColumn.create(this.name());
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short d = (Short)shortListIterator.next();
            if (ShortColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public FloatColumn asFloatColumn() {
        FloatColumn result = FloatColumn.create(this.name());
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short d = (Short)shortListIterator.next();
            if (ShortColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public DoubleColumn asDoubleColumn() {
        DoubleColumn result = DoubleColumn.create(this.name());
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short d = (Short)shortListIterator.next();
            if (ShortColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public IntColumn asIntColumn() {
        IntColumn result = IntColumn.create(this.name());
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short d = (Short)shortListIterator.next();
            if (ShortColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }
}

