/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.sorting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import tech.tablesaw.api.Table;

public class Sort
implements Iterable<Map.Entry<String, Order>> {
    private final LinkedHashMap<String, Order> sortOrder = new LinkedHashMap();

    public Sort(String columnName, Order order) {
        this.next(columnName, order);
    }

    public static Sort on(String columnName, Order order) {
        return new Sort(columnName, order);
    }

    public Sort next(String columnName, Order order) {
        this.sortOrder.put(columnName, order);
        return this;
    }

    public boolean isEmpty() {
        return this.sortOrder.isEmpty();
    }

    public int size() {
        return this.sortOrder.size();
    }

    public static Sort create(Table table, String ... columnNames) {
        Preconditions.checkArgument((columnNames.length > 0 ? 1 : 0) != 0, (Object)"At least one sort column must provided.");
        Sort key = null;
        Set names = table.columnNames().stream().map(String::toUpperCase).collect(Collectors.toSet());
        for (String columnName : columnNames) {
            Order order = Order.ASCEND;
            if (!names.contains(columnName.toUpperCase())) {
                String prefix = columnName.substring(0, 1);
                Optional<Order> orderOptional = Sort.getOrder(prefix);
                if (!orderOptional.isPresent() && names.contains(columnName.substring(1).toUpperCase())) {
                    throw new IllegalStateException("Column prefix: " + prefix + " is unknown.");
                }
                if (orderOptional.isPresent() && !names.contains(columnName.substring(1).toUpperCase())) {
                    throw new IllegalStateException(String.format("Column %s does not exist in table %s", columnName.substring(1), table.name()));
                }
                if (!orderOptional.isPresent()) {
                    throw new IllegalStateException("Unrecognized Column: '" + columnName + "'");
                }
                columnName = columnName.substring(1);
                order = orderOptional.get();
            }
            if (key == null) {
                key = new Sort(columnName, order);
                continue;
            }
            key.next(columnName, order);
        }
        return key;
    }

    private static Optional<Order> getOrder(String prefix) {
        switch (prefix) {
            case "+": {
                return Optional.of(Order.ASCEND);
            }
            case "-": {
                return Optional.of(Order.DESCEND);
            }
        }
        return Optional.empty();
    }

    @Override
    public Iterator<Map.Entry<String, Order>> iterator() {
        return this.sortOrder.entrySet().iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("order", this.sortOrder).toString();
    }

    public static enum Order {
        ASCEND,
        DESCEND;

    }
}

