/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.csv.CsvWriteOptions;

@Immutable
public final class CsvWriter
implements DataWriter<CsvWriteOptions> {
    private static final CsvWriter INSTANCE = new CsvWriter();
    private static final String nullValue = "";

    public static void register(WriterRegistry registry) {
        registry.registerExtension("csv", INSTANCE);
        registry.registerOptions(CsvWriteOptions.class, INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Table table, CsvWriteOptions options) {
        CsvWriterSettings settings = CsvWriter.createSettings(options);
        com.univocity.parsers.csv.CsvWriter csvWriter = null;
        try {
            csvWriter = new com.univocity.parsers.csv.CsvWriter(options.destination().createWriter(), settings);
            if (options.header()) {
                String[] header = new String[table.columnCount()];
                for (int c = 0; c < table.columnCount(); ++c) {
                    String name = table.column(c).name();
                    header[c] = options.columnNameMap().getOrDefault(name, name);
                }
                csvWriter.writeHeaders(header);
            }
            for (int r = 0; r < table.rowCount(); ++r) {
                String[] entries = new String[table.columnCount()];
                for (int c = 0; c < table.columnCount(); ++c) {
                    AbstractColumn dc;
                    table.get(r, c);
                    DateTimeFormatter dateFormatter = options.dateFormatter();
                    DateTimeFormatter dateTimeFormatter = options.dateTimeFormatter();
                    ColumnType columnType = table.column(c).type();
                    if (dateFormatter != null && columnType.equals(ColumnType.LOCAL_DATE)) {
                        dc = (DateColumn)table.column(c);
                        entries[c] = options.dateFormatter().format(((DateColumn)dc).get(r));
                        continue;
                    }
                    if (dateTimeFormatter != null && columnType.equals(ColumnType.LOCAL_DATE_TIME)) {
                        dc = (DateTimeColumn)table.column(c);
                        entries[c] = options.dateTimeFormatter().format(((DateTimeColumn)dc).get(r));
                        continue;
                    }
                    entries[c] = table.getUnformatted(r, c);
                }
                csvWriter.writeRow(entries);
            }
        }
        finally {
            if (csvWriter != null) {
                csvWriter.flush();
                csvWriter.close();
            }
        }
    }

    protected static CsvWriterSettings createSettings(CsvWriteOptions options) {
        CsvWriterSettings settings = new CsvWriterSettings();
        settings.setNullValue(nullValue);
        if (options.separator() != null) {
            ((CsvFormat)settings.getFormat()).setDelimiter(options.separator().charValue());
        }
        if (options.quoteChar() != null) {
            ((CsvFormat)settings.getFormat()).setQuote(options.quoteChar().charValue());
        }
        if (options.escapeChar() != null) {
            ((CsvFormat)settings.getFormat()).setQuoteEscape(options.escapeChar().charValue());
        }
        if (options.lineEnd() != null) {
            ((CsvFormat)settings.getFormat()).setLineSeparator(options.lineEnd());
        }
        settings.setIgnoreLeadingWhitespaces(options.ignoreLeadingWhitespaces());
        settings.setIgnoreTrailingWhitespaces(options.ignoreTrailingWhitespaces());
        settings.setSkipEmptyLines(false);
        settings.setQuoteAllFields(options.quoteAllFields());
        return settings;
    }

    @Override
    public void write(Table table, Destination dest) {
        this.write(table, CsvWriteOptions.builder(dest).build());
    }

    static {
        CsvWriter.register(Table.defaultWriterRegistry);
    }
}

