/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.interpolation.Interpolator;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.table.RollingColumn;
import tech.tablesaw.util.StringUtils;

public interface Column<T>
extends Iterable<T>,
Comparator<T> {
    public int size();

    public Table summary();

    public T[] asObjectArray();

    public int countMissing();

    default public int countUnique() {
        return this.unique().size();
    }

    public String name();

    public ColumnType type();

    public String getString(int var1);

    public T get(int var1);

    default public T reduce(T initial, BinaryOperator<T> op) {
        Object acc = initial;
        for (Object t : this) {
            acc = op.apply(acc, t);
        }
        return acc;
    }

    default public Optional<T> reduce(BinaryOperator<T> op) {
        boolean first = true;
        Object acc = null;
        for (Object t : this) {
            if (first) {
                acc = t;
                first = false;
                continue;
            }
            acc = op.apply(acc, t);
        }
        return first ? Optional.empty() : Optional.of(acc);
    }

    public void clear();

    public void sortAscending();

    public void sortDescending();

    public boolean isEmpty();

    public IntComparator rowComparator();

    default public String title() {
        return "Column: " + this.name() + System.lineSeparator();
    }

    public Selection isMissing();

    public Selection isNotMissing();

    public int byteSize();

    public byte[] asBytes(int var1);

    default public RollingColumn rolling(int windowSize) {
        return new RollingColumn(this, windowSize);
    }

    public String getUnformattedString(int var1);

    public boolean isMissing(int var1);

    default public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        for (int i = 0; i < this.size(); ++i) {
            builder.append(this.getString(i));
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    default public int columnWidth() {
        int width = this.name().length();
        for (int rowNum = 0; rowNum < this.size(); ++rowNum) {
            width = Math.max(width, StringUtils.length(this.getString(rowNum)));
        }
        return width;
    }

    default public List<T> asList() {
        ArrayList<T> results = new ArrayList<T>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) {
                results.add(null);
                continue;
            }
            results.add(this.get(i));
        }
        return results;
    }

    default public boolean contains(T object) {
        for (int i = 0; i < this.size(); ++i) {
            if (!(object != null ? object.equals(this.get(i)) : this.get(i) == null)) continue;
            return true;
        }
        return false;
    }

    default public int count(Predicate<? super T> test, int max) {
        int count = 0;
        for (Object t : this) {
            if (!test.test(t) || max <= 0 || ++count < max) continue;
            return count;
        }
        return count;
    }

    default public int count(Predicate<? super T> test) {
        return this.count(test, this.size());
    }

    default public boolean allMatch(Predicate<? super T> test) {
        return this.count(test.negate(), 1) == 0;
    }

    default public boolean anyMatch(Predicate<? super T> test) {
        return this.count(test, 1) > 0;
    }

    default public boolean noneMatch(Predicate<? super T> test) {
        return this.count(test, 1) == 0;
    }

    default public Optional<T> max(Comparator<? super T> comp) {
        boolean first = true;
        Object o1 = null;
        for (Object o2 : this) {
            if (first) {
                o1 = o2;
                first = false;
                continue;
            }
            if (comp.compare(o1, o2) >= 0) continue;
            o1 = o2;
        }
        return first ? Optional.empty() : Optional.of(o1);
    }

    default public Optional<T> min(Comparator<? super T> comp) {
        boolean first = true;
        Object o1 = null;
        for (Object o2 : this) {
            if (first) {
                o1 = o2;
                first = false;
                continue;
            }
            if (comp.compare(o1, o2) <= 0) continue;
            o1 = o2;
        }
        return first ? Optional.empty() : Optional.of(o1);
    }

    default public <R, C extends Column<R>> C mapInto(Function<? super T, ? extends R> fun, C into) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) {
                into.setMissing(i);
                continue;
            }
            into.set(i, fun.apply(this.get(i)));
        }
        return into;
    }

    default public <R, C extends Column<R>> C map(Function<? super T, ? extends R> fun, Function<String, C> creator) {
        Column into = (Column)creator.apply(this.name());
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) {
                into.appendMissing();
                continue;
            }
            into.append(fun.apply(this.get(i)));
        }
        return (C)into;
    }

    public Column<T> setMissing(int var1);

    default public Column<T> setMissingTo(T newValue) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.isMissing(i)) continue;
            this.set(i, newValue);
        }
        return this;
    }

    default public Column<T> filter(Predicate<? super T> test) {
        Column result = this.emptyCopy();
        for (Object t : this) {
            if (!test.test(t)) continue;
            result.append(t);
        }
        return result;
    }

    default public Column<T> subset(int[] rows) {
        Column<T> c = this.emptyCopy();
        for (int row : rows) {
            c.appendObj(this.get(row));
        }
        return c;
    }

    default public Column<T> sorted(Comparator<? super T> comp) {
        List<T> list = this.asList();
        list.sort(comp);
        Column<T> result = this.emptyCopy();
        for (T t : list) {
            result.append(t);
        }
        return result;
    }

    public Column<T> emptyCopy();

    public Column<T> copy();

    public Column<T> emptyCopy(int var1);

    default public Column<T> map(Function<? super T, ? extends T> fun) {
        return this.mapInto(fun, this.emptyCopy(this.size()));
    }

    default public Column<T> min(Column<T> other) {
        Preconditions.checkArgument((this.size() == other.size() ? 1 : 0) != 0);
        Column<T> newCol = this.emptyCopy();
        for (int i = 0; i < this.size(); ++i) {
            T otherValue;
            if (this.isMissing(i) || other.isMissing(i)) {
                newCol.appendMissing();
                continue;
            }
            T thisValue = this.get(i);
            int result = this.compare(thisValue, otherValue = other.get(i));
            newCol.append(result <= 0 ? thisValue : otherValue);
        }
        return newCol;
    }

    default public Column<T> max(Column<T> other) {
        Preconditions.checkArgument((this.size() == other.size() ? 1 : 0) != 0);
        Column<T> newCol = this.emptyCopy();
        for (int i = 0; i < this.size(); ++i) {
            T otherValue;
            if (this.isMissing(i) || other.isMissing(i)) {
                newCol.appendMissing();
                continue;
            }
            T thisValue = this.get(i);
            int result = this.compare(thisValue, otherValue = other.get(i));
            newCol.append(result >= 0 ? thisValue : otherValue);
        }
        return newCol;
    }

    default public Column<T> set(Predicate<T> condition, Column<T> other) {
        for (int row = 0; row < this.size(); ++row) {
            if (!condition.test(this.get(row))) continue;
            this.set(row, other.get(row));
        }
        return this;
    }

    default public Column<T> set(Selection condition, Column<T> other) {
        IntIterator intIterator = condition.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, other.get(row));
        }
        return this;
    }

    default public Column<T> lead(int n) {
        return this.lag(-n);
    }

    default public Column<T> set(Selection rowSelection, T newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public Column<T> lag(int var1);

    public Column<T> appendCell(String var1);

    public Column<T> appendCell(String var1, AbstractColumnParser<?> var2);

    public Column<T> set(int var1, T var2);

    default public Column<T> set(int row, String stringValue, AbstractColumnParser<?> parser) {
        AbstractColumnParser<?> typedParser = parser;
        return this.set(row, typedParser.parse(stringValue));
    }

    public Column<T> set(int var1, Column<T> var2, int var3);

    public Column<T> append(T var1);

    public Column<T> append(Column<T> var1);

    public Column<T> append(Column<T> var1, int var2);

    public Column<T> appendObj(Object var1);

    public Column<T> appendMissing();

    public Column<T> where(Selection var1);

    public Column<T> removeMissing();

    public Column<T> unique();

    default public Column<T> first(int numRows) {
        int newRowCount = Math.min(numRows, this.size());
        return this.inRange(0, newRowCount);
    }

    default public Column<T> last(int numRows) {
        int newRowCount = Math.min(numRows, this.size());
        return this.inRange(this.size() - newRowCount, this.size());
    }

    public Column<T> setName(String var1);

    default public Column<T> inRange(int start, int end) {
        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
        Preconditions.checkArgument((end <= this.size() ? 1 : 0) != 0);
        return this.where(Selection.withRange(start, end));
    }

    default public Column<T> sampleN(int n) {
        Preconditions.checkArgument((n > 0 && n < this.size() ? 1 : 0) != 0, (Object)"The number of rows sampled must be greater than 0 and less than the number of rows in the table.");
        return this.where(Selection.selectNRowsAtRandom(n, this.size()));
    }

    default public Column<T> sampleX(double proportion) {
        Preconditions.checkArgument((proportion <= 1.0 && proportion >= 0.0 ? 1 : 0) != 0, (Object)"The sample proportion must be between 0 and 1");
        int tableSize = (int)Math.round((double)this.size() * proportion);
        return this.where(Selection.selectNRowsAtRandom(tableSize, this.size()));
    }

    default public Interpolator<T> interpolate() {
        return new Interpolator(this);
    }

    public StringColumn asStringColumn();

    public int indexOf(Object var1);
}

