/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.aggregate.CrossTab;
import tech.tablesaw.aggregate.PivotTable;
import tech.tablesaw.aggregate.Summarizer;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.QuerySupport;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.AbstractStringColumn;
import tech.tablesaw.io.DataFrameReader;
import tech.tablesaw.io.DataFrameWriter;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.joining.DataFrameJoiner;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.Sort;
import tech.tablesaw.sorting.SortUtils;
import tech.tablesaw.sorting.comparators.IntComparatorChain;
import tech.tablesaw.table.Relation;
import tech.tablesaw.table.Rows;
import tech.tablesaw.table.StandardTableSliceGroup;
import tech.tablesaw.table.TableSlice;
import tech.tablesaw.table.TableSliceGroup;

public class Table
extends Relation
implements Iterable<Row> {
    public static final ReaderRegistry defaultReaderRegistry = new ReaderRegistry();
    public static final WriterRegistry defaultWriterRegistry = new WriterRegistry();
    private final List<Column<?>> columnList = new ArrayList();
    private String name;
    public static final String MELT_VARIABLE_COLUMN_NAME = "variable";
    public static final String MELT_VALUE_COLUMN_NAME = "value";

    private Table() {
    }

    private Table(String name) {
        this.name = name;
    }

    protected Table(String name, Column<?> ... columns) {
        this(name);
        for (Column<?> column : columns) {
            this.addColumns(new Column[]{column});
        }
    }

    protected Table(String name, Collection<Column<?>> columns) {
        this(name);
        for (Column<?> column : columns) {
            this.addColumns(new Column[]{column});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void autoRegisterReadersAndWriters() {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{"tech.tablesaw.io"}).scan();){
            ArrayList classes = new ArrayList();
            classes.addAll(scanResult.getClassesImplementing(DataWriter.class.getName()).getNames());
            classes.addAll(scanResult.getClassesImplementing(DataReader.class.getName()).getNames());
            for (String clazz : classes) {
                try {
                    Class.forName(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                    return;
                }
            }
        }
    }

    public static Table create() {
        return new Table();
    }

    public static Table create(String tableName) {
        return new Table(tableName);
    }

    public static Table create(Column<?> ... columns) {
        return new Table(null, columns);
    }

    public static Table create(Collection<Column<?>> columns) {
        return new Table(null, columns);
    }

    public static Table create(Stream<Column<?>> columns) {
        return new Table(null, columns.collect(Collectors.toList()));
    }

    public static Table create(String name, Column<?> ... columns) {
        return new Table(name, columns);
    }

    public static Table create(String name, Collection<Column<?>> columns) {
        return new Table(name, columns);
    }

    public static Table create(String name, Stream<Column<?>> columns) {
        return new Table(name, columns.collect(Collectors.toList()));
    }

    private static Sort first(String columnName, Sort.Order order) {
        return Sort.on(columnName, order);
    }

    private static Sort getSort(String ... columnNames) {
        Sort key = null;
        for (String s : columnNames) {
            if (key == null) {
                key = Table.first(s, Sort.Order.DESCEND);
                continue;
            }
            key.next(s, Sort.Order.DESCEND);
        }
        return key;
    }

    public static DataFrameReader read() {
        return new DataFrameReader(defaultReaderRegistry);
    }

    public DataFrameWriter write() {
        return new DataFrameWriter(defaultWriterRegistry, this);
    }

    @Override
    public Table addColumns(Column<?> ... cols) {
        for (Column<?> c : cols) {
            this.validateColumn(c);
            this.columnList.add(c);
        }
        return this;
    }

    public void internalAddWithoutValidation(Column<?> c) {
        this.columnList.add(c);
    }

    private void validateColumn(Column<?> newColumn) {
        Preconditions.checkNotNull(newColumn, (Object)("Attempted to add a null to the columns in table " + this.name));
        ArrayList<String> stringList = new ArrayList<String>();
        for (String name : this.columnNames()) {
            stringList.add(name.toLowerCase());
        }
        if (stringList.contains(newColumn.name().toLowerCase())) {
            String message = String.format("Cannot add column with duplicate name %s to table %s", newColumn.name(), this.name);
            throw new IllegalArgumentException(message);
        }
        this.checkColumnSize(newColumn);
    }

    private void checkColumnSize(Column<?> newColumn) {
        if (this.columnCount() != 0) {
            Preconditions.checkArgument((newColumn.size() == this.rowCount() ? 1 : 0) != 0, (Object)("Column " + newColumn.name() + " does not have the same number of rows as the other columns in the table."));
        }
    }

    public Table insertColumn(int index, Column<?> column) {
        this.validateColumn(column);
        this.columnList.add(index, column);
        return this;
    }

    public Table reorderColumns(String ... columnNames) {
        Preconditions.checkArgument((columnNames.length == this.columnCount() ? 1 : 0) != 0);
        Table table = Table.create(this.name);
        for (String name : columnNames) {
            table.addColumns(new Column[]{this.column(name)});
        }
        return table;
    }

    public Table replaceColumn(int colIndex, Column<?> newColumn) {
        this.removeColumns(new Column[]{this.column(colIndex)});
        return this.insertColumn(colIndex, newColumn);
    }

    public Table replaceColumn(String columnName, Column<?> newColumn) {
        int colIndex = this.columnIndex(columnName);
        return this.replaceColumn(colIndex, newColumn);
    }

    public Table replaceColumn(Column<?> newColumn) {
        return this.replaceColumn(newColumn.name(), newColumn);
    }

    @Override
    public Table setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Column<?> column(int columnIndex) {
        return this.columnList.get(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.columnList.size();
    }

    @Override
    public int rowCount() {
        int result = 0;
        if (!this.columnList.isEmpty()) {
            result = this.columnList.get(0).size();
        }
        return result;
    }

    @Override
    public List<Column<?>> columns() {
        return this.columnList;
    }

    public Column<?>[] columnArray() {
        return this.columnList.toArray(new Column[this.columnCount()]);
    }

    @Override
    public List<CategoricalColumn<?>> categoricalColumns(String ... columnNames) {
        ArrayList columns = new ArrayList();
        for (String columnName : columnNames) {
            columns.add(this.categoricalColumn(columnName));
        }
        return columns;
    }

    @Override
    public int columnIndex(String columnName) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).name().equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name));
        }
        return columnIndex;
    }

    @Override
    public int columnIndex(Column<?> column) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).equals(column)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", column.name(), this.name));
        }
        return columnIndex;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<String> columnNames() {
        return this.columnList.stream().map(Column::name).collect(Collectors.toList());
    }

    public Table copy() {
        Table copy = new Table(this.name);
        for (Column<?> column : this.columnList) {
            copy.addColumns(new Column[]{column.emptyCopy(this.rowCount())});
        }
        int[] rows = new int[this.rowCount()];
        for (int i = 0; i < this.rowCount(); ++i) {
            rows[i] = i;
        }
        Rows.copyRowsToTable(rows, this, copy);
        return copy;
    }

    public Table emptyCopy() {
        Table copy = new Table(this.name);
        for (Column<?> column : this.columnList) {
            copy.addColumns(new Column[]{column.emptyCopy()});
        }
        return copy;
    }

    public Table emptyCopy(int rowSize) {
        Table copy = new Table(this.name);
        for (Column<?> column : this.columnList) {
            copy.addColumns(new Column[]{column.emptyCopy(rowSize)});
        }
        return copy;
    }

    public Table[] sampleSplit(double table1Proportion) {
        Table[] tables = new Table[2];
        int table1Count = (int)Math.round((double)this.rowCount() * table1Proportion);
        BitmapBackedSelection table2Selection = new BitmapBackedSelection();
        int i = 0;
        while (i < this.rowCount()) {
            table2Selection.add(i++);
        }
        BitmapBackedSelection table1Selection = new BitmapBackedSelection();
        Selection table1Records = Selection.selectNRowsAtRandom(table1Count, this.rowCount());
        IntIterator intIterator = table1Records.iterator();
        while (intIterator.hasNext()) {
            int table1Record = (Integer)intIterator.next();
            table1Selection.add(table1Record);
        }
        table2Selection.andNot(table1Selection);
        tables[0] = this.where(table1Selection);
        tables[1] = this.where(table2Selection);
        return tables;
    }

    public Table[] stratifiedSampleSplit(CategoricalColumn<?> column, double table1Proportion) {
        Preconditions.checkArgument((boolean)this.containsColumn(column), (Object)"The categorical column must be part of the table, you can create a string column and add it to this table before sampling.");
        Table first = this.emptyCopy();
        Table second = this.emptyCopy();
        this.splitOn(column).asTableList().forEach(tab -> {
            Table[] splits = tab.sampleSplit(table1Proportion);
            first.append(splits[0]);
            second.append(splits[1]);
        });
        return new Table[]{first, second};
    }

    public Table sampleX(double proportion) {
        Preconditions.checkArgument((proportion <= 1.0 && proportion >= 0.0 ? 1 : 0) != 0, (Object)"The sample proportion must be between 0 and 1");
        int tableSize = (int)Math.round((double)this.rowCount() * proportion);
        return this.where(Selection.selectNRowsAtRandom(tableSize, this.rowCount()));
    }

    public Table sampleN(int nRows) {
        Preconditions.checkArgument((nRows > 0 && nRows < this.rowCount() ? 1 : 0) != 0, (Object)"The number of rows sampled must be greater than 0 and less than the number of rows in the table.");
        return this.where(Selection.selectNRowsAtRandom(nRows, this.rowCount()));
    }

    @Override
    public void clear() {
        this.columnList.forEach(Column::clear);
    }

    @Override
    public Table first(int nRows) {
        int newRowCount = Math.min(nRows, this.rowCount());
        return this.inRange(0, newRowCount);
    }

    public Table last(int nRows) {
        int newRowCount = Math.min(nRows, this.rowCount());
        return this.inRange(this.rowCount() - newRowCount, this.rowCount());
    }

    public Table sortOn(int ... columnIndexes) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i : columnIndexes) {
            if (i >= 0) {
                names.add(this.columnList.get(i).name());
                continue;
            }
            names.add("-" + this.columnList.get(-i).name());
        }
        return this.sortOn(names.toArray(new String[names.size()]));
    }

    public Table sortOn(String ... columnNames) {
        return this.sortOn(Sort.create(this, columnNames));
    }

    public Table sortAscendingOn(String ... columnNames) {
        return this.sortOn(columnNames);
    }

    public Table sortDescendingOn(String ... columnNames) {
        Sort key = Table.getSort(columnNames);
        return this.sortOn(key);
    }

    public Table sortOn(Sort key) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0);
        if (key.size() == 1) {
            IntComparator comparator = SortUtils.getComparator(this, key);
            return this.sortOn(comparator);
        }
        IntComparatorChain chain = SortUtils.getChain(this, key);
        return this.sortOn(chain);
    }

    private Table sortOn(IntComparator rowComparator) {
        Table newTable = this.emptyCopy(this.rowCount());
        int[] newRows = this.rows();
        IntArrays.parallelQuickSort((int[])newRows, (IntComparator)rowComparator);
        Rows.copyRowsToTable(newRows, this, newTable);
        return newTable;
    }

    public Table sortOn(Comparator<Row> rowComparator) {
        Row row1 = new Row(this);
        Row row2 = new Row(this);
        return this.sortOn((k1, k2) -> {
            row1.at(k1);
            row2.at(k2);
            return rowComparator.compare(row1, row2);
        });
    }

    private int[] rows() {
        int[] rowIndexes = new int[this.rowCount()];
        for (int i = 0; i < this.rowCount(); ++i) {
            rowIndexes[i] = i;
        }
        return rowIndexes;
    }

    public void addRow(int rowIndex, Table sourceTable) {
        for (int i = 0; i < this.columnCount(); ++i) {
            this.column(i).appendObj(sourceTable.column(i).get(rowIndex));
        }
    }

    public void addRow(Row row) {
        for (int i = 0; i < row.columnCount(); ++i) {
            this.column(i).appendObj(row.getObject(i));
        }
    }

    public Row row(int rowIndex) {
        Row row = new Row(this);
        row.at(rowIndex);
        return row;
    }

    public Table rows(int ... rowNumbers) {
        Preconditions.checkArgument((Ints.max((int[])rowNumbers) <= this.rowCount() ? 1 : 0) != 0);
        return this.where(Selection.with(rowNumbers));
    }

    public Table dropRows(int ... rowNumbers) {
        Preconditions.checkArgument((Ints.max((int[])rowNumbers) <= this.rowCount() ? 1 : 0) != 0);
        Selection selection = Selection.withRange(0, this.rowCount()).andNot(Selection.with(rowNumbers));
        return this.where(selection);
    }

    public Table inRange(int rowCount) {
        Preconditions.checkArgument((rowCount <= this.rowCount() ? 1 : 0) != 0);
        int rowStart = rowCount >= 0 ? 0 : this.rowCount() + rowCount;
        int rowEnd = rowCount >= 0 ? rowCount : this.rowCount();
        return this.where(Selection.withRange(rowStart, rowEnd));
    }

    public Table inRange(int rowStart, int rowEnd) {
        Preconditions.checkArgument((rowEnd <= this.rowCount() ? 1 : 0) != 0);
        return this.where(Selection.withRange(rowStart, rowEnd));
    }

    public Table dropRange(int rowCount) {
        Preconditions.checkArgument((rowCount <= this.rowCount() ? 1 : 0) != 0);
        int rowStart = rowCount >= 0 ? rowCount : 0;
        int rowEnd = rowCount >= 0 ? this.rowCount() : this.rowCount() + rowCount;
        return this.where(Selection.withRange(rowStart, rowEnd));
    }

    public Table dropRange(int rowStart, int rowEnd) {
        Preconditions.checkArgument((rowEnd <= this.rowCount() ? 1 : 0) != 0);
        return this.where(Selection.withoutRange(0, this.rowCount(), rowStart, rowEnd));
    }

    public Table where(Selection selection) {
        Table newTable = this.emptyCopy(selection.size());
        Rows.copyRowsToTable(selection, this, newTable);
        return newTable;
    }

    public Table where(Function<Table, Selection> selection) {
        Table tempTable = this.where(selection.apply(this));
        Table newTable = tempTable.emptyCopy(tempTable.rowCount());
        Rows.copyRowsToTable(selection.apply(this), this, newTable);
        return newTable;
    }

    public Table dropWhere(Function<Table, Selection> selection) {
        return this.where(QuerySupport.not(selection));
    }

    public Table dropWhere(Selection selection) {
        BitmapBackedSelection opposite = new BitmapBackedSelection();
        opposite.addRange(0, this.rowCount());
        opposite.andNot(selection);
        Table newTable = this.emptyCopy(opposite.size());
        Rows.copyRowsToTable(opposite, this, newTable);
        return newTable;
    }

    public Table pivot(CategoricalColumn<?> column1, CategoricalColumn<?> column2, NumericColumn<?> column3, AggregateFunction<?, ?> aggregateFunction) {
        return PivotTable.pivot(this, column1, column2, column3, aggregateFunction);
    }

    public Table pivot(String column1Name, String column2Name, String column3Name, AggregateFunction<?, ?> aggregateFunction) {
        return this.pivot(this.categoricalColumn(column1Name), this.categoricalColumn(column2Name), this.numberColumn(column3Name), aggregateFunction);
    }

    public TableSliceGroup splitOn(String ... columns) {
        return this.splitOn(this.categoricalColumns(columns).toArray(new CategoricalColumn[columns.length]));
    }

    public TableSliceGroup splitOn(CategoricalColumn<?> ... columns) {
        return StandardTableSliceGroup.create(this, columns);
    }

    @Override
    public Table structure() {
        Table t = new Table("Structure of " + this.name());
        IntColumn index = IntColumn.indexColumn("Index", this.columnCount(), 0);
        StringColumn columnName = StringColumn.create("Column Name", this.columnCount());
        StringColumn columnType = StringColumn.create("Column Type", this.columnCount());
        t.addColumns(new Column[]{index});
        t.addColumns(new Column[]{columnName});
        t.addColumns(new Column[]{columnType});
        for (int i = 0; i < this.columnCount(); ++i) {
            Column<?> column = this.columnList.get(i);
            columnType.set(i, column.type().name());
            columnName.set(i, this.columnNames().get(i));
        }
        return t;
    }

    public Table dropDuplicateRows() {
        Table sorted = this.sortOn(this.columnNames().toArray(new String[this.columns().size()]));
        Table temp = this.emptyCopy();
        for (int row = 0; row < this.rowCount(); ++row) {
            if (!temp.isEmpty() && Rows.compareRows(row, sorted, temp)) continue;
            Rows.appendRowToTable(row, sorted, temp);
        }
        return temp;
    }

    public Table dropRowsWithMissingValues() {
        BitmapBackedSelection missing = new BitmapBackedSelection();
        block0: for (int row = 0; row < this.rowCount(); ++row) {
            for (int col = 0; col < this.columnCount(); ++col) {
                Column<?> c = this.column(col);
                if (!c.isMissing(row)) continue;
                missing.add(row);
                continue block0;
            }
        }
        Selection notMissing = Selection.withRange(0, this.rowCount());
        notMissing.andNot(missing);
        Table temp = this.emptyCopy(notMissing.size());
        Rows.copyRowsToTable(notMissing, this, temp);
        return temp;
    }

    public Table select(Column<?> ... columns) {
        return new Table(this.name, columns);
    }

    public Table select(String ... columnNames) {
        return Table.create(this.name, this.columns(columnNames).toArray(new Column[0]));
    }

    @Override
    public Table removeColumns(Column<?> ... columns) {
        this.columnList.removeAll(Arrays.asList(columns));
        return this;
    }

    public Table removeColumnsWithMissingValues() {
        this.removeColumns((Column[])this.columnList.stream().filter(x -> x.countMissing() > 0).toArray(Column[]::new));
        return this;
    }

    public Table retainColumns(Column<?> ... columns) {
        List<Column<?>> retained = Arrays.asList(columns);
        this.columnList.clear();
        this.columnList.addAll(retained);
        return this;
    }

    public Table retainColumns(String ... columnNames) {
        List<Column<?>> retained = this.columns(columnNames);
        this.columnList.clear();
        this.columnList.addAll(retained);
        return this;
    }

    public Table append(Table tableToAppend) {
        for (Column<?> column : this.columnList) {
            Column<?> columnToAppend = tableToAppend.column(column.name());
            column.append(columnToAppend);
        }
        return this;
    }

    public Row appendRow() {
        for (Column<?> column : this.columnList) {
            column.appendMissing();
        }
        return this.row(this.rowCount() - 1);
    }

    public Table concat(Table tableToConcatenate) {
        Preconditions.checkArgument((tableToConcatenate.rowCount() == this.rowCount() ? 1 : 0) != 0, (Object)"Both tables must have the same number of rows to concatenate them.");
        for (Column<?> column : tableToConcatenate.columns()) {
            this.addColumns(new Column[]{column});
        }
        return this;
    }

    public Summarizer summarize(String columName, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(columName), functions);
    }

    public Summarizer summarize(List<String> columnNames, AggregateFunction<?, ?> ... functions) {
        return new Summarizer(this, columnNames, functions);
    }

    public Summarizer summarize(String numericColumn1Name, String numericColumn2Name, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(numericColumn1Name), this.column(numericColumn2Name), functions);
    }

    public Summarizer summarize(String col1Name, String col2Name, String col3Name, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(col1Name), this.column(col2Name), this.column(col3Name), functions);
    }

    public Summarizer summarize(String col1Name, String col2Name, String col3Name, String col4Name, AggregateFunction<?, ?> ... functions) {
        return this.summarize(this.column(col1Name), this.column(col2Name), this.column(col3Name), this.column(col4Name), functions);
    }

    public Summarizer summarize(Column<?> numberColumn, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, numberColumn, function);
    }

    public Summarizer summarize(Column<?> column1, Column<?> column2, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, column1, column2, function);
    }

    public Summarizer summarize(Column<?> column1, Column<?> column2, Column<?> column3, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, column1, column2, column3, function);
    }

    public Summarizer summarize(Column<?> column1, Column<?> column2, Column<?> column3, Column<?> column4, AggregateFunction<?, ?> ... function) {
        return new Summarizer(this, column1, column2, column3, column4, function);
    }

    public Table xTabCounts(String column1Name, String column2Name) {
        return CrossTab.counts(this, this.categoricalColumn(column1Name), this.categoricalColumn(column2Name));
    }

    public Table xTabRowPercents(String column1Name, String column2Name) {
        return CrossTab.rowPercents(this, column1Name, column2Name);
    }

    public Table xTabColumnPercents(String column1Name, String column2Name) {
        return CrossTab.columnPercents(this, column1Name, column2Name);
    }

    public Table xTabTablePercents(String column1Name, String column2Name) {
        return CrossTab.tablePercents(this, column1Name, column2Name);
    }

    public Table xTabPercents(String column1Name) {
        return CrossTab.percents(this, column1Name);
    }

    public Table xTabCounts(String column1Name) {
        return CrossTab.counts(this, column1Name);
    }

    public Table countBy(CategoricalColumn<?> groupingColumn) {
        return groupingColumn.countByCategory();
    }

    public Table countBy(String categoricalColumnName) {
        CategoricalColumn<?> groupingColumn = this.categoricalColumn(categoricalColumnName);
        return groupingColumn.countByCategory();
    }

    public DataFrameJoiner joinOn(String ... columnNames) {
        return new DataFrameJoiner(this, columnNames);
    }

    public Table missingValueCounts() {
        return this.summarize(this.columnNames(), AggregateFunctions.countMissing).apply();
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            private final Row row;
            {
                this.row = new Row(Table.this);
            }

            @Override
            public Row next() {
                return this.row.next();
            }

            @Override
            public boolean hasNext() {
                return this.row.hasNext();
            }
        };
    }

    public Iterator<Row[]> rollingIterator(final int n) {
        return new Iterator<Row[]>(){
            private int currRow = 0;

            @Override
            public Row[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Row[] rows = new Row[n];
                for (int i = 0; i < n; ++i) {
                    rows[i] = new Row(Table.this, this.currRow + i);
                }
                ++this.currRow;
                return rows;
            }

            @Override
            public boolean hasNext() {
                return this.currRow + n <= Table.this.rowCount();
            }
        };
    }

    public Iterator<Row[]> steppingIterator(final int n) {
        return new Iterator<Row[]>(){
            private int currRow = 0;

            @Override
            public Row[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Row[] rows = new Row[n];
                for (int i = 0; i < n; ++i) {
                    rows[i] = new Row(Table.this, this.currRow + i);
                }
                this.currRow += n;
                return rows;
            }

            @Override
            public boolean hasNext() {
                return this.currRow + n <= Table.this.rowCount();
            }
        };
    }

    public Stream<Row> stream() {
        return Streams.stream(this.iterator());
    }

    public Stream<Row[]> steppingStream(int n) {
        return Streams.stream(this.steppingIterator(n));
    }

    public Stream<Row[]> rollingStream(int n) {
        return Streams.stream(this.rollingIterator(n));
    }

    public Table transpose() {
        return this.transpose(false, false);
    }

    public Table transpose(boolean includeColumnHeadingsAsFirstColumn, boolean useFirstColumnForHeadings) {
        if (this.columnCount() == 0) {
            return this;
        }
        int columnOffset = useFirstColumnForHeadings ? 1 : 0;
        ColumnType resultColumnType = this.validateTableHasSingleColumnType(columnOffset);
        Table transposed = Table.create(this.name);
        if (includeColumnHeadingsAsFirstColumn) {
            String columnName = useFirstColumnForHeadings ? this.column(0).name() : "0";
            StringColumn labelColumn = StringColumn.create(columnName);
            for (int i = columnOffset; i < this.columnCount(); ++i) {
                Column<?> columnToTranspose = this.column(i);
                labelColumn.append(columnToTranspose.name());
            }
            transposed.addColumns(new Column[]{labelColumn});
        }
        if (!useFirstColumnForHeadings) {
            return this.transpose(transposed, resultColumnType, row -> String.valueOf(transposed.columnCount()), 0);
        }
        this.transpose(transposed, resultColumnType, row -> String.valueOf(this.get(row, 0)), 1);
        return transposed;
    }

    private ColumnType validateTableHasSingleColumnType(int startingColumn) {
        ColumnType[] columnTypes = this.columnTypes();
        long distinctColumnTypesCount = Arrays.stream(columnTypes).skip(startingColumn).distinct().count();
        if (distinctColumnTypesCount > 1L) {
            throw new IllegalArgumentException("This operation currently only supports tables where value columns are of the same type");
        }
        return columnTypes[startingColumn];
    }

    private Table transpose(Table transposed, ColumnType resultColumnType, IntFunction<String> columnNameExtractor, int startingColumn) {
        for (int row = 0; row < this.rowCount(); ++row) {
            String columnName = columnNameExtractor.apply(row);
            Column<?> column = resultColumnType.create(columnName);
            for (int col = startingColumn; col < this.columnCount(); ++col) {
                column.append(this.column(col), row);
            }
            transposed.addColumns(new Column[]{column});
        }
        return transposed;
    }

    @Beta
    public Table melt(List<String> idVariables, List<NumericColumn<?>> measuredVariables, Boolean dropMissing) {
        Table result = Table.create(this.name);
        for (String idColName : idVariables) {
            result.addColumns(new Column[]{this.column(idColName).type().create(idColName)});
        }
        result.addColumns(new Column[]{StringColumn.create(MELT_VARIABLE_COLUMN_NAME), DoubleColumn.create(MELT_VALUE_COLUMN_NAME)});
        List measureColumnNames = measuredVariables.stream().map(Column::name).collect(Collectors.toList());
        TableSliceGroup slices = this.splitOn(idVariables.toArray(new String[0]));
        for (TableSlice slice : slices) {
            for (Row row : slice) {
                for (String colName : measureColumnNames) {
                    if (dropMissing.booleanValue() && row.isMissing(colName)) continue;
                    this.writeIdVariables(idVariables, result, row);
                    result.stringColumn(MELT_VARIABLE_COLUMN_NAME).append(colName);
                    double value = row.getNumber(colName);
                    result.doubleColumn(MELT_VALUE_COLUMN_NAME).append(value);
                }
            }
        }
        return result;
    }

    private void writeIdVariables(List<String> idVariables, Table result, Row row) {
        for (String id : idVariables) {
            AbstractColumn ic;
            AbstractStringColumn sc;
            Column<?> resultColumn = result.column(id);
            ColumnType columnType = resultColumn.type();
            if (columnType.equals(ColumnType.STRING)) {
                sc = (StringColumn)resultColumn;
                ((StringColumn)sc).append(row.getString(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.TEXT)) {
                sc = (TextColumn)resultColumn;
                ((TextColumn)sc).append(row.getString(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.INTEGER)) {
                ic = (IntColumn)resultColumn;
                ((IntColumn)ic).append(row.getInt(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.LONG)) {
                ic = (LongColumn)resultColumn;
                ((LongColumn)ic).append(row.getLong(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.SHORT)) {
                ic = (ShortColumn)resultColumn;
                ((ShortColumn)ic).append(row.getShort(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.LOCAL_DATE)) {
                ic = (DateColumn)resultColumn;
                ((DateColumn)ic).appendInternal(row.getPackedDate(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.LOCAL_DATE_TIME)) {
                ic = (DateTimeColumn)resultColumn;
                ((DateTimeColumn)ic).appendInternal(row.getPackedDateTime(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.LOCAL_TIME)) {
                ic = (TimeColumn)resultColumn;
                ((TimeColumn)ic).appendInternal(row.getPackedTime(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.INSTANT)) {
                ic = (InstantColumn)resultColumn;
                ((InstantColumn)ic).appendInternal(row.getPackedInstant(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.BOOLEAN)) {
                ic = (BooleanColumn)resultColumn;
                ((BooleanColumn)ic).append(row.getBooleanAsByte(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.DOUBLE)) {
                ic = (DoubleColumn)resultColumn;
                ((DoubleColumn)ic).append(row.getDouble(resultColumn.name()));
                continue;
            }
            if (columnType.equals(ColumnType.FLOAT)) {
                ic = (FloatColumn)resultColumn;
                ((FloatColumn)ic).append(row.getFloat(resultColumn.name()));
                continue;
            }
            throw new IllegalArgumentException("melt() does not support column type " + columnType);
        }
    }

    @Beta
    public Table cast() {
        StringColumn variableNames = this.stringColumn(MELT_VARIABLE_COLUMN_NAME);
        List idColumns = this.columnList.stream().filter(column -> !column.name().equals(MELT_VARIABLE_COLUMN_NAME) && !column.name().equals(MELT_VALUE_COLUMN_NAME)).collect(Collectors.toList());
        Table result = Table.create(this.name);
        for (Object idColumn : idColumns) {
            result.addColumns(new Column[]{idColumn.type().create(idColumn.name())});
        }
        StringColumn uniqueVariableNames = variableNames.unique();
        for (String varName : uniqueVariableNames) {
            result.addColumns(new Column[]{DoubleColumn.create(varName)});
        }
        TableSliceGroup slices = this.splitOn((String[])idColumns.stream().map(Column::name).toArray(String[]::new));
        for (TableSlice slice : slices) {
            Table sliceTable = slice.asTable();
            for (Column idColumn : idColumns) {
                AbstractColumn dest;
                AbstractColumn source;
                ColumnType columnType = idColumn.type();
                if (columnType.equals(ColumnType.STRING)) {
                    source = (StringColumn)sliceTable.column(idColumn.name());
                    dest = (StringColumn)result.column(idColumn.name());
                    ((StringColumn)dest).append(((StringColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.TEXT)) {
                    source = (TextColumn)sliceTable.column(idColumn.name());
                    dest = (TextColumn)result.column(idColumn.name());
                    ((TextColumn)dest).append(((TextColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.INTEGER)) {
                    source = (IntColumn)sliceTable.column(idColumn.name());
                    dest = (IntColumn)result.column(idColumn.name());
                    ((IntColumn)dest).append(((IntColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.LONG)) {
                    source = (LongColumn)sliceTable.column(idColumn.name());
                    dest = (LongColumn)result.column(idColumn.name());
                    ((LongColumn)dest).append(((LongColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.SHORT)) {
                    source = (ShortColumn)sliceTable.column(idColumn.name());
                    dest = (ShortColumn)result.column(idColumn.name());
                    ((ShortColumn)dest).append(((ShortColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.BOOLEAN)) {
                    source = (BooleanColumn)sliceTable.column(idColumn.name());
                    dest = (BooleanColumn)result.column(idColumn.name());
                    ((BooleanColumn)dest).append(((BooleanColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.LOCAL_DATE)) {
                    source = (DateColumn)sliceTable.column(idColumn.name());
                    dest = (DateColumn)result.column(idColumn.name());
                    ((DateColumn)dest).append(((DateColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.LOCAL_DATE_TIME)) {
                    source = (DateTimeColumn)sliceTable.column(idColumn.name());
                    dest = (DateTimeColumn)result.column(idColumn.name());
                    ((DateTimeColumn)dest).append(((DateTimeColumn)source).get(0));
                    continue;
                }
                if (columnType.equals(ColumnType.INSTANT)) {
                    source = (InstantColumn)sliceTable.column(idColumn.name());
                    dest = (InstantColumn)result.column(idColumn.name());
                    ((InstantColumn)dest).append(((InstantColumn)source).get(0));
                    continue;
                }
                if (!columnType.equals(ColumnType.LOCAL_TIME)) continue;
                source = (TimeColumn)sliceTable.column(idColumn.name());
                dest = (TimeColumn)result.column(idColumn.name());
                ((TimeColumn)dest).append(((TimeColumn)source).get(0));
            }
            for (String varName : uniqueVariableNames) {
                DoubleColumn dest = (DoubleColumn)result.column(varName);
                Table sliceRow = sliceTable.where(sliceTable.stringColumn(MELT_VARIABLE_COLUMN_NAME).isEqualTo(varName));
                if (!sliceRow.isEmpty()) {
                    dest.append(sliceRow.doubleColumn(MELT_VALUE_COLUMN_NAME).get(0));
                    continue;
                }
                dest.appendMissing();
            }
        }
        return result;
    }

    @Deprecated
    public void doWithRows(Consumer<Row> doable) {
        this.stream().forEach(doable);
    }

    @Deprecated
    public boolean detect(Predicate<Row> predicate) {
        return this.stream().anyMatch(predicate);
    }

    @Deprecated
    public void stepWithRows(Consumer<Row[]> rowConsumer, int n) {
        this.steppingStream(n).forEach(rowConsumer);
    }

    @Deprecated
    public void doWithRows(Pairs pairs) {
        this.rollingStream(2).forEach(rows -> pairs.doWithPair(rows[0], rows[1]));
    }

    @Deprecated
    public void doWithRowPairs(Consumer<RowPair> pairConsumer) {
        this.rollingStream(2).forEach(rows -> pairConsumer.accept(new RowPair(rows[0], rows[1])));
    }

    @Deprecated
    public void rollWithRows(Consumer<Row[]> rowConsumer, int n) {
        this.rollingStream(n).forEach(rowConsumer);
    }

    static {
        Table.autoRegisterReadersAndWriters();
    }

    @Deprecated
    static interface Pairs {
        public void doWithPair(Row var1, Row var2);

        default public Object getResult() {
            throw new UnsupportedOperationException("This Pairs function returns no results");
        }
    }

    @Deprecated
    public static class RowPair {
        private final Row first;
        private final Row second;

        public RowPair(Row first, Row second) {
            this.first = first;
            this.second = second;
        }

        public Row getFirst() {
            return this.first;
        }

        public Row getSecond() {
            return this.second;
        }
    }
}

