/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.stream.IntStream;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;

public class IntColumn
extends NumberColumn<IntColumn, Integer>
implements CategoricalColumn<Integer> {
    private final IntArrayList data;

    protected IntColumn(String name, IntArrayList data) {
        super(IntColumnType.instance(), name);
        this.setPrintFormatter(NumberColumnFormatter.ints());
        this.data = data;
    }

    public static IntColumn create(String name) {
        return new IntColumn(name, new IntArrayList());
    }

    public static IntColumn create(String name, int ... arr) {
        return new IntColumn(name, new IntArrayList(arr));
    }

    public static IntColumn create(String name, Integer[] arr) {
        IntColumn newColumn = IntColumn.create(name, 0);
        for (Integer integer : arr) {
            newColumn.append(integer);
        }
        return newColumn;
    }

    public static IntColumn create(String name, int initialSize) {
        IntColumn column = new IntColumn(name, new IntArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static IntColumn create(String name, IntStream stream) {
        IntArrayList list = new IntArrayList();
        stream.forEach(arg_0 -> ((IntArrayList)list).add(arg_0));
        return new IntColumn(name, list);
    }

    @Override
    public IntColumn createCol(String name, int initialSize) {
        return IntColumn.create(name, initialSize);
    }

    @Override
    public IntColumn createCol(String name) {
        return IntColumn.create(name);
    }

    public static IntColumn indexColumn(String columnName, int size, int startsWith) {
        IntColumn indexColumn = IntColumn.create(columnName, size);
        for (int i = 0; i < size; ++i) {
            indexColumn.set(i, i + startsWith);
        }
        return indexColumn;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public static boolean valueIsMissing(int value) {
        return IntColumnType.valueIsMissing(value);
    }

    @Override
    public Integer get(int index) {
        int result = this.getInt(index);
        return this.isMissingValue(result) ? null : Integer.valueOf(result);
    }

    @Override
    public IntColumn subset(int[] rows) {
        IntColumn c = (IntColumn)this.emptyCopy();
        for (int row : rows) {
            c.append(this.getInt(row));
        }
        return c;
    }

    public IntColumn unique() {
        IntOpenHashSet values = new IntOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.getInt(i));
        }
        IntColumn column = IntColumn.create(this.name() + " Unique values");
        IntIterator intIterator = values.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            column.append(value);
        }
        return column;
    }

    public IntColumn top(int n) {
        IntArrayList top = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)IntComparators.OPPOSITE_COMPARATOR);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new IntColumn(this.name() + "[Top " + n + "]", top);
    }

    public IntColumn bottom(int n) {
        IntArrayList bottom = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new IntColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public IntColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        int[] dest = new int[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = IntColumnType.missingValueIndicator();
        }
        int[] array = this.data.toIntArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new IntColumn(this.name() + " lag(" + n + ")", new IntArrayList(dest));
    }

    public IntColumn removeMissing() {
        IntColumn result = this.copy();
        result.clear();
        IntListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            int v = iterator.nextInt();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public IntColumn append(int i) {
        this.data.add(i);
        return this;
    }

    public IntColumn append(Integer val) {
        if (val == null) {
            this.appendMissing();
        } else {
            this.append((int)val);
        }
        return this;
    }

    @Override
    public IntColumn copy() {
        return new IntColumn(this.name(), this.data.clone());
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.data.iterator();
    }

    public Integer[] asObjectArray() {
        Integer[] output = new Integer[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = !this.isMissing(i) ? Integer.valueOf(this.getInt(i)) : null;
        }
        return output;
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return Integer.compare(o1, o2);
    }

    public IntColumn set(int i, Integer val) {
        return this.set(i, (int)val);
    }

    public IntColumn set(int i, int val) {
        this.data.set(i, val);
        return this;
    }

    public IntColumn append(Column<Integer> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        IntColumn numberColumn = (IntColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getInt(i));
        }
        return this;
    }

    public IntColumn append(Column<Integer> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.append(((IntColumn)column).getInt(row));
    }

    public IntColumn set(int row, Column<Integer> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((IntColumn)column).getInt(sourceRow));
    }

    @Override
    public Column<Integer> set(int row, String stringValue, AbstractColumnParser<?> parser) {
        return this.set(row, parser.parseInt(stringValue));
    }

    @Override
    public IntColumn appendMissing() {
        return this.append(IntColumnType.missingValueIndicator());
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(IntColumnType.instance().byteSize()).putInt(this.getInt(rowNumber)).array();
    }

    @Override
    public String getString(int row) {
        int value = this.getInt(row);
        if (IntColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(this.getPrintFormatter().format(value));
    }

    @Override
    public int countUnique() {
        IntOpenHashSet uniqueElements = new IntOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            uniqueElements.add(this.getInt(i));
        }
        return uniqueElements.size();
    }

    public int getInt(int row) {
        return this.data.getInt(row);
    }

    @Override
    public double getDouble(int row) {
        int value = this.data.getInt(row);
        if (this.isMissingValue(value)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return value;
    }

    public boolean isMissingValue(int value) {
        return IntColumnType.valueIsMissing(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getInt(rowNumber));
    }

    @Override
    public void sortAscending() {
        this.data.sort(IntComparators.NATURAL_COMPARATOR);
    }

    @Override
    public void sortDescending() {
        this.data.sort(IntComparators.OPPOSITE_COMPARATOR);
    }

    public IntColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Integer) {
            return this.append((int)((Integer)obj));
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public IntColumn appendCell(String value) {
        try {
            return this.append(IntColumnType.DEFAULT_PARSER.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public IntColumn appendCell(String value, AbstractColumnParser<?> parser) {
        try {
            return this.append(parser.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        int value = this.getInt(row);
        if (IntColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public LongColumn asLongColumn() {
        LongColumn result = LongColumn.create(this.name());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int d = (Integer)intListIterator.next();
            if (IntColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public FloatColumn asFloatColumn() {
        FloatColumn result = FloatColumn.create(this.name());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int d = (Integer)intListIterator.next();
            if (IntColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public DoubleColumn asDoubleColumn() {
        DoubleColumn result = DoubleColumn.create(this.name());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int d = (Integer)intListIterator.next();
            if (IntColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public ShortColumn asShortColumn() {
        ShortColumn result = ShortColumn.create(this.name());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int d = (Integer)intListIterator.next();
            if (IntColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((short)d);
        }
        return result;
    }

    public IntColumn setMissing(int r) {
        this.set(r, IntColumnType.missingValueIndicator());
        return this;
    }
}

