/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.table.TableSlice;
import tech.tablesaw.table.TableSliceGroup;

public class StandardTableSliceGroup
extends TableSliceGroup {
    private StandardTableSliceGroup(Table original, CategoricalColumn<?> ... columns) {
        super(original, StandardTableSliceGroup.splitColumnNames(columns));
        this.setSourceTable(this.getSourceTable());
        this.splitOn(this.getSplitColumnNames());
    }

    private static String[] splitColumnNames(CategoricalColumn<?> ... columns) {
        String[] splitColumnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            splitColumnNames[i] = columns[i].name();
        }
        return splitColumnNames;
    }

    public static StandardTableSliceGroup create(Table original, String ... columnsNames) {
        List<CategoricalColumn<?>> columns = original.categoricalColumns(columnsNames);
        return new StandardTableSliceGroup(original, columns.toArray(new CategoricalColumn[0]));
    }

    public static StandardTableSliceGroup create(Table original, CategoricalColumn<?> ... columns) {
        return new StandardTableSliceGroup(original, columns);
    }

    private void splitOn(String ... columnNames) {
        LinkedHashMap<ByteArray, Selection> selectionMap = new LinkedHashMap<ByteArray, Selection>();
        HashMap<ByteArray, String> sliceNameMap = new HashMap<ByteArray, String>();
        List<Column<?>> splitColumns = this.getSourceTable().columns(columnNames);
        int byteSize = this.getByteSize(splitColumns);
        int i = 0;
        while (i < this.getSourceTable().rowCount()) {
            StringBuilder stringKey = new StringBuilder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(byteSize);
            int count = 0;
            for (Column<?> col : splitColumns) {
                stringKey.append(col.getString(i));
                if (count < splitColumns.size() - 1) {
                    stringKey.append("~~~");
                }
                byteBuffer.put(col.asBytes(i));
                ++count;
            }
            ByteArray byteArray = new ByteArray(byteBuffer.array());
            Selection selection = selectionMap.getOrDefault(byteArray, new BitmapBackedSelection());
            selection.add(i++);
            selectionMap.put(byteArray, selection);
            sliceNameMap.put(byteArray, stringKey.toString());
        }
        for (Map.Entry entry : selectionMap.entrySet()) {
            TableSlice slice = new TableSlice(this.getSourceTable(), (Selection)entry.getValue());
            slice.setName((String)sliceNameMap.get(entry.getKey()));
            this.addSlice(slice);
        }
    }

    private static class ByteArray {
        final byte[] bytes;

        ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArray byteArray = (ByteArray)o;
            return Arrays.equals(this.bytes, byteArray.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }
}

