/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringPredicates;
import tech.tablesaw.filtering.StringFilterSpec;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface StringFilters
extends Column<String>,
StringFilterSpec<Selection> {
    default public Selection eval(BiPredicate<String, String> predicate, Column<String> otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), otherColumn.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<String, String> predicate, String value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<String, Integer> predicate, Integer value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<String> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection equalsIgnoreCase(String string) {
        return this.eval(StringPredicates.isEqualToIgnoringCase, string);
    }

    @Override
    default public Selection isEmptyString() {
        return this.eval(StringPredicates.isEmpty);
    }

    @Override
    default public Selection startsWith(String string) {
        return this.eval(StringPredicates.startsWith, string);
    }

    @Override
    default public Selection endsWith(String string) {
        return this.eval(StringPredicates.endsWith, string);
    }

    @Override
    default public Selection containsString(String string) {
        return this.eval(StringPredicates.stringContains, string);
    }

    @Override
    default public Selection matchesRegex(String string) {
        return this.eval(StringPredicates.matchesRegex, string);
    }

    @Override
    default public Selection isAlpha() {
        return this.eval(StringPredicates.isAlpha);
    }

    @Override
    default public Selection isNumeric() {
        return this.eval(StringPredicates.isNumeric);
    }

    @Override
    default public Selection isAlphaNumeric() {
        return this.eval(StringPredicates.isAlphaNumeric);
    }

    @Override
    default public Selection isUpperCase() {
        return this.eval(StringPredicates.isUpperCase);
    }

    @Override
    default public Selection isLowerCase() {
        return this.eval(StringPredicates.isLowerCase);
    }

    @Override
    default public Selection lengthEquals(int stringLength) {
        return this.eval(StringPredicates.hasEqualLengthTo, stringLength);
    }

    @Override
    default public Selection isShorterThan(int stringLength) {
        return this.eval(StringPredicates.isShorterThan, stringLength);
    }

    @Override
    default public Selection isLongerThan(int stringLength) {
        return this.eval(StringPredicates.isLongerThan, stringLength);
    }

    @Override
    public Selection isIn(String ... var1);

    @Override
    public Selection isIn(Collection<String> var1);

    @Override
    public Selection isNotIn(String ... var1);

    @Override
    public Selection isNotIn(Collection<String> var1);

    @Override
    default public Selection isEqualTo(Column<String> other) {
        return this.eval(StringPredicates.isEqualTo, other);
    }

    @Override
    default public Selection isNotEqualTo(Column<String> other) {
        return this.eval(StringPredicates.isNotEqualTo, other);
    }

    @Override
    default public Selection equalsIgnoreCase(Column<String> other) {
        return this.eval(StringPredicates.isEqualToIgnoringCase, other);
    }

    @Override
    default public Selection startsWith(Column<String> other) {
        return this.eval(StringPredicates.startsWith, other);
    }

    @Override
    default public Selection isMissing() {
        return this.eval(StringPredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(StringPredicates.isNotMissing);
    }

    @Override
    default public Selection isEqualTo(String string) {
        return this.eval(StringPredicates.isEqualTo, string);
    }

    @Override
    default public Selection isNotEqualTo(String string) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(0, this.size());
        selection.andNot(this.isEqualTo(string));
        return selection;
    }

    @Override
    public String get(int var1);
}

