/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.columns.numbers.DoubleColumnType;

public interface NumberMapFunctions {
    default public DoubleColumn normalize() {
        double[] result = StatUtils.normalize((double[])this.asDoubleArray());
        return DoubleColumn.create(this.name() + " normalized", result);
    }

    public String name();

    public int size();

    public boolean isEmpty();

    public double[] asDoubleArray();

    default public DoubleColumn asRatio() {
        DoubleColumn pctColumn = DoubleColumn.create(this.name() + " percents", this.size());
        double total = this.sum();
        for (int i = 0; i < this.size(); ++i) {
            if (total == 0.0) continue;
            pctColumn.set(i, this.getDouble(i) / total);
        }
        return pctColumn;
    }

    public double sum();

    default public DoubleColumn asPercent() {
        DoubleColumn pctColumn = DoubleColumn.create(this.name() + " percents", this.size());
        double total = this.sum();
        for (int i = 0; i < this.size(); ++i) {
            if (total == 0.0) continue;
            pctColumn.set(i, this.getDouble(i) / total * 100.0);
        }
        return pctColumn;
    }

    default public DoubleColumn subtract(NumericColumn<?> column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " - " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.set(r, this.subtract(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn add(NumericColumn<?> column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " + " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.set(r, this.add(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn multiply(NumericColumn<?> column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " * " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.set(r, this.multiply(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn divide(NumericColumn<?> column2) {
        int col2Size;
        int col1Size = this.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        DoubleColumn result = DoubleColumn.create(this.name() + " / " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.set(r, this.divide(this.getDouble(r), column2.getDouble(r)));
        }
        return result;
    }

    default public DoubleColumn add(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " + " + val, this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.set(i, this.add(this.getDouble(i), val));
        }
        return result;
    }

    default public DoubleColumn subtract(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " - " + val, this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.set(i, this.subtract(this.getDouble(i), val));
        }
        return result;
    }

    default public DoubleColumn divide(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " / " + val, this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.set(i, this.divide(this.getDouble(i), val));
        }
        return result;
    }

    default public DoubleColumn multiply(Number value) {
        double val = value.doubleValue();
        DoubleColumn result = DoubleColumn.create(this.name() + " * " + val, this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.set(i, this.multiply(this.getDouble(i), val));
        }
        return result;
    }

    default public double add(double val1, double val2) {
        if (DoubleColumnType.valueIsMissing(val1) || DoubleColumnType.valueIsMissing(val2)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return val1 + val2;
    }

    default public double multiply(double val1, double val2) {
        if (DoubleColumnType.valueIsMissing(val1) || DoubleColumnType.valueIsMissing(val2)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return val1 * val2;
    }

    default public double divide(double val1, double val2) {
        if (DoubleColumnType.valueIsMissing(val1) || DoubleColumnType.valueIsMissing(val2)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return val1 / val2;
    }

    default public double subtract(double val1, double val2) {
        if (DoubleColumnType.valueIsMissing(val1) || DoubleColumnType.valueIsMissing(val2)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return val1 - val2;
    }

    default public DoubleColumn power(double power) {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[pow]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.pow(this.getDouble(i), power));
        }
        return newColumn;
    }

    default public DoubleColumn power(NumericColumn<?> powerColumn) {
        DoubleColumn result = DoubleColumn.create(this.name() + "[pow]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.set(i, Math.pow(this.getDouble(i), powerColumn.getDouble(i)));
        }
        return result;
    }

    default public DoubleColumn reciprocal() {
        DoubleColumn result = DoubleColumn.create(this.name() + "[1/n]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) {
                result.setMissing(i);
                continue;
            }
            result.set(i, 1.0 / this.getDouble(i));
        }
        return result;
    }

    default public DoubleColumn square() {
        DoubleColumn newColumn = this.power(2.0);
        newColumn.setName(this.name() + "[sq]");
        return newColumn;
    }

    default public DoubleColumn sqrt() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[sqrt]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.sqrt(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn cubeRoot() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[cbrt]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.cbrt(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn cube() {
        DoubleColumn newColumn = this.power(3.0);
        newColumn.setName(this.name() + "[cb]");
        return newColumn;
    }

    default public DoubleColumn remainder(DoubleColumn column2) {
        DoubleColumn result = DoubleColumn.create(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            double val1 = this.getDouble(r);
            double val2 = column2.getDouble(r);
            if (DoubleColumnType.valueIsMissing(val1) || DoubleColumnType.valueIsMissing(val2)) {
                result.setMissing(r);
                continue;
            }
            result.set(r, this.getDouble(r) % column2.getDouble(r));
        }
        return result;
    }

    default public DoubleColumn remainder(double val2) {
        DoubleColumn result = DoubleColumn.create(this.name() + " % " + val2, this.size());
        for (int r = 0; r < this.size(); ++r) {
            double val1 = this.getDouble(r);
            if (DoubleColumnType.valueIsMissing(val1) || DoubleColumnType.valueIsMissing(val2)) {
                result.setMissing(r);
                continue;
            }
            result.set(r, this.getDouble(r) % val2);
        }
        return result;
    }

    default public DoubleColumn logN() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[logN]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.log(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn log10() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[log10]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.log10(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn log1p() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[1og1p]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.log1p(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn round() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[rounded]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.round(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn roundInt() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[rounded]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, (int)Math.round(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn abs() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[abs]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, Math.abs(this.getDouble(i)));
        }
        return newColumn;
    }

    default public DoubleColumn neg() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[neg]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            newColumn.set(i, this.getDouble(i) * -1.0);
        }
        return newColumn;
    }

    default public DoubleColumn difference() {
        DoubleColumn returnValue = DoubleColumn.create(this.name(), this.size());
        if (this.isEmpty()) {
            return returnValue;
        }
        returnValue.setMissing(0);
        for (int current = 1; current < this.size(); ++current) {
            returnValue.set(current, this.subtract(this.getDouble(current), this.getDouble(current - 1)));
        }
        return returnValue;
    }

    default public DoubleColumn cumSum() {
        double total = 0.0;
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[cumSum]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            double value = this.getDouble(i);
            if (!DoubleColumnType.valueIsMissing(value)) {
                total += value;
            }
            newColumn.set(i, total);
        }
        return newColumn;
    }

    default public DoubleColumn cumProd() {
        double total = 1.0;
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[cumProd]", this.size());
        for (int i = 0; i < this.size(); ++i) {
            double value = this.getDouble(i);
            if (!DoubleColumnType.valueIsMissing(value)) {
                total *= value;
            }
            newColumn.set(i, total);
        }
        return newColumn;
    }

    default public DoubleColumn pctChange() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[pctChange]", this.size());
        newColumn.setMissing(0);
        for (int i = 1; i < this.size(); ++i) {
            newColumn.set(i, this.divide(this.getDouble(i), this.getDouble(i - 1)) - 1.0);
        }
        return newColumn;
    }

    default public DoubleColumn bin(int binCount) {
        double[] histogram = new double[binCount];
        EmpiricalDistribution distribution = new EmpiricalDistribution(binCount);
        distribution.load(this.asDoubleArray());
        int k = 0;
        for (SummaryStatistics stats : distribution.getBinStats()) {
            histogram[k++] = stats.getN();
        }
        return DoubleColumn.create(this.name() + "[binned]", histogram);
    }

    public double getDouble(int var1);

    public boolean isMissing(int var1);
}

