/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.AbstractStringColumn;
import tech.tablesaw.columns.strings.ByteDictionaryMap;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.LookupTableWrapper;
import tech.tablesaw.columns.strings.NoKeysAvailableException;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class StringColumn
extends AbstractStringColumn<StringColumn> {
    private DictionaryMap lookupTable = new ByteDictionaryMap();
    private final IntComparator rowComparator = (i, i1) -> {
        String f1 = this.get(i);
        String f2 = this.get(i1);
        return f1.compareTo(f2);
    };

    public static boolean valueIsMissing(String string) {
        return StringColumnType.valueIsMissing(string);
    }

    public StringColumn appendMissing() {
        this.lookupTable.appendMissing();
        return this;
    }

    public static StringColumn create(String name) {
        return new StringColumn(name);
    }

    public static StringColumn create(String name, String[] strings) {
        return new StringColumn(name, strings);
    }

    public static StringColumn create(String name, List<String> strings) {
        return new StringColumn(name, strings);
    }

    public static StringColumn createInternal(String name, DictionaryMap map) {
        return new StringColumn(name, map);
    }

    public static StringColumn create(String name, int size) {
        StringColumn column = new StringColumn(name, new ArrayList<String>(size));
        for (int i = 0; i < size; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static StringColumn create(String name, Stream<String> stream) {
        StringColumn column = StringColumn.create(name);
        stream.forEach(val -> column.append((String)val));
        return column;
    }

    private StringColumn(String name, List<String> strings) {
        super(StringColumnType.instance(), name);
        for (String string : strings) {
            this.append(string);
        }
    }

    private StringColumn(String name, DictionaryMap map) {
        super(StringColumnType.instance(), name);
        this.lookupTable = map;
    }

    private StringColumn(String name) {
        super(StringColumnType.instance(), name);
    }

    private StringColumn(String name, String[] strings) {
        super(StringColumnType.instance(), name);
        for (String string : strings) {
            this.append(string);
        }
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.lookupTable.isMissing(rowNumber);
    }

    public StringColumn emptyCopy() {
        return StringColumn.create(this.name());
    }

    public StringColumn emptyCopy(int rowSize) {
        return StringColumn.create(this.name(), rowSize);
    }

    @Override
    public void sortAscending() {
        this.lookupTable.sortAscending();
    }

    @Override
    public void sortDescending() {
        this.lookupTable.sortDescending();
    }

    @Override
    public int size() {
        return this.lookupTable.size();
    }

    @Override
    public String get(int rowIndex) {
        return this.lookupTable.getValueForIndex(rowIndex);
    }

    @Override
    public List<String> asList() {
        ArrayList<String> strings = new ArrayList<String>();
        for (String category : this) {
            strings.add(category);
        }
        return strings;
    }

    @Override
    public Table summary() {
        return this.countByCategory();
    }

    @Override
    public Table countByCategory() {
        return this.lookupTable.countByCategory(this.name());
    }

    @Override
    public void clear() {
        this.lookupTable.clear();
    }

    public StringColumn lead(int n) {
        StringColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public StringColumn lag(int n) {
        StringColumn copy = this.emptyCopy();
        copy.setName(this.name() + " lag(" + n + ")");
        if (n >= 0) {
            for (int m = 0; m < n; ++m) {
                copy.appendMissing();
            }
            for (int i = 0; i < this.size() && i + n < this.size(); ++i) {
                copy.appendCell(this.get(i));
            }
        } else {
            for (int i = -n; i < this.size(); ++i) {
                copy.appendCell(this.get(i));
            }
            for (int m = 0; m > n; --m) {
                copy.appendMissing();
            }
        }
        return copy;
    }

    @Override
    public StringColumn set(Selection rowSelection, String newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public StringColumn set(int rowIndex, String stringValue) {
        try {
            this.lookupTable.set(rowIndex, stringValue);
        }
        catch (NoKeysAvailableException ex) {
            this.lookupTable = this.lookupTable.promoteYourself();
            try {
                this.lookupTable.set(rowIndex, stringValue);
            }
            catch (NoKeysAvailableException e) {
                throw new IllegalStateException(e);
            }
        }
        return this;
    }

    @Override
    public int countUnique() {
        return this.lookupTable.countUnique();
    }

    @Override
    public boolean contains(String aString) {
        return this.firstIndexOf(aString) >= 0;
    }

    @Override
    public Column<String> setMissing(int i) {
        return this.set(i, StringColumnType.missingValueIndicator());
    }

    public StringColumn addAll(List<String> stringValues) {
        for (String stringValue : stringValues) {
            this.append(stringValue);
        }
        return this;
    }

    public StringColumn appendCell(String object) {
        return this.appendCell(object, (AbstractColumnParser)StringColumnType.DEFAULT_PARSER);
    }

    public StringColumn appendCell(String object, AbstractColumnParser<?> parser) {
        return this.appendObj(parser.parse(object));
    }

    @Override
    public IntComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public boolean isEmpty() {
        return this.lookupTable.size() == 0;
    }

    @Override
    public Selection isEqualTo(String string) {
        return this.lookupTable.isEqualTo(string);
    }

    @Override
    public Selection isNotEqualTo(String string) {
        return this.lookupTable.isNotEqualTo(string);
    }

    public List<BooleanColumn> getDummies() {
        return this.lookupTable.getDummies();
    }

    public StringColumn unique() {
        ArrayList<String> strings = new ArrayList<String>(this.lookupTable.asSet());
        return StringColumn.create(this.name() + " Unique values", strings);
    }

    public DoubleColumn asDoubleColumn() {
        return DoubleColumn.create(this.name(), this.asDoubleArray());
    }

    public StringColumn where(Selection selection) {
        return (StringColumn)this.subset(selection.toArray());
    }

    public StringColumn copy() {
        StringColumn newCol = StringColumn.create(this.name(), this.size());
        int r = 0;
        for (String string : this) {
            newCol.set(r, string);
            ++r;
        }
        return newCol;
    }

    public StringColumn append(Column<String> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        StringColumn source = (StringColumn)column;
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            this.append(source.getString(i));
        }
        return this;
    }

    @Override
    public int countMissing() {
        return this.lookupTable.countMissing();
    }

    public StringColumn removeMissing() {
        StringColumn noMissing = this.emptyCopy();
        for (String v : this) {
            if (StringColumnType.valueIsMissing(v)) continue;
            noMissing.append(v);
        }
        return noMissing;
    }

    @Override
    public Iterator<String> iterator() {
        return this.lookupTable.iterator();
    }

    public Set<String> asSet() {
        return this.lookupTable.asSet();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return this.lookupTable.asBytes(rowNumber);
    }

    public double getDouble(int i) {
        return this.lookupTable.uniqueValuesAt(this.lookupTable.firstIndexOf(this.lookupTable.getValueForIndex(i))) - 1;
    }

    public double[] asDoubleArray() {
        return Arrays.stream(this.lookupTable.asIntArray()).asDoubleStream().toArray();
    }

    public StringColumn append(String value) {
        try {
            this.lookupTable.append(value);
        }
        catch (NoKeysAvailableException ex) {
            this.lookupTable = this.lookupTable.promoteYourself();
            try {
                this.lookupTable.append(value);
            }
            catch (NoKeysAvailableException e) {
                throw new IllegalStateException(e);
            }
        }
        return this;
    }

    public StringColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to StringColumn");
        }
        return this.append((String)obj);
    }

    @Override
    public Selection isIn(String ... strings) {
        return this.lookupTable.selectIsIn(strings);
    }

    @Override
    public Selection isIn(Collection<String> strings) {
        return this.lookupTable.selectIsIn(strings);
    }

    @Override
    public Selection isNotIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(strings));
        return results;
    }

    @Override
    public Selection isNotIn(Collection<String> strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot((Selection)this.isIn((Collection)strings));
        return results;
    }

    public int firstIndexOf(String value) {
        return this.lookupTable.firstIndexOf(value);
    }

    public int countOccurrences(String value) {
        return this.lookupTable.countOccurrences(value);
    }

    public String[] asObjectArray() {
        return this.lookupTable.asObjectArray();
    }

    @Override
    public StringColumn asStringColumn() {
        return this.copy();
    }

    public TextColumn asTextColumn() {
        TextColumn textColumn = TextColumn.create(this.name(), this.size());
        for (int i = 0; i < this.size(); ++i) {
            textColumn.set(i, this.get(i));
        }
        return textColumn;
    }

    public LookupTableWrapper getLookupTable() {
        return new LookupTableWrapper(this.lookupTable);
    }
}

