/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.datetimes.DateTimeColumnFormatter;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.datetimes.DateTimeFilters;
import tech.tablesaw.columns.datetimes.DateTimeMapFunctions;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.temporal.TemporalFillers;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.comparators.DescendingLongComparator;

public class DateTimeColumn
extends AbstractColumn<DateTimeColumn, LocalDateTime>
implements DateTimeMapFunctions,
DateTimeFilters,
TemporalFillers<LocalDateTime, DateTimeColumn>,
CategoricalColumn<LocalDateTime> {
    private final LongComparator reverseLongComparator = DescendingLongComparator.instance();
    private LongArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        long f1 = this.getPackedDateTime(r1);
        long f2 = this.getPackedDateTime(r2);
        return Long.compare(f1, f2);
    };
    private DateTimeColumnFormatter printFormatter = new DateTimeColumnFormatter();

    private DateTimeColumn(String name, LongArrayList data) {
        super(DateTimeColumnType.instance(), name);
        this.data = data;
    }

    public static DateTimeColumn create(String name) {
        return new DateTimeColumn(name, new LongArrayList(128));
    }

    public static DateTimeColumn create(String name, int initialSize) {
        DateTimeColumn column = new DateTimeColumn(name, new LongArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static DateTimeColumn create(String name, List<LocalDateTime> data) {
        DateTimeColumn column = new DateTimeColumn(name, new LongArrayList(data.size()));
        for (LocalDateTime date : data) {
            column.append(date);
        }
        return column;
    }

    public static DateTimeColumn create(String name, Stream<LocalDateTime> stream) {
        DateTimeColumn column = DateTimeColumn.create(name);
        stream.forEach(val -> column.append((LocalDateTime)val));
        return column;
    }

    @Override
    public DateTimeColumn plus(long amountToAdd, ChronoUnit unit) {
        DateTimeColumn newColumn = this.emptyCopy();
        newColumn.setName(this.temporalColumnName(this, amountToAdd, unit));
        DateTimeColumn column1 = this;
        for (int r = 0; r < column1.size(); ++r) {
            long packedDateTime = column1.getLongInternal(r);
            if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
                newColumn.appendMissing();
                continue;
            }
            newColumn.appendInternal(PackedLocalDateTime.plus(packedDateTime, amountToAdd, unit));
        }
        return newColumn;
    }

    public static DateTimeColumn create(String name, LocalDateTime[] data) {
        DateTimeColumn column = new DateTimeColumn(name, new LongArrayList(data.length));
        for (LocalDateTime date : data) {
            column.append(date);
        }
        return column;
    }

    public static boolean valueIsMissing(long value) {
        return DateTimeColumnType.valueIsMissing(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return DateTimeColumn.valueIsMissing(this.getLongInternal(rowNumber));
    }

    @Override
    public DateTimeColumn subset(int[] rows) {
        DateTimeColumn c = this.emptyCopy();
        for (int row : rows) {
            c.appendInternal(this.getLongInternal(row));
        }
        return c;
    }

    public DateTimeColumn removeMissing() {
        DateTimeColumn noMissing = this.emptyCopy();
        LongIterator iterator = this.longIterator();
        while (iterator.hasNext()) {
            long i = iterator.nextLong();
            if (DateTimeColumn.valueIsMissing(i)) continue;
            noMissing.appendInternal(i);
        }
        return noMissing;
    }

    @Override
    public boolean contains(LocalDateTime dateTime) {
        long dt = PackedLocalDateTime.pack(dateTime);
        return this.data.contains(dt);
    }

    @Override
    public Column<LocalDateTime> setMissing(int i) {
        return this.set(i, DateTimeColumnType.missingValueIndicator());
    }

    public DateTimeColumn where(Selection selection) {
        return this.subset(selection.toArray());
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter, String missingValueString) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        Preconditions.checkNotNull((Object)missingValueString);
        this.printFormatter = new DateTimeColumnFormatter(dateTimeFormatter, missingValueString);
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        this.printFormatter = new DateTimeColumnFormatter(dateTimeFormatter);
    }

    public void setPrintFormatter(DateTimeColumnFormatter formatter) {
        Preconditions.checkNotNull((Object)formatter);
        this.printFormatter = formatter;
    }

    @Override
    public DateTimeColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        long[] dest = new long[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = DateTimeColumnType.missingValueIndicator();
        }
        System.arraycopy(this.data.toLongArray(), srcPos, dest, destPos, length);
        DateTimeColumn copy = this.emptyCopy(this.size());
        copy.data = new LongArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    public DateTimeColumn appendCell(String stringValue) {
        return this.appendInternal(PackedLocalDateTime.pack(DateTimeColumnType.DEFAULT_PARSER.parse(stringValue)));
    }

    public DateTimeColumn appendCell(String stringValue, AbstractColumnParser<?> parser) {
        return this.appendObj(parser.parse(stringValue));
    }

    public DateTimeColumn append(LocalDateTime dateTime) {
        if (dateTime != null) {
            long dt = PackedLocalDateTime.pack(dateTime);
            this.appendInternal(dt);
        } else {
            this.appendInternal(DateTimeColumnType.missingValueIndicator());
        }
        return this;
    }

    public DateTimeColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof LocalDateTime) {
            return this.append((LocalDateTime)obj);
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return this.append(timestamp.toLocalDateTime());
        }
        throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to DateTimeColumn");
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Deprecated
    public LongArrayList data() {
        return this.data;
    }

    public DateTimeColumn appendInternal(long dateTime) {
        this.data.add(dateTime);
        return this;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.getPackedDateTime(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return PackedLocalDateTime.toString(this.getPackedDateTime(row));
    }

    @Override
    public DateTimeColumn emptyCopy() {
        DateTimeColumn empty = DateTimeColumn.create(this.name());
        empty.printFormatter = this.printFormatter;
        return empty;
    }

    public DateTimeColumn emptyCopy(int rowSize) {
        DateTimeColumn column = DateTimeColumn.create(this.name(), rowSize);
        column.setPrintFormatter(this.printFormatter);
        return column;
    }

    public DateTimeColumn copy() {
        DateTimeColumn column = this.emptyCopy(this.data.size());
        column.data = this.data.clone();
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        LongArrays.parallelQuickSort((long[])this.data.elements(), (LongComparator)this.reverseLongComparator);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(new Column[]{measure});
        table.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    @Override
    public int countUnique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        return ints.size();
    }

    public DateTimeColumn unique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        DateTimeColumn column = this.emptyCopy(ints.size());
        column.setName(this.name() + " Unique values");
        column.data = LongArrayList.wrap((long[])ints.toLongArray());
        return column;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public long getLongInternal(int index) {
        return this.data.getLong(index);
    }

    protected long getPackedDateTime(int index) {
        return this.getLongInternal(index);
    }

    @Override
    public LocalDateTime get(int index) {
        return PackedLocalDateTime.asLocalDateTime(this.getPackedDateTime(index));
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public DateTimeColumn set(Selection rowSelection, LocalDateTime newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getPackedDateTime(i) != DateTimeColumnType.missingValueIndicator()) continue;
            ++count;
        }
        return count;
    }

    public long[] asEpochSecondArray() {
        return this.asEpochSecondArray(ZoneOffset.UTC);
    }

    public long[] asEpochSecondArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            LocalDateTime dateTime = PackedLocalDateTime.asLocalDateTime(this.data.getLong(i));
            output[i] = dateTime == null ? DateTimeColumnType.missingValueIndicator() : dateTime.toEpochSecond(offset);
        }
        return output;
    }

    public long[] asEpochMillisArray() {
        return this.asEpochMillisArray(ZoneOffset.UTC);
    }

    public long[] asEpochMillisArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            LocalDateTime dateTime = PackedLocalDateTime.asLocalDateTime(this.data.getLong(i));
            output[i] = dateTime == null ? DateTimeColumnType.missingValueIndicator() : dateTime.toInstant(offset).toEpochMilli();
        }
        return output;
    }

    public InstantColumn asInstantColumn() {
        return this.asInstantColumn(ZoneOffset.UTC);
    }

    public InstantColumn asInstantColumn(ZoneId zone) {
        Instant[] output = new Instant[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            LocalDateTime dateTime = PackedLocalDateTime.asLocalDateTime(this.data.getLong(i));
            output[i] = dateTime == null ? null : dateTime.atZone(zone).toInstant();
        }
        return InstantColumn.create(this.name(), output);
    }

    public DateTimeColumn append(Column<LocalDateTime> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DateTimeColumn dateTimeColumn = (DateTimeColumn)column;
        int size = dateTimeColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(dateTimeColumn.get(i));
        }
        return this;
    }

    public DateTimeColumn append(Column<LocalDateTime> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.appendInternal(((DateTimeColumn)column).getLongInternal(row));
    }

    public DateTimeColumn set(int row, Column<LocalDateTime> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((DateTimeColumn)column).getLongInternal(sourceRow));
    }

    public LocalDateTime max() {
        if (this.isEmpty()) {
            return null;
        }
        long max = this.getPackedDateTime(0);
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (DateTimeColumnType.missingValueIndicator() == aData) continue;
            max = max > aData ? max : aData;
        }
        if (DateTimeColumnType.missingValueIndicator() == max) {
            return null;
        }
        return PackedLocalDateTime.asLocalDateTime(max);
    }

    public DateTimeColumn appendMissing() {
        this.appendInternal(DateTimeColumnType.missingValueIndicator());
        return this;
    }

    @Override
    public LocalDateTime min() {
        if (this.isEmpty()) {
            return null;
        }
        long min = this.getPackedDateTime(0);
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (DateTimeColumnType.missingValueIndicator() == aData) continue;
            min = min < aData ? min : aData;
        }
        if (Integer.MIN_VALUE == min) {
            return null;
        }
        return PackedLocalDateTime.asLocalDateTime(min);
    }

    public DateTimeColumn set(int index, long value) {
        this.data.set(index, value);
        return this;
    }

    public DateTimeColumn set(int index, LocalDateTime value) {
        this.data.set(index, PackedLocalDateTime.pack(value));
        return this;
    }

    public List<LocalDateTime> top(int n) {
        ArrayList<LocalDateTime> top = new ArrayList<LocalDateTime>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values, (LongComparator)DescendingLongComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalDateTime.asLocalDateTime(values[i]));
        }
        return top;
    }

    public List<LocalDateTime> bottom(int n) {
        ArrayList<LocalDateTime> bottom = new ArrayList<LocalDateTime>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(PackedLocalDateTime.asLocalDateTime(values[i]));
        }
        return bottom;
    }

    public LongIterator longIterator() {
        return this.data.iterator();
    }

    public Set<LocalDateTime> asSet() {
        HashSet<LocalDateTime> times = new HashSet<LocalDateTime>();
        DateTimeColumn unique = this.unique();
        for (LocalDateTime localDateTime : unique) {
            times.add(localDateTime);
        }
        return times;
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putLong(this.getPackedDateTime(rowNumber)).array();
    }

    public double getDouble(int i) {
        return this.getPackedDateTime(i);
    }

    public double[] asDoubleArray() {
        double[] doubles = new double[this.size()];
        long[] millis = this.asEpochSecondArray();
        for (int i = 0; i < millis.length; ++i) {
            doubles[i] = millis[i];
        }
        return doubles;
    }

    public DoubleColumn asDoubleColumn() {
        return DoubleColumn.create(this.name(), this.asEpochSecondArray());
    }

    @Override
    public Iterator<LocalDateTime> iterator() {
        return new Iterator<LocalDateTime>(){
            final LongIterator longIterator;
            {
                this.longIterator = DateTimeColumn.this.longIterator();
            }

            @Override
            public boolean hasNext() {
                return this.longIterator.hasNext();
            }

            @Override
            public LocalDateTime next() {
                return PackedLocalDateTime.asLocalDateTime(this.longIterator.nextLong());
            }
        };
    }

    private DateTimeColumn fillWith(int count, Iterator<LocalDateTime> iterator, Consumer<LocalDateTime> acceptor) {
        for (int r = 0; r < count && iterator.hasNext(); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public DateTimeColumn fillWith(Iterator<LocalDateTime> iterator) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterator, (LocalDateTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDateTime)date);
        });
        return this;
    }

    private DateTimeColumn fillWith(int count, Iterable<LocalDateTime> iterable, Consumer<LocalDateTime> acceptor) {
        Iterator<LocalDateTime> iterator = iterable.iterator();
        for (int r = 0; r < count && (iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public DateTimeColumn fillWith(Iterable<LocalDateTime> iterable) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterable, (LocalDateTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDateTime)date);
        });
        return this;
    }

    private DateTimeColumn fillWith(int count, Supplier<LocalDateTime> supplier, Consumer<LocalDateTime> acceptor) {
        for (int r = 0; r < count; ++r) {
            try {
                acceptor.accept(supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public DateTimeColumn fillWith(Supplier<LocalDateTime> supplier) {
        int[] r = new int[1];
        this.fillWith(this.size(), supplier, (LocalDateTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDateTime)date);
        });
        return this;
    }

    public LocalDateTime[] asObjectArray() {
        LocalDateTime[] output = new LocalDateTime[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    @Override
    public int compare(LocalDateTime o1, LocalDateTime o2) {
        return o1.compareTo(o2);
    }
}

