/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.QuerySupport;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.table.StandardTableSliceGroup;
import tech.tablesaw.table.TableSliceGroup;

public class Summarizer {
    private String[] groupColumnNames = new String[0];
    private final Table original;
    private Table temp;
    private final List<String> summarizedColumns = new ArrayList<String>();
    private final AggregateFunction<?, ?>[] reductions;
    private static final String GROUP_COL_TEMP_NAME = "_temp_group_col_";

    public Summarizer(Table sourceTable, Column<?> column, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column.name());
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, List<String> columnNames, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        for (String nm : columnNames) {
            tempTable.addColumns(new Column[]{sourceTable.column(nm)});
        }
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.addAll(columnNames);
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, Column<?> column1, Column<?> column2, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column1});
        tempTable.addColumns(new Column[]{column2});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column1.name());
        this.summarizedColumns.add(column2.name());
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, Column<?> column1, Column<?> column2, Column<?> column3, Column<?> column4, AggregateFunction<?, ?> ... functions) {
        Preconditions.checkArgument((!sourceTable.isEmpty() ? 1 : 0) != 0, (Object)"The table to summarize is empty.");
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column1});
        tempTable.addColumns(new Column[]{column2});
        tempTable.addColumns(new Column[]{column3});
        tempTable.addColumns(new Column[]{column4});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column1.name());
        this.summarizedColumns.add(column2.name());
        this.summarizedColumns.add(column3.name());
        this.summarizedColumns.add(column4.name());
        this.reductions = functions;
    }

    public Summarizer(Table sourceTable, Column<?> column1, Column<?> column2, Column<?> column3, AggregateFunction<?, ?> ... functions) {
        Table tempTable = Table.create(sourceTable.name());
        tempTable.addColumns(new Column[]{column1});
        tempTable.addColumns(new Column[]{column2});
        tempTable.addColumns(new Column[]{column3});
        this.temp = tempTable;
        this.original = sourceTable;
        this.summarizedColumns.add(column1.name());
        this.summarizedColumns.add(column2.name());
        this.summarizedColumns.add(column3.name());
        this.reductions = functions;
    }

    public Table by(String ... columnNames) {
        for (String columnName : columnNames) {
            if (!this.tableDoesNotContain(columnName, this.temp)) continue;
            this.temp.addColumns(new Column[]{this.original.column(columnName)});
        }
        StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, columnNames);
        return this.summarize(group);
    }

    public Table by(CategoricalColumn<?> ... columns) {
        for (CategoricalColumn<?> c : columns) {
            if (this.temp.containsColumn(c)) continue;
            this.temp.addColumns(new Column[]{c});
        }
        StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, columns);
        return this.summarize(group);
    }

    @Deprecated
    public Table by(String groupNameTemplate, int step) {
        IntColumn groupColumn = this.assignToGroupsByStep(step);
        Table t = this.getSummaryTable(groupColumn);
        StringColumn groupNameColumn = StringColumn.create("Group", t.rowCount());
        for (Row row : t) {
            int id = row.getInt(groupColumn.name());
            String name = groupNameTemplate + ": " + id;
            groupNameColumn.set(row.getRowNumber(), name);
        }
        t.replaceColumn(0, groupNameColumn);
        return t;
    }

    private Table getSummaryTable(IntColumn groupColumn) {
        StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, groupColumn);
        return this.summarize(group);
    }

    public Table by(int step) {
        IntColumn groupColumn = this.assignToGroupsByStep(step);
        Table t = this.getSummaryTable(groupColumn);
        t.column(GROUP_COL_TEMP_NAME).setName("Group");
        return t;
    }

    public Table apply() {
        if (this.groupColumnNames.length > 0) {
            StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, this.groupColumnNames);
            return this.summarize(group);
        }
        ArrayList<Table> results = new ArrayList<Table>();
        ArrayListMultimap<String, AggregateFunction<?, ?>> reductionMultimap = this.getAggregateFunctionMultimap();
        for (String name : reductionMultimap.keys()) {
            List reductions = reductionMultimap.get((Object)name);
            Table table = TableSliceGroup.summaryTableName(this.temp);
            for (AggregateFunction function : reductions) {
                Column<?> column = this.temp.column(name);
                Object result = function.summarize(column);
                ColumnType type = function.returnType();
                Column<?> newColumn = type.create(TableSliceGroup.aggregateColumnName(name, function.functionName()));
                if (result instanceof Number) {
                    Number number = (Number)result;
                    newColumn.append(number.doubleValue());
                } else {
                    newColumn.append(result);
                }
                table.addColumns(new Column[]{newColumn});
            }
            results.add(table);
        }
        return this.combineTables(results);
    }

    public Table having(Function<Table, Selection> selection) {
        Preconditions.checkState((this.groupColumnNames.length > 0 ? 1 : 0) != 0, (Object)"Cannot perform having() on summary that has not been grouped first");
        if (this.groupColumnNames[0].equals(GROUP_COL_TEMP_NAME)) {
            IntColumn groupColumn = this.temp.intColumn(GROUP_COL_TEMP_NAME);
            StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, groupColumn);
            return this.summarizeForHaving(group, selection);
        }
        StandardTableSliceGroup group = StandardTableSliceGroup.create(this.temp, this.groupColumnNames);
        return this.summarizeForHaving(group, selection);
    }

    public Summarizer groupBy(CategoricalColumn<?> ... columns) {
        this.groupColumnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            CategoricalColumn<?> c = columns[i];
            if (this.temp.containsColumn(c)) continue;
            this.temp.addColumns(new Column[]{c});
            this.groupColumnNames[i] = c.name();
        }
        return this;
    }

    public Summarizer groupBy(String ... columnNames) {
        for (String columnName : columnNames) {
            if (!this.tableDoesNotContain(columnName, this.temp)) continue;
            this.temp.addColumns(new Column[]{this.original.column(columnName)});
        }
        this.groupColumnNames = columnNames;
        return this;
    }

    public Summarizer groupBy(int step) {
        IntColumn groupColumn = this.assignToGroupsByStep(step);
        if (this.tableDoesNotContain(groupColumn.name(), this.temp)) {
            this.temp.addColumns(new Column[]{groupColumn});
        }
        this.groupColumnNames = new String[]{GROUP_COL_TEMP_NAME};
        return this;
    }

    private Table summarizeForHaving(TableSliceGroup group, Function<Table, Selection> selectionFunction) {
        ArrayList<Table> results = new ArrayList<Table>();
        ArrayListMultimap<String, AggregateFunction<?, ?>> reductionMultimap = this.getAggregateFunctionMultimap();
        for (String name : reductionMultimap.keys()) {
            List reductions = reductionMultimap.get((Object)name);
            Table groupTable = group.aggregate(name, reductions.toArray(new AggregateFunction[0]));
            if ((groupTable = groupTable.where(selectionFunction)).isEmpty()) continue;
            results.add(groupTable);
        }
        return this.combineTables(results);
    }

    private IntColumn assignToGroupsByStep(int step) {
        IntColumn groupColumn = IntColumn.create(GROUP_COL_TEMP_NAME, this.temp.rowCount());
        this.temp.addColumns(new Column[]{groupColumn});
        int groupId = 1;
        int withinGroupCount = 0;
        Row row = new Row(this.temp);
        while (row.hasNext()) {
            row.next();
            if (withinGroupCount < step) {
                ++withinGroupCount;
                groupColumn.set(row.getRowNumber(), groupId);
                continue;
            }
            groupColumn.set(row.getRowNumber(), ++groupId);
            withinGroupCount = 1;
        }
        int lastGroupSize = this.temp.where((Function<Table, Selection>)QuerySupport.numberColumn(GROUP_COL_TEMP_NAME).isEqualTo(groupId)).rowCount();
        if (lastGroupSize < step) {
            this.temp = this.temp.dropWhere((Function<Table, Selection>)QuerySupport.numberColumn(GROUP_COL_TEMP_NAME).isEqualTo(groupId));
        }
        this.temp.addColumns(new Column[]{IntColumn.indexColumn("index", this.temp.rowCount(), 1)});
        return groupColumn;
    }

    private Table summarize(TableSliceGroup group) {
        ArrayList<Table> results = new ArrayList<Table>();
        ArrayListMultimap<String, AggregateFunction<?, ?>> reductionMultimap = this.getAggregateFunctionMultimap();
        for (String name : reductionMultimap.keys()) {
            List reductions = reductionMultimap.get((Object)name);
            results.add(group.aggregate(name, reductions.toArray(new AggregateFunction[0])));
        }
        return this.combineTables(results);
    }

    private ArrayListMultimap<String, AggregateFunction<?, ?>> getAggregateFunctionMultimap() {
        ArrayListMultimap reductionMultimap = ArrayListMultimap.create();
        for (String name : this.summarizedColumns) {
            Column<?> column = this.temp.column(name);
            ColumnType type = column.type();
            for (AggregateFunction<?, ?> reduction : this.reductions) {
                if (!reduction.isCompatibleColumn(type)) continue;
                reductionMultimap.put((Object)name, reduction);
            }
        }
        if (reductionMultimap.isEmpty()) {
            throw new IllegalArgumentException("None of the aggregate functions provided apply to the summarized column type(s).");
        }
        return reductionMultimap;
    }

    private Table combineTables(List<Table> tables) {
        if (tables.size() == 1) {
            return tables.get(0);
        }
        Table result = null;
        for (Table table : tables) {
            if (result == null) {
                result = table;
                continue;
            }
            for (Column<?> column : table.columns()) {
                if (!this.tableDoesNotContain(column.name(), result)) continue;
                result.addColumns(new Column[]{column});
            }
        }
        return result;
    }

    private boolean tableDoesNotContain(String columnName, Table table) {
        List upperCase = table.columnNames().stream().map(String::toUpperCase).collect(Collectors.toList());
        return !upperCase.contains(columnName.toUpperCase());
    }
}

