/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import com.google.common.collect.Lists;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.io.ReadOptions;

public class DoubleParser
extends AbstractColumnParser<Double> {
    public DoubleParser(ColumnType columnType) {
        super(columnType);
    }

    public DoubleParser(DoubleColumnType doubleColumnType, ReadOptions readOptions) {
        super(doubleColumnType);
        if (readOptions.missingValueIndicator() != null) {
            this.missingValueStrings = Lists.newArrayList((Object[])new String[]{readOptions.missingValueIndicator()});
        }
    }

    @Override
    public boolean canParse(String s) {
        if (this.isMissing(s)) {
            return true;
        }
        try {
            Double.parseDouble(AbstractColumnParser.remove(s, ','));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Double parse(String s) {
        return this.parseDouble(s);
    }

    @Override
    public double parseDouble(String s) {
        if (this.isMissing(s)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return Double.parseDouble(AbstractColumnParser.remove(s, ','));
    }
}

