/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.Short2IntOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.IntDictionaryMap;
import tech.tablesaw.columns.strings.NoKeysAvailableException;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class ShortDictionaryMap
implements DictionaryMap {
    private static final int MAX_UNIQUE = 65535;
    private static final short MISSING_VALUE = Short.MAX_VALUE;
    private static final short DEFAULT_RETURN_VALUE = Short.MIN_VALUE;
    private final ShortComparator reverseDictionarySortComparator = (i, i1) -> -this.getValueForShortKey(i).compareTo(this.getValueForShortKey(i1));
    private final ShortComparator dictionarySortComparator = (i, i1) -> this.getValueForShortKey(i).compareTo(this.getValueForShortKey(i1));
    private ShortArrayList values = new ShortArrayList();
    private final AtomicInteger nextIndex = new AtomicInteger(Short.MIN_VALUE);
    private final Short2ObjectMap<String> keyToValue = new Short2ObjectOpenHashMap();
    private final Object2ShortOpenHashMap<String> valueToKey = new Object2ShortOpenHashMap();
    private final Short2IntOpenHashMap keyToCount = new Short2IntOpenHashMap();

    ShortDictionaryMap(DictionaryMap original) throws NoKeysAvailableException {
        this.valueToKey.defaultReturnValue((short)Short.MIN_VALUE);
        this.keyToCount.defaultReturnValue(0);
        for (int i2 = 0; i2 < original.size(); ++i2) {
            String value = original.getValueForIndex(i2);
            this.append(value);
        }
    }

    private void put(short key, String value) {
        this.keyToValue.put(key, (Object)value);
        this.valueToKey.put((Object)value, key);
    }

    private short getKeyForValue(String value) {
        return this.valueToKey.getShort((Object)value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String getValueForIndex(int rowIndex) {
        short k = this.values.getShort(rowIndex);
        return this.getValueForKey(k);
    }

    @Override
    public int getKeyForIndex(int rowIndex) {
        return this.values.getShort(rowIndex);
    }

    private Set<String> categories() {
        return this.valueToKey.keySet();
    }

    private Short2ObjectMap<String> keyToValueMap() {
        return this.keyToValue;
    }

    @Override
    public void sortAscending() {
        short[] elements = this.values.toShortArray();
        ShortArrays.parallelQuickSort((short[])elements, (ShortComparator)this.dictionarySortComparator);
        this.values = new ShortArrayList(elements);
    }

    @Override
    public String getValueForKey(int key) {
        return (String)this.keyToValue.get((short)key);
    }

    private String getValueForShortKey(short key) {
        return (String)this.keyToValue.get(key);
    }

    @Override
    public void sortDescending() {
        short[] elements = this.values.toShortArray();
        ShortArrays.parallelQuickSort((short[])elements, (ShortComparator)this.reverseDictionarySortComparator);
        this.values = new ShortArrayList(elements);
    }

    @Override
    public int countOccurrences(String value) {
        return this.keyToCount.get(this.getKeyForValue(value));
    }

    @Override
    public Set<String> asSet() {
        return this.categories();
    }

    @Override
    public int firstIndexOf(String value) {
        return this.values.indexOf(this.getKeyForValue(value));
    }

    @Override
    public String[] asObjectArray() {
        String[] output = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.getValueForIndex(i);
        }
        return output;
    }

    @Override
    public int countUnique() {
        return this.keyToValueMap().size();
    }

    @Override
    public Selection selectIsIn(String ... strings) {
        ShortOpenHashSet keys = new ShortOpenHashSet(strings.length);
        for (String string : strings) {
            short key = this.getKeyForValue(string);
            if (key == Short.MIN_VALUE) continue;
            keys.add(key);
        }
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!keys.contains(this.values.getShort(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection selectIsIn(Collection<String> strings) {
        ShortOpenHashSet keys = new ShortOpenHashSet(strings.size());
        for (String string : strings) {
            short key = this.getKeyForValue(string);
            if (key == Short.MIN_VALUE) continue;
            keys.add(key);
        }
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!keys.contains(this.values.getShort(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public void append(String value) throws NoKeysAvailableException {
        short key;
        if (value == null || StringColumnType.missingValueIndicator().equals(value)) {
            key = Short.MAX_VALUE;
            this.put(key, StringColumnType.missingValueIndicator());
        } else {
            key = this.getKeyForValue(value);
        }
        if (key == Short.MIN_VALUE) {
            key = this.getValueId();
            this.put(key, value);
        }
        this.values.add(key);
        this.keyToCount.addTo(key, 1);
    }

    private short getValueId() throws NoKeysAvailableException {
        int nextValue = this.nextIndex.incrementAndGet();
        if (nextValue >= Short.MAX_VALUE) {
            String msg = String.format("String column can only contain %d unique values. Column has more.", 65535);
            throw new NoKeysAvailableException(msg);
        }
        return (short)nextValue;
    }

    private void addValuesToSelection(Selection results, short key) {
        if (key != Short.MIN_VALUE) {
            int i = 0;
            ShortListIterator shortListIterator = this.values.iterator();
            while (shortListIterator.hasNext()) {
                short next = (Short)shortListIterator.next();
                if (key == next) {
                    results.add(i);
                }
                ++i;
            }
        }
    }

    @Override
    public void set(int rowIndex, String stringValue) throws NoKeysAvailableException {
        short valueId;
        String str = StringColumnType.missingValueIndicator();
        if (stringValue != null) {
            str = stringValue;
        }
        if ((valueId = this.getKeyForValue(str)) == Short.MIN_VALUE) {
            valueId = this.getValueId();
            this.put(valueId, str);
        }
        short oldKey = this.values.set(rowIndex, valueId);
        this.keyToCount.addTo(valueId, 1);
        if (this.keyToCount.addTo(oldKey, -1) == 1) {
            String obsoleteValue = (String)this.keyToValue.remove(oldKey);
            this.valueToKey.removeShort((Object)obsoleteValue);
            this.keyToCount.remove(oldKey);
        }
    }

    @Override
    public void clear() {
        this.values.clear();
        this.keyToValue.clear();
        this.valueToKey.clear();
        this.keyToCount.clear();
    }

    @Override
    public Table countByCategory(String columnName) {
        Table t = Table.create("Column: " + columnName);
        StringColumn categories = StringColumn.create("Category");
        IntColumn counts = IntColumn.create("Count");
        for (Map.Entry entry : this.keyToCount.short2IntEntrySet()) {
            categories.append(this.getValueForKey(((Short)entry.getKey()).shortValue()));
            counts.append((Integer)entry.getValue());
        }
        t.addColumns(new Column[]{categories});
        t.addColumns(new Column[]{counts});
        return t;
    }

    @Override
    public Selection isEqualTo(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        short key = this.getKeyForValue(string);
        this.addValuesToSelection(results, key);
        return results;
    }

    @Override
    public List<BooleanColumn> getDummies() {
        ArrayList<BooleanColumn> results = new ArrayList<BooleanColumn>();
        for (Short2ObjectMap.Entry entry : this.keyToValueMap().short2ObjectEntrySet()) {
            BooleanColumn column = BooleanColumn.create((String)entry.getValue());
            results.add(column);
        }
        ObjectIterator objectIterator = this.values.iterator();
        while (objectIterator.hasNext()) {
            short next = (Short)objectIterator.next();
            String category = this.getValueForKey(next);
            for (BooleanColumn column : results) {
                if (category.equals(column.name())) {
                    column.append(true);
                    continue;
                }
                column.append(false);
            }
        }
        return results;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putShort((short)this.getKeyForIndex(rowNumber)).array();
    }

    private int byteSize() {
        return 2;
    }

    @Override
    public int countMissing() {
        return this.keyToCount.get((short)Short.MAX_VALUE);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private final ShortListIterator valuesIt;
            {
                this.valuesIt = ShortDictionaryMap.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.valuesIt.hasNext();
            }

            @Override
            public String next() {
                return ShortDictionaryMap.this.getValueForKey(this.valuesIt.nextShort());
            }
        };
    }

    @Override
    public void appendMissing() {
        try {
            this.append(StringColumnType.missingValueIndicator());
        }
        catch (NoKeysAvailableException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.getKeyForIndex(rowNumber) == Short.MAX_VALUE;
    }

    @Override
    public DictionaryMap promoteYourself() {
        IntDictionaryMap dictionaryMap;
        try {
            dictionaryMap = new IntDictionaryMap(this);
        }
        catch (NoKeysAvailableException e) {
            throw new IllegalStateException(e);
        }
        return dictionaryMap;
    }
}

