/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.NumberFillers;
import tech.tablesaw.columns.numbers.fillers.DoubleRangeIterable;
import tech.tablesaw.selection.Selection;

public class DoubleColumn
extends NumberColumn<Double>
implements NumberFillers<DoubleColumn> {
    private final DoubleComparator descendingComparator = (o2, o1) -> Double.compare(o1, o2);
    private final DoubleArrayList data;

    protected DoubleColumn(String name, DoubleArrayList data) {
        super(DoubleColumnType.instance(), name);
        this.data = data;
    }

    @Override
    public String getString(int row) {
        double value = this.getDouble(row);
        if (DoubleColumnType.isMissingValue(value)) {
            return "";
        }
        return String.valueOf(this.printFormatter.format(value));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public DoubleColumn setMissing(int index) {
        this.set(index, DoubleColumnType.missingValueIndicator());
        return this;
    }

    protected DoubleColumn(String name) {
        super(DoubleColumnType.instance(), name);
        this.data = new DoubleArrayList(128);
    }

    public static DoubleColumn create(String name, double[] arr) {
        return new DoubleColumn(name, new DoubleArrayList(arr));
    }

    public static DoubleColumn create(String name) {
        return new DoubleColumn(name);
    }

    public static DoubleColumn create(String name, float[] arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, int[] arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, long[] arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, List<Number> numberList) {
        double[] doubles = new double[numberList.size()];
        for (int i = 0; i < numberList.size(); ++i) {
            doubles[i] = numberList.get(i).doubleValue();
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, Number[] numbers) {
        double[] doubles = new double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            doubles[i] = numbers[i].doubleValue();
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, int initialSize) {
        DoubleColumn column = new DoubleColumn(name);
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public DoubleColumn createCol(String name, int initialSize) {
        return DoubleColumn.create(name, initialSize);
    }

    public DoubleColumn createCol(String name) {
        return DoubleColumn.create(name);
    }

    @Override
    public Double get(int index) {
        return this.getDouble(index);
    }

    public DoubleColumn subset(int[] rows) {
        DoubleColumn c = this.emptyCopy();
        for (int row : rows) {
            c.append(this.getDouble(row));
        }
        return c;
    }

    public DoubleColumn unique() {
        DoubleOpenHashSet doubles = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) continue;
            doubles.add(this.getDouble(i));
        }
        DoubleColumn column = DoubleColumn.create(this.name() + " Unique values");
        doubles.forEach(column::append);
        return column;
    }

    public DoubleColumn top(int n) {
        DoubleArrayList top = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values, (DoubleComparator)this.descendingComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new DoubleColumn(this.name() + "[Top " + n + "]", top);
    }

    public DoubleColumn bottom(int n) {
        DoubleArrayList bottom = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new DoubleColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public DoubleColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        double[] dest = new double[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = FloatColumnType.missingValueIndicator();
        }
        double[] array = this.data.toDoubleArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new DoubleColumn(this.name() + " lag(" + n + ")", new DoubleArrayList(dest));
    }

    public DoubleColumn removeMissing() {
        DoubleColumn result = this.copy();
        result.clear();
        DoubleListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            double v = iterator.nextDouble();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public DoubleColumn append(float f) {
        this.data.add((double)f);
        return this;
    }

    public DoubleColumn append(double d) {
        this.data.add(d);
        return this;
    }

    public DoubleColumn append(int i) {
        this.data.add((double)i);
        return this;
    }

    public DoubleColumn append(Double val) {
        this.append((double)val);
        return this;
    }

    public DoubleColumn append(Integer val) {
        this.append(val.doubleValue());
        return this;
    }

    @Override
    public DoubleColumn emptyCopy() {
        return (DoubleColumn)super.emptyCopy();
    }

    @Override
    public DoubleColumn emptyCopy(int rowSize) {
        return (DoubleColumn)super.emptyCopy(rowSize);
    }

    @Override
    public DoubleColumn copy() {
        return new DoubleColumn(this.name(), this.data.clone());
    }

    @Override
    public Iterator<Double> iterator() {
        return this.data.iterator();
    }

    public Double[] asObjectArray() {
        Double[] output = new Double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.getDouble(i);
        }
        return output;
    }

    @Override
    public int compare(Double o1, Double o2) {
        return Double.compare(o1, o2);
    }

    public DoubleColumn set(int i, Double val) {
        return this.set(i, (double)val);
    }

    public DoubleColumn set(int i, double val) {
        this.data.set(i, val);
        return this;
    }

    public DoubleColumn set(DoublePredicate condition, NumericColumn<?> other) {
        for (int row = 0; row < this.size(); ++row) {
            if (!condition.test(this.getDouble(row))) continue;
            this.set(row, other.getDouble(row));
        }
        return this;
    }

    public DoubleColumn set(DoublePredicate condition, Double newValue) {
        return (DoubleColumn)super.set(condition, newValue);
    }

    public DoubleColumn append(Column<Double> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DoubleColumn numberColumn = (DoubleColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getDouble(i));
        }
        return this;
    }

    public DoubleColumn append(Column<Double> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DoubleColumn doubleColumn = (DoubleColumn)column;
        return this.append(doubleColumn.getDouble(row));
    }

    public DoubleColumn set(int row, Column<Double> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DoubleColumn doubleColumn = (DoubleColumn)column;
        return this.set(row, doubleColumn.getDouble(sourceRow));
    }

    public DoubleColumn map(ToDoubleFunction<Double> fun) {
        DoubleColumn result = DoubleColumn.create(this.name());
        for (double t : this) {
            try {
                result.append(fun.applyAsDouble(t));
            }
            catch (Exception e) {
                result.appendMissing();
            }
        }
        return result;
    }

    public DoubleColumn filter(DoublePredicate test) {
        DoubleColumn result = DoubleColumn.create(this.name());
        for (int i = 0; i < this.size(); ++i) {
            double d = this.getDouble(i);
            if (!test.test(d)) continue;
            result.append(d);
        }
        return result;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(DoubleColumnType.instance().byteSize()).putDouble(this.getDouble(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        DoubleOpenHashSet uniqueElements = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) continue;
            uniqueElements.add(this.getDouble(i));
        }
        return uniqueElements.size();
    }

    @Override
    public double getDouble(int row) {
        return this.data.getDouble(row);
    }

    public boolean isMissingValue(double value) {
        return DoubleColumnType.isMissingValue(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getDouble(rowNumber));
    }

    @Override
    public void sortAscending() {
        DoubleArrays.parallelQuickSort((double[])this.data.elements());
    }

    @Override
    public void sortDescending() {
        DoubleArrays.parallelQuickSort((double[])this.data.elements(), (DoubleComparator)this.descendingComparator);
    }

    @Override
    public DoubleColumn appendMissing() {
        return this.append(DoubleColumnType.missingValueIndicator());
    }

    public DoubleColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Double) {
            return this.append((double)((Double)obj));
        }
        if (obj instanceof BigDecimal) {
            return this.append(((BigDecimal)obj).doubleValue());
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public DoubleColumn appendCell(String value) {
        try {
            return this.append(DoubleColumnType.DEFAULT_PARSER.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public DoubleColumn appendCell(String value, AbstractColumnParser<?> parser) {
        try {
            return this.append(parser.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        double value = this.getDouble(row);
        if (DoubleColumnType.isMissingValue(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public DoubleColumn fillWith(DoubleIterator iterator) {
        for (int r = 0; r < this.size() && iterator.hasNext(); ++r) {
            this.set(r, iterator.nextDouble());
        }
        return this;
    }

    @Override
    public DoubleColumn fillWith(DoubleRangeIterable iterable) {
        DoubleIterator iterator = iterable.iterator();
        for (int r = 0; r < this.size() && (iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            this.set(r, iterator.nextDouble());
        }
        return this;
    }

    @Override
    public DoubleColumn fillWith(DoubleSupplier supplier) {
        for (int r = 0; r < this.size(); ++r) {
            try {
                this.set(r, supplier.getAsDouble());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public DoubleColumn inRange(int start, int end) {
        return (DoubleColumn)super.inRange(start, end);
    }

    @Override
    public DoubleColumn where(Selection selection) {
        return (DoubleColumn)super.where(selection);
    }

    @Override
    public DoubleColumn lead(int n) {
        return (DoubleColumn)super.lead(n);
    }

    public DoubleColumn setName(String name) {
        return (DoubleColumn)super.setName(name);
    }

    public DoubleColumn filter(Predicate<? super Double> test) {
        return (DoubleColumn)super.filter(test);
    }

    public DoubleColumn sorted(Comparator<? super Double> comp) {
        return (DoubleColumn)super.sorted(comp);
    }

    public DoubleColumn map(Function<? super Double, ? extends Double> fun) {
        return (DoubleColumn)super.map(fun);
    }

    public DoubleColumn min(Column<Double> other) {
        return (DoubleColumn)super.min(other);
    }

    public DoubleColumn max(Column<Double> other) {
        return (DoubleColumn)super.max(other);
    }

    public DoubleColumn set(Selection condition, Column<Double> other) {
        return (DoubleColumn)super.set(condition, other);
    }

    public DoubleColumn set(Selection rowSelection, Double newValue) {
        return (DoubleColumn)super.set(rowSelection, newValue);
    }

    public DoubleColumn first(int numRows) {
        return (DoubleColumn)super.first(numRows);
    }

    public DoubleColumn last(int numRows) {
        return (DoubleColumn)super.last(numRows);
    }

    public DoubleColumn sampleN(int n) {
        return (DoubleColumn)super.sampleN(n);
    }

    public DoubleColumn sampleX(double proportion) {
        return (DoubleColumn)super.sampleX(proportion);
    }

    @Override
    public LongColumn asLongColumn() {
        LongArrayList values = new LongArrayList();
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            values.add((long)d);
        }
        values.trim();
        return LongColumn.create(this.name(), values.elements());
    }

    @Override
    public IntColumn asIntColumn() {
        IntArrayList values = new IntArrayList();
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            values.add((int)d);
        }
        values.trim();
        return IntColumn.create(this.name(), values.elements());
    }

    @Override
    public ShortColumn asShortColumn() {
        ShortArrayList values = new ShortArrayList();
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            values.add((short)d);
        }
        values.trim();
        return ShortColumn.create(this.name(), values.elements());
    }

    @Override
    public FloatColumn asFloatColumn() {
        FloatArrayList values = new FloatArrayList();
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            values.add((float)d);
        }
        values.trim();
        return FloatColumn.create(this.name(), values.elements());
    }
}

