/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.io.Source;

public class ReadOptions {
    public static final List<ColumnType> EXTENDED_TYPE_ARRAY = Lists.newArrayList((Object[])new ColumnType[]{ColumnType.LOCAL_DATE_TIME, ColumnType.LOCAL_TIME, ColumnType.LOCAL_DATE, ColumnType.BOOLEAN, ColumnType.SHORT, ColumnType.INTEGER, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.STRING, ColumnType.TEXT});
    protected final Source source;
    protected final String tableName;
    protected final boolean sample;
    protected final String dateFormat;
    protected final String dateTimeFormat;
    protected final String timeFormat;
    protected final Locale locale;
    protected final String missingValueIndicator;
    protected final boolean minimizeColumnSizes;
    protected final int maxCharsPerColumn;
    protected final boolean header;

    protected ReadOptions(Builder builder) {
        this.source = builder.source;
        this.tableName = builder.tableName;
        this.sample = builder.sample;
        this.dateFormat = builder.dateFormat;
        this.timeFormat = builder.timeFormat;
        this.dateTimeFormat = builder.dateTimeFormat;
        this.missingValueIndicator = builder.missingValueIndicator;
        this.minimizeColumnSizes = builder.minimizeColumnSizes;
        this.header = builder.header;
        this.maxCharsPerColumn = builder.maxCharsPerColumn;
        this.locale = builder.locale == null ? Locale.getDefault() : builder.locale;
    }

    public Source source() {
        return this.source;
    }

    public String tableName() {
        return this.tableName;
    }

    public boolean sample() {
        return this.sample;
    }

    public boolean minimizeColumnSizes() {
        return this.minimizeColumnSizes;
    }

    public String missingValueIndicator() {
        return this.missingValueIndicator;
    }

    public Locale locale() {
        return this.locale;
    }

    public boolean header() {
        return this.header;
    }

    public DateTimeFormatter dateTimeFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateTimeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale);
    }

    public DateTimeFormatter timeFormatter() {
        if (Strings.isNullOrEmpty((String)this.timeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.timeFormat, this.locale);
    }

    public DateTimeFormatter dateFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
    }

    protected static class Builder {
        protected final Source source;
        protected String tableName = "";
        protected boolean sample = true;
        protected String dateFormat;
        protected String timeFormat;
        protected String dateTimeFormat;
        protected Locale locale;
        protected String missingValueIndicator;
        protected boolean minimizeColumnSizes = false;
        protected boolean header = true;
        protected int maxCharsPerColumn = 4096;

        protected Builder() {
            this.source = null;
        }

        protected Builder(Source source) {
            this.source = source;
        }

        protected Builder(File file) {
            this.source = new Source(file);
            this.tableName = file.getName();
        }

        protected Builder(URL url) throws IOException {
            this.source = new Source(url.openStream());
            this.tableName = url.toString();
        }

        protected Builder(InputStream stream) {
            this.source = new Source(stream);
        }

        protected Builder(Reader reader) {
            this.source = new Source(reader);
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder header(boolean hasHeader) {
            this.header = hasHeader;
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder maxCharsPerColumn(int maxCharsPerColumn) {
            this.maxCharsPerColumn = maxCharsPerColumn;
            return this;
        }

        public Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public Builder missingValueIndicator(String missingValueIndicator) {
            this.missingValueIndicator = missingValueIndicator;
            return this;
        }

        public Builder sample(boolean sample) {
            this.sample = sample;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder minimizeColumnSizes(boolean minimize) {
            this.minimizeColumnSizes = minimize;
            return this;
        }

        public ReadOptions build() {
            return new ReadOptions(this);
        }
    }
}

