/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.times;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.columns.times.PackedLocalTime;
import tech.tablesaw.columns.times.TimeColumnType;

@Immutable
public class TimeColumnFormatter {
    private final DateTimeFormatter format;
    private String missingString = "";

    public TimeColumnFormatter() {
        this.format = null;
    }

    public TimeColumnFormatter(DateTimeFormatter format) {
        this.format = format;
    }

    public TimeColumnFormatter(DateTimeFormatter format, String missingString) {
        this.format = format;
        this.missingString = missingString;
    }

    public String format(int value) {
        if (value == TimeColumnType.missingValueIndicator()) {
            return this.missingString;
        }
        if (this.format == null) {
            return PackedLocalTime.toShortTimeString(value);
        }
        LocalTime time = PackedLocalTime.asLocalTime(value);
        if (time == null) {
            return "";
        }
        return this.format.format(time);
    }

    public String toString() {
        return "TimeColumnFormatter{format=" + this.format + ", missingString='" + this.missingString + '\'' + '}';
    }
}

