/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.strings.NoKeysAvailableException;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface DictionaryMap {
    public void sortDescending();

    public void sortAscending();

    public String getValueForKey(int var1);

    public int size();

    public String getValueForIndex(int var1);

    public int countOccurrences(String var1);

    public Set<String> asSet();

    default public int uniqueValuesAt(int index) {
        int result = 0;
        ArrayList<String> uniqueValues = new ArrayList<String>();
        for (int i = 0; i <= index; ++i) {
            String value = this.getValueForIndex(i);
            int uniqueIndex = uniqueValues.indexOf(value);
            if (uniqueIndex >= 0) continue;
            uniqueValues.add(value);
            uniqueIndex = uniqueValues.size() - 1;
            ++result;
        }
        return result;
    }

    default public int[] asIntArray() {
        int[] result = new int[this.size()];
        ArrayList<String> uniqueValues = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            String value = this.getValueForIndex(i);
            int uniqueIndex = uniqueValues.indexOf(value);
            if (uniqueIndex < 0) {
                uniqueValues.add(value);
                uniqueIndex = uniqueValues.size() - 1;
            }
            result[i] = uniqueIndex;
        }
        return result;
    }

    public int getKeyForIndex(int var1);

    public int firstIndexOf(String var1);

    public String[] asObjectArray();

    public Selection selectIsIn(String ... var1);

    public Selection selectIsIn(Collection<String> var1);

    public void append(String var1) throws NoKeysAvailableException;

    public void set(int var1, String var2) throws NoKeysAvailableException;

    public void clear();

    public int countUnique();

    public Table countByCategory(String var1);

    public Selection isEqualTo(String var1);

    default public Selection isNotEqualTo(String string) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(0, this.size());
        selection.andNot(this.isEqualTo(string));
        return selection;
    }

    public List<BooleanColumn> getDummies();

    public byte[] asBytes(int var1);

    public int countMissing();

    public Iterator<String> iterator();

    public void appendMissing();

    public boolean isMissing(int var1);

    public DictionaryMap promoteYourself();
}

