/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.TableSlice;
import tech.tablesaw.table.TableSliceGroup;

public class PivotTable {
    public static Table pivot(Table table, CategoricalColumn<?> column1, CategoricalColumn<?> column2, NumberColumn<?> values, AggregateFunction<?, ?> aggregateFunction) {
        TableSliceGroup tsg = table.splitOn(column1);
        Table pivotTable = Table.create("Pivot: " + column1.name() + " x " + column2.name());
        pivotTable.addColumns(new Column[]{column1.type().create(column1.name())});
        List<String> valueColumnNames = PivotTable.getValueColumnNames(table, column2);
        for (String colName : valueColumnNames) {
            pivotTable.addColumns(new Column[]{DoubleColumn.create(colName)});
        }
        int valueIndex = table.columnIndex(column2);
        int keyIndex = table.columnIndex(column1);
        for (TableSlice slice : tsg.getSlices()) {
            String key = String.valueOf(slice.get(0, keyIndex));
            pivotTable.column(0).appendCell(key);
            Map<String, Double> valueMap = PivotTable.getValueMap(column1, column2, values, valueIndex, slice, aggregateFunction);
            for (String columnName : valueColumnNames) {
                Double aDouble = valueMap.get(columnName);
                NumberColumn<?> pivotValueColumn = pivotTable.numberColumn(columnName);
                if (aDouble == null) {
                    pivotValueColumn.appendMissing();
                    continue;
                }
                pivotValueColumn.appendObj(aDouble);
            }
        }
        return pivotTable;
    }

    private static Map<String, Double> getValueMap(CategoricalColumn<?> column1, CategoricalColumn<?> column2, NumberColumn<?> values, int valueIndex, TableSlice slice, AggregateFunction<?, ?> function) {
        Table temp = slice.asTable();
        Table summary = temp.summarize(values.name(), function).by(column1.name(), column2.name());
        HashMap<String, Double> valueMap = new HashMap<String, Double>();
        NumberColumn<?> nc = summary.numberColumn(summary.columnCount() - 1);
        for (int i = 0; i < summary.rowCount(); ++i) {
            valueMap.put(String.valueOf(summary.get(i, 1)), nc.getDouble(i));
        }
        return valueMap;
    }

    private static List<String> getValueColumnNames(Table table, CategoricalColumn<?> column2) {
        ArrayList<String> valueColumnNames = new ArrayList<String>();
        for (Object colName : table.column(column2.name()).unique()) {
            valueColumnNames.add(String.valueOf(colName));
        }
        valueColumnNames.sort(String::compareTo);
        return valueColumnNames;
    }
}

