/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.table.TableSlice;
import tech.tablesaw.table.TableSliceGroup;

public class StandardTableSliceGroup
extends TableSliceGroup {
    private StandardTableSliceGroup(Table original, CategoricalColumn<?> ... columns) {
        super(original, StandardTableSliceGroup.splitColumnNames(columns));
        this.setSourceTable(this.getSourceTable().sortOn(this.getSplitColumnNames()));
        this.splitOn(this.getSplitColumnNames());
    }

    private static String[] splitColumnNames(CategoricalColumn<?> ... columns) {
        String[] splitColumnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            splitColumnNames[i] = columns[i].name();
        }
        return splitColumnNames;
    }

    public static StandardTableSliceGroup create(Table original, String ... columnsNames) {
        List<CategoricalColumn<?>> columns = original.categoricalColumns(columnsNames);
        return new StandardTableSliceGroup(original, columns.toArray(new CategoricalColumn[0]));
    }

    public static StandardTableSliceGroup create(Table original, CategoricalColumn<?> ... columns) {
        return new StandardTableSliceGroup(original, columns);
    }

    private void splitOn(String ... columnNames) {
        TableSlice view;
        List<Column<?>> columns = this.getSourceTable().columns(columnNames);
        int byteSize = this.getByteSize(columns);
        byte[] currentKey = null;
        String currentStringKey = null;
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int row = 0; row < this.getSourceTable().rowCount(); ++row) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byteSize);
            String newStringKey = "";
            for (int col = 0; col < columnNames.length; ++col) {
                if (col > 0) {
                    newStringKey = newStringKey + "~~~";
                }
                Column<?> c = this.getSourceTable().column(columnNames[col]);
                String groupKey = this.getSourceTable().getUnformatted(row, this.getSourceTable().columnIndex(c));
                newStringKey = newStringKey + groupKey;
                byteBuffer.put(c.asBytes(row));
            }
            byte[] newKey = byteBuffer.array();
            if (row == 0) {
                currentKey = newKey;
                currentStringKey = newStringKey;
            }
            if (!Arrays.equals(newKey, currentKey)) {
                currentKey = newKey;
                view = new TableSlice(this.getSourceTable(), selection);
                view.setName(currentStringKey);
                currentStringKey = newStringKey;
                this.addSlice(view);
                selection = new BitmapBackedSelection();
                selection.add(row);
                continue;
            }
            selection.add(row);
        }
        if (!selection.isEmpty()) {
            view = new TableSlice(this.getSourceTable(), selection);
            view.setName(currentStringKey);
            this.addSlice(view);
        }
    }
}

