/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.util.Iterator;
import java.util.List;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.ColumnTypeDetector;
import tech.tablesaw.io.ReadOptions;

public class TableBuildingUtils {
    public static Table build(List<String> columnNames, List<String[]> dataRows, ReadOptions options) {
        int i;
        Table table = Table.create(options.tableName());
        if (dataRows.size() == 0) {
            return table;
        }
        ColumnTypeDetector detector = new ColumnTypeDetector();
        Iterator<String[]> iterator = dataRows.iterator();
        ColumnType[] types = detector.detectColumnTypes(iterator, options);
        for (i = 0; i < columnNames.size(); ++i) {
            table.addColumns(new Column[]{types[i].create(columnNames.get(i))});
        }
        for (i = 0; i < dataRows.size(); ++i) {
            for (int j = 0; j < table.columnCount(); ++j) {
                table.column(j).appendCell(dataRows.get(i)[j]);
            }
        }
        return table;
    }
}

