/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.Source;

public class CsvReadOptions
extends ReadOptions {
    private final ColumnType[] columnTypes;
    private final Character separator;
    private final String lineEnding;
    private final Integer maxNumberOfColumns;
    private final Character commentPrefix;
    private final boolean lineSeparatorDetectionEnabled;

    private CsvReadOptions(Builder builder) {
        super(builder);
        this.columnTypes = builder.columnTypes;
        this.separator = builder.separator;
        this.lineEnding = builder.lineEnding;
        this.maxNumberOfColumns = builder.maxNumberOfColumns;
        this.commentPrefix = builder.commentPrefix;
        this.lineSeparatorDetectionEnabled = builder.lineSeparatorDetectionEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Source source) {
        return new Builder(source);
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(URL url) throws IOException {
        return new Builder(url);
    }

    public static Builder builderFromFile(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builderFromString(String contents) {
        return new Builder(new StringReader(contents));
    }

    public static Builder builderFromUrl(String url) throws IOException {
        return new Builder(new URL(url));
    }

    public static Builder builder(InputStream stream) {
        return new Builder(stream);
    }

    public static Builder builder(Reader reader) {
        return new Builder(reader);
    }

    public ColumnType[] columnTypes() {
        return this.columnTypes;
    }

    public Character separator() {
        return this.separator;
    }

    public String lineEnding() {
        return this.lineEnding;
    }

    public boolean lineSeparatorDetectionEnabled() {
        return this.lineSeparatorDetectionEnabled;
    }

    public Integer maxNumberOfColumns() {
        return this.maxNumberOfColumns;
    }

    public Character commentPrefix() {
        return this.commentPrefix;
    }

    public static class Builder
    extends ReadOptions.Builder {
        private Character separator = Character.valueOf(',');
        private String lineEnding;
        private ColumnType[] columnTypes;
        private Integer maxNumberOfColumns = 10000;
        private Character commentPrefix;
        private boolean lineSeparatorDetectionEnabled = true;

        protected Builder() {
        }

        protected Builder(Source source) {
            super(source);
        }

        protected Builder(URL url) throws IOException {
            super(url);
        }

        protected Builder(File file) {
            super(file);
        }

        protected Builder(Reader reader) {
            super(reader);
        }

        protected Builder(InputStream stream) {
            super(stream);
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public Builder separator(Character separator) {
            this.separator = separator;
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            this.lineSeparatorDetectionEnabled = false;
            return this;
        }

        public Builder maxNumberOfColumns(Integer maxNumberOfColumns) {
            this.maxNumberOfColumns = maxNumberOfColumns;
            return this;
        }

        public Builder commentPrefix(Character commentPrefix) {
            this.commentPrefix = commentPrefix;
            return this;
        }

        @Override
        public CsvReadOptions build() {
            return new CsvReadOptions(this);
        }

        @Override
        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        @Override
        public Builder tableName(String tableName) {
            super.tableName(tableName);
            return this;
        }

        @Override
        public Builder sample(boolean sample) {
            super.sample(sample);
            return this;
        }

        @Override
        public Builder dateFormat(String dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        @Override
        public Builder timeFormat(String timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        @Override
        public Builder dateTimeFormat(String dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        @Override
        public Builder locale(Locale locale) {
            super.locale(locale);
            return this;
        }

        @Override
        public Builder missingValueIndicator(String missingValueIndicator) {
            super.missingValueIndicator(missingValueIndicator);
            return this;
        }

        @Override
        public Builder minimizeColumnSizes(boolean minimizeColumnSizes) {
            super.minimizeColumnSizes(minimizeColumnSizes);
            return this;
        }
    }
}

