/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Scanner;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvReader;
import tech.tablesaw.io.fixed.FixedWidthReadOptions;
import tech.tablesaw.io.fixed.FixedWidthReader;
import tech.tablesaw.io.html.HtmlTableReader;
import tech.tablesaw.io.jdbc.SqlResultSetReader;
import tech.tablesaw.io.json.JsonReader;

public class DataFrameReader {
    public Table csv(String file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(String contents, String tableName) {
        try {
            return this.csv(new StringReader(contents), tableName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Table csv(File file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(InputStream stream, String tableName) throws IOException {
        return this.csv(CsvReadOptions.builder(stream, tableName));
    }

    public Table csv(Reader reader, String tableName) throws IOException {
        return this.csv(CsvReadOptions.builder(reader, tableName));
    }

    public Table csv(CsvReadOptions.Builder options) throws IOException {
        return this.csv(options.build());
    }

    public Table csv(CsvReadOptions options) throws IOException {
        return new CsvReader().read(options);
    }

    public Table json(String url) throws MalformedURLException, IOException {
        try (Scanner scanner = new Scanner(new URL(url).openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            Table table = this.json(new StringReader(scanner.hasNext() ? scanner.next() : ""), url);
            return table;
        }
    }

    public Table json(Reader contents, String tableName) throws IOException {
        return new JsonReader().read(ReadOptions.builder(contents, tableName).build());
    }

    public Table fixedWidth(String file) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(file));
    }

    public Table fixedWidth(String contents, String tableName) {
        try {
            return this.fixedWidth(new StringReader(contents), tableName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Table fixedWidth(File file) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(file));
    }

    public Table fixedWidth(InputStream stream, String tableName) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(stream, tableName));
    }

    public Table fixedWidth(Reader reader, String tableName) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(reader, tableName));
    }

    public Table fixedWidth(FixedWidthReadOptions.Builder options) throws IOException {
        return this.fixedWidth(options.build());
    }

    public Table fixedWidth(FixedWidthReadOptions options) throws IOException {
        return new FixedWidthReader().read(options);
    }

    public Table db(ResultSet resultSet, String tableName) throws SQLException {
        return SqlResultSetReader.read(resultSet, tableName);
    }

    public Table html(String url) throws IOException {
        return new HtmlTableReader().read(url);
    }
}

