/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.tuple.Pair;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.ColumnTypeDetector;
import tech.tablesaw.io.TableBuildingUtils;
import tech.tablesaw.io.csv.AddCellToColumnException;
import tech.tablesaw.io.csv.CsvReadOptions;

@Immutable
public class CsvReader {
    private List<ColumnType> typeArrayOverrides = null;

    public CsvReader() {
    }

    public CsvReader(List<ColumnType> typeDetectionList) {
        this.typeArrayOverrides = typeDetectionList;
    }

    private Pair<Reader, ColumnType[]> getReaderAndColumnTypes(CsvReadOptions options) throws IOException {
        ColumnType[] types = options.columnTypes();
        byte[] bytesCache = null;
        if (types == null) {
            Reader reader = TableBuildingUtils.createReader(options, bytesCache);
            if (options.file() == null) {
                bytesCache = CharStreams.toString((Readable)reader).getBytes();
                reader = TableBuildingUtils.createReader(options, bytesCache);
            }
            types = this.detectColumnTypes(reader, options);
        }
        return Pair.of((Object)TableBuildingUtils.createReader(options, bytesCache), (Object)types);
    }

    public Table read(CsvReadOptions options) throws IOException {
        return this.read(options, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table read(CsvReadOptions options, boolean headerOnly) throws IOException {
        Pair<Reader, ColumnType[]> pair = this.getReaderAndColumnTypes(options);
        Reader reader = (Reader)pair.getLeft();
        ColumnType[] types = (ColumnType[])pair.getRight();
        CsvParser parser = this.csvParser(options);
        try {
            parser.beginParsing(reader);
            Table table = Table.create(options.tableName());
            ArrayList headerRow = Lists.newArrayList((Object[])this.getHeaderNames(options, types, parser));
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                String columnName = this.cleanName((String)headerRow.get(x));
                if (Strings.isNullOrEmpty((String)columnName)) {
                    columnName = "Column " + table.columnCount();
                }
                Column<?> newColumn = types[x].create(columnName);
                table.addColumns(new Column[]{newColumn});
            }
            if (!headerOnly) {
                String[] columnNames = this.selectColumnNames(headerRow, types);
                int[] columnIndexes = new int[columnNames.length];
                for (int i = 0; i < columnIndexes.length; ++i) {
                    columnIndexes[i] = headerRow.indexOf(columnNames[i]);
                }
                this.addRows(options, types, parser, table, columnIndexes);
            }
            Table table2 = table;
            return table2;
        }
        finally {
            if (options.reader() == null) {
                parser.stopParsing();
                reader.close();
            }
        }
    }

    private String[] getHeaderNames(CsvReadOptions options, ColumnType[] types, CsvParser parser) {
        if (options.header()) {
            String[] headerNames = parser.parseNext();
            for (int i = 0; i < headerNames.length; ++i) {
                if (headerNames[i] != null) continue;
                headerNames[i] = "C" + i;
            }
            return headerNames;
        }
        String[] headerNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            headerNames[i] = "C" + i;
        }
        return headerNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addRows(CsvReadOptions options, ColumnType[] types, CsvParser reader, Table table, int[] columnIndexes) {
        long rowNumber;
        Map<String, AbstractParser<?>> parserMap = this.getParserMap(options, table);
        long l = rowNumber = options.header() ? 1L : 0L;
        while (true) {
            block9: {
                String[] nextLine;
                if ((nextLine = reader.parseNext()) == null) {
                    return;
                }
                if (nextLine.length < types.length) {
                    if (nextLine.length == 1 && Strings.isNullOrEmpty((String)nextLine[0])) {
                        System.err.println("Warning: Invalid CSV file. Row " + rowNumber + " is empty. Continuing.");
                        break block9;
                    } else {
                        IndexOutOfBoundsException e = new IndexOutOfBoundsException("Row number " + rowNumber + " contains " + nextLine.length + " columns. " + types.length + " expected.");
                        throw new AddCellToColumnException(e, 0, rowNumber, table.columnNames(), nextLine);
                    }
                }
                if (nextLine.length > types.length) {
                    throw new IllegalArgumentException("Row number " + rowNumber + " contains " + nextLine.length + " columns. " + types.length + " expected.");
                }
                int cellIndex = 0;
                int[] nArray = columnIndexes;
                int n = nArray.length;
                for (int i = 0; i < n; ++cellIndex, ++i) {
                    int columnIndex = nArray[i];
                    Column<?> column = table.column(cellIndex);
                    AbstractParser<?> parser = parserMap.get(column.name());
                    try {
                        String value = nextLine[columnIndex];
                        column.appendCell(value, parser);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AddCellToColumnException(e, columnIndex, rowNumber, table.columnNames(), nextLine);
                    }
                }
            }
            ++rowNumber;
        }
    }

    private Map<String, AbstractParser<?>> getParserMap(CsvReadOptions options, Table table) {
        HashMap parserMap = new HashMap();
        for (Column<?> column : table.columns()) {
            AbstractParser<?> parser = column.type().customParser(options);
            parserMap.put(column.name(), parser);
        }
        return parserMap;
    }

    private String cleanName(String name) {
        return name.trim();
    }

    public String printColumnTypes(CsvReadOptions options) throws IOException {
        Table structure = this.read(options, true).structure();
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnType[] columnTypes = {");
        buf.append(System.lineSeparator());
        Column<?> typeCol = structure.column("Column Type");
        Column<?> indxCol = structure.column("Index");
        Column<?> nameCol = structure.column("Column Name");
        int typeColIndex = structure.columnIndex(typeCol);
        int indxColIndex = structure.columnIndex(indxCol);
        int nameColIndex = structure.columnIndex(nameCol);
        int typeColWidth = typeCol.columnWidth();
        int indxColWidth = indxCol.columnWidth();
        int nameColWidth = nameCol.columnWidth();
        int padChar = 32;
        for (int r = 0; r < structure.rowCount(); ++r) {
            String cell = Strings.padEnd((String)(structure.get(r, typeColIndex) + ","), (int)typeColWidth, (char)' ');
            buf.append(cell);
            buf.append(" // ");
            cell = Strings.padEnd((String)structure.getUnformatted(r, indxColIndex), (int)indxColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            cell = Strings.padEnd((String)structure.getUnformatted(r, nameColIndex), (int)nameColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            buf.append(System.lineSeparator());
        }
        buf.append("}");
        buf.append(System.lineSeparator());
        return buf.toString();
    }

    private String[] selectColumnNames(List<String> names, ColumnType[] types) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ColumnType.SKIP) continue;
            String name = names.get(i);
            name = name.trim();
            header.add(name);
        }
        String[] result = new String[header.size()];
        return header.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ColumnType[] detectColumnTypes(Reader reader, CsvReadOptions options) {
        boolean header = options.header();
        int linesToSkip = header ? 1 : 0;
        final CsvParser csvParser = this.csvParser(options);
        try {
            csvParser.beginParsing(reader);
            for (int i = 0; i < linesToSkip; ++i) {
                csvParser.parseNext();
            }
            ColumnTypeDetector detector = this.typeArrayOverrides == null ? new ColumnTypeDetector() : new ColumnTypeDetector(this.typeArrayOverrides);
            ColumnType[] columnTypeArray = detector.detectColumnTypes(new Iterator<String[]>(){
                String[] nextRow;
                {
                    this.nextRow = csvParser.parseNext();
                }

                @Override
                public boolean hasNext() {
                    return this.nextRow != null;
                }

                @Override
                public String[] next() {
                    String[] tmp = this.nextRow;
                    this.nextRow = csvParser.parseNext();
                    return tmp;
                }
            }, options);
            return columnTypeArray;
        }
        finally {
            csvParser.stopParsing();
        }
    }

    private CsvParser csvParser(CsvReadOptions options) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setFormat((Format)this.csvFormat(options));
        if (options.maxNumberOfColumns() != null) {
            settings.setMaxColumns(options.maxNumberOfColumns().intValue());
        }
        return new CsvParser(settings);
    }

    private CsvFormat csvFormat(CsvReadOptions options) {
        CsvFormat format = new CsvFormat();
        if (options.separator() != null) {
            format.setDelimiter(options.separator().charValue());
        }
        if (options.lineEnding() != null) {
            format.setLineSeparator(options.lineEnding());
        }
        return format;
    }
}

