/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvWriteOptions;
import tech.tablesaw.io.csv.CsvWriter;
import tech.tablesaw.io.html.HtmlTableWriter;
import tech.tablesaw.io.json.JsonWriteOptions;
import tech.tablesaw.io.json.JsonWriter;

public class DataFrameWriter {
    private final Table table;

    public DataFrameWriter(Table table) {
        this.table = table;
    }

    public void csv(String file) throws IOException {
        CsvWriteOptions options = new CsvWriteOptions.Builder(file).build();
        new CsvWriter(this.table, options).write();
    }

    public void csv(File file) throws IOException {
        CsvWriteOptions options = new CsvWriteOptions.Builder(file).build();
        new CsvWriter(this.table, options).write();
    }

    public void csv(CsvWriteOptions options) {
        new CsvWriter(this.table, options).write();
    }

    public void csv(OutputStream stream) {
        CsvWriteOptions options = new CsvWriteOptions.Builder(stream).build();
        new CsvWriter(this.table, options).write();
    }

    public void csv(Writer writer) {
        CsvWriteOptions options = new CsvWriteOptions.Builder(writer).build();
        new CsvWriter(this.table, options).write();
    }

    public void html(OutputStream stream) {
        HtmlTableWriter.write(this.table, stream);
    }

    public String json() throws IOException {
        return this.json(JsonWriteOptions.builder().build());
    }

    public String json(JsonWriteOptions options) throws IOException {
        return new JsonWriter(options).write(this.table);
    }
}

