/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlTableReader {
    public String tableToCsv(String url) throws IOException {
        Document doc = Jsoup.connect((String)url).get();
        Elements tables = doc.select("table");
        if (tables.size() != 1) {
            throw new IllegalStateException("Reading html to table currently works if there is exactly 1 html table on the page.  The URL you passed has " + tables.size() + ". You may file a feature request with the URL if you'd like your pagae to be supported");
        }
        Element table = (Element)tables.get(0);
        CsvWriterSettings settings = new CsvWriterSettings();
        StringWriter stringWriter = new StringWriter();
        CsvWriter csvWriter = new CsvWriter((Writer)stringWriter, settings);
        for (Element row : table.select("tr")) {
            Elements headerCells = row.getElementsByTag("th");
            Elements cells = row.getElementsByTag("td");
            String[] nextLine = (String[])Stream.concat(headerCells.stream(), cells.stream()).map(Element::text).toArray(String[]::new);
            csvWriter.writeRow(nextLine);
        }
        return stringWriter.toString();
    }
}

