/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.io.csv.AddCellToColumnException;
import tech.tablesaw.io.csv.CsvReadOptions;

@Immutable
public class CsvReader {
    private static final int STRING_COLUMN_ROW_COUNT_CUTOFF = 50000;
    private static final double STRING_COLUMN_CUTOFF = 0.5;
    private List<ColumnType> typeArray = Lists.newArrayList((Object[])new ColumnType[]{ColumnType.LOCAL_DATE_TIME, ColumnType.LOCAL_TIME, ColumnType.LOCAL_DATE, ColumnType.BOOLEAN, ColumnType.SHORT, ColumnType.INTEGER, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.STRING, ColumnType.TEXT});

    public CsvReader() {
    }

    public CsvReader(List<ColumnType> typeDetectionList) {
        this.typeArray = typeDetectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table read(CsvReadOptions options) throws IOException {
        ColumnType[] types = options.columnTypes();
        byte[] bytes = null;
        if (types == null) {
            if (options.reader() != null) {
                bytes = CharStreams.toString((Readable)options.reader()).getBytes();
            }
            if (options.inputStream() != null) {
                bytes = ByteStreams.toByteArray((InputStream)options.inputStream());
            }
            types = this.getColumnTypes(options, bytes);
        }
        Reader reader = this.getReader(options, bytes);
        CsvParser parser = this.csvParser(options);
        try {
            parser.beginParsing(reader);
            Table table = Table.create(options.tableName());
            Object[] headerNames = this.getHeaderNames(options, types, parser);
            if (headerNames == null) {
                Table table2 = table;
                return table2;
            }
            ArrayList headerRow = Lists.newArrayList((Object[])headerNames);
            String[] columnNames = this.selectColumnNames(headerRow, types);
            this.cleanNames(headerRow);
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                String columnName = (String)headerRow.get(x);
                if (Strings.isNullOrEmpty((String)columnName)) {
                    columnName = "Column " + table.columnCount();
                }
                Column<?> newColumn = types[x].create(columnName);
                table.addColumns(new Column[]{newColumn});
            }
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
            this.addRows(options, types, parser, table, columnNames, columnIndexes);
            Table table3 = table;
            return table3;
        }
        finally {
            if (options.reader() == null) {
                parser.stopParsing();
                reader.close();
            }
        }
    }

    private String[] getHeaderNames(CsvReadOptions options, ColumnType[] types, CsvParser parser) {
        String[] headerNames;
        if (options.header()) {
            headerNames = parser.parseNext();
            for (int i = 0; i < headerNames.length; ++i) {
                if (headerNames[i] != null) continue;
                headerNames[i] = "C" + i;
            }
        } else {
            headerNames = this.makeColumnNames(types);
        }
        return headerNames;
    }

    private Reader getReader(CsvReadOptions options, byte[] bytes) throws FileNotFoundException {
        if (bytes != null) {
            return new InputStreamReader(new ByteArrayInputStream(bytes));
        }
        if (options.inputStream() != null) {
            return new InputStreamReader(options.inputStream());
        }
        if (options.reader() != null) {
            return options.reader();
        }
        return new InputStreamReader(new FileInputStream(options.file()));
    }

    private ColumnType[] getColumnTypes(CsvReadOptions options, byte[] bytes) throws IOException {
        ColumnType[] types;
        try (InputStream detectTypesStream = options.file() != null ? new FileInputStream(options.file()) : new ByteArrayInputStream(bytes);){
            types = this.detectColumnTypes(detectTypesStream, options);
        }
        return types;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addRows(CsvReadOptions options, ColumnType[] types, CsvParser reader, Table table, String[] columnNames, int[] columnIndexes) {
        long rowNumber = options.header() ? 1L : 0L;
        Map<String, AbstractParser<?>> parserMap = this.getParserMap(options, table);
        while (true) {
            block9: {
                String[] nextLine;
                if ((nextLine = reader.parseNext()) == null) {
                    return;
                }
                if (nextLine.length < types.length) {
                    if (nextLine.length == 1 && Strings.isNullOrEmpty((String)nextLine[0])) {
                        System.err.println("Warning: Invalid CSV file. Row " + rowNumber + " is empty. Continuing.");
                        break block9;
                    } else {
                        IndexOutOfBoundsException e = new IndexOutOfBoundsException("Row number " + rowNumber + " is too short.");
                        throw new AddCellToColumnException(e, 0, rowNumber, columnNames, nextLine);
                    }
                }
                if (nextLine.length > types.length) {
                    throw new IllegalArgumentException("Row number " + rowNumber + " is too long.");
                }
                int cellIndex = 0;
                int[] nArray = columnIndexes;
                int n = nArray.length;
                for (int i = 0; i < n; ++cellIndex, ++i) {
                    int columnIndex = nArray[i];
                    Column<?> column = table.column(cellIndex);
                    AbstractParser<?> parser = parserMap.get(column.name());
                    try {
                        String value = nextLine[columnIndex];
                        column.appendCell(value, parser);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AddCellToColumnException(e, columnIndex, rowNumber, columnNames, nextLine);
                    }
                }
            }
            ++rowNumber;
        }
    }

    private Map<String, AbstractParser<?>> getParserMap(CsvReadOptions options, Table table) {
        HashMap parserMap = new HashMap();
        for (Column<?> column : table.columns()) {
            AbstractParser<?> parser = column.type().customParser(options);
            parserMap.put(column.name(), parser);
        }
        return parserMap;
    }

    private void cleanNames(List<String> headerRow) {
        for (int i = 0; i < headerRow.size(); ++i) {
            headerRow.set(i, headerRow.get(i).trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table headerOnly(ColumnType[] types, boolean header, CsvReadOptions options, File file) throws IOException {
        Table table;
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(fis);
        CsvParser csvParser = this.csvParser(options);
        try (BufferedReader streamReader = new BufferedReader(reader);){
            Object[] headerNames;
            csvParser.beginParsing((Reader)streamReader);
            if (header) {
                headerNames = csvParser.parseNext();
                for (int i = 0; i < headerNames.length; ++i) {
                    if (headerNames[i] != null) continue;
                    headerNames[i] = "C" + i;
                }
            } else {
                headerNames = this.makeColumnNames(types);
            }
            ArrayList headerRow = Lists.newArrayList((Object[])headerNames);
            String[] columnNames = this.selectColumnNames(headerRow, types);
            table = Table.create(file.getName());
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                Column<?> newColumn = types[x].create(((String)headerRow.get(x)).trim());
                table.addColumns(new Column[]{newColumn});
            }
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
        }
        finally {
            csvParser.stopParsing();
        }
        return table;
    }

    private Table detectedColumnTypes(String csvFileName, boolean header, char delimiter, Locale locale) throws IOException {
        File file = new File(csvFileName);
        try (FileInputStream stream = new FileInputStream(file);){
            CsvReadOptions options = CsvReadOptions.builder(stream, "").separator(delimiter).header(header).locale(locale).sample(true).build();
            ColumnType[] types = this.detectColumnTypes(stream, options);
            Table t = this.headerOnly(types, header, options, file);
            Table table = t.structure();
            return table;
        }
    }

    public String printColumnTypes(String csvFileName, boolean header, char delimiter, Locale locale) throws IOException {
        Table structure = this.detectedColumnTypes(csvFileName, header, delimiter, locale);
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnType[] columnTypes = {");
        buf.append(System.lineSeparator());
        Column<?> typeCol = structure.column("Column Type");
        Column<?> indxCol = structure.column("Index");
        Column<?> nameCol = structure.column("Column Name");
        int typeColIndex = structure.columnIndex(typeCol);
        int indxColIndex = structure.columnIndex(indxCol);
        int nameColIndex = structure.columnIndex(nameCol);
        int typeColWidth = typeCol.columnWidth();
        int indxColWidth = indxCol.columnWidth();
        int nameColWidth = nameCol.columnWidth();
        int padChar = 32;
        for (int r = 0; r < structure.rowCount(); ++r) {
            String cell = Strings.padEnd((String)(structure.get(r, typeColIndex) + ","), (int)typeColWidth, (char)' ');
            buf.append(cell);
            buf.append(" // ");
            cell = Strings.padEnd((String)structure.getUnformatted(r, indxColIndex), (int)indxColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            cell = Strings.padEnd((String)structure.getUnformatted(r, nameColIndex), (int)nameColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            buf.append(System.lineSeparator());
        }
        buf.append("}");
        buf.append(System.lineSeparator());
        return buf.toString();
    }

    private String[] selectColumnNames(List<String> names, ColumnType[] types) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ColumnType.SKIP) continue;
            String name = names.get(i);
            name = name.trim();
            header.add(name);
        }
        String[] result = new String[header.size()];
        return header.toArray(result);
    }

    private String[] makeColumnNames(ColumnType[] types) {
        String[] header = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            header[i] = "C" + i;
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnType[] detectColumnTypes(InputStream stream, CsvReadOptions options) {
        boolean header = options.header();
        boolean useSampling = options.sample();
        int linesToSkip = header ? 1 : 0;
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        ArrayList columnData = new ArrayList();
        int rowCount = 0;
        CsvParser csvParser = this.csvParser(options);
        try {
            String[] nextLine;
            csvParser.beginParsing((Reader)new InputStreamReader(stream));
            for (int i = 0; i < linesToSkip; ++i) {
                csvParser.parseNext();
            }
            boolean bl = false;
            while ((nextLine = csvParser.parseNext()) != null) {
                int n;
                if (rowCount == 0) {
                    for (int i = 0; i < nextLine.length; ++i) {
                        columnData.add(new ArrayList());
                    }
                }
                int columnNumber = 0;
                if (rowCount == n) {
                    for (String field : nextLine) {
                        ((List)columnData.get(columnNumber)).add(field);
                        ++columnNumber;
                    }
                    n = useSampling ? this.nextRow(n) : this.nextRowWithoutSampling(n);
                }
                ++rowCount;
            }
        }
        finally {
            csvParser.stopParsing();
        }
        for (List list : columnData) {
            HashSet unique;
            double uniquePct;
            ColumnType detectedType = this.detectType(list, options);
            if (detectedType.equals(StringColumnType.STRING) && rowCount > 50000 && (uniquePct = (double)(unique = new HashSet(list)).size() / ((double)list.size() * 1.0)) > 0.5) {
                detectedType = ColumnType.TEXT;
            }
            columnTypes.add(detectedType);
        }
        return columnTypes.toArray(new ColumnType[0]);
    }

    private int nextRowWithoutSampling(int nextRow) {
        return nextRow + 1;
    }

    private int nextRow(int nextRow) {
        if (nextRow < 10000) {
            return nextRow + 1;
        }
        if (nextRow < 100000) {
            return nextRow + 1000;
        }
        if (nextRow < 1000000) {
            return nextRow + 10000;
        }
        if (nextRow < 10000000) {
            return nextRow + 100000;
        }
        if (nextRow < 100000000) {
            return nextRow + 1000000;
        }
        return nextRow + 10000000;
    }

    private ColumnType detectType(List<String> valuesList, CsvReadOptions options) {
        CopyOnWriteArrayList parsers = new CopyOnWriteArrayList(this.getParserList(this.typeArray, options));
        CopyOnWriteArrayList<ColumnType> typeCandidates = new CopyOnWriteArrayList<ColumnType>(this.typeArray);
        for (String s : valuesList) {
            for (AbstractParser<?> parser : parsers) {
                if (parser.canParse(s)) continue;
                typeCandidates.remove(parser.columnType());
                parsers.remove(parser);
            }
        }
        return this.selectType(typeCandidates);
    }

    private ColumnType selectType(List<ColumnType> typeCandidates) {
        return typeCandidates.get(0);
    }

    private List<AbstractParser<?>> getParserList(List<ColumnType> typeArray, CsvReadOptions options) {
        ArrayList parsers = new ArrayList();
        for (ColumnType type : typeArray) {
            parsers.add(type.customParser(options));
        }
        return parsers;
    }

    private CsvParser csvParser(CsvReadOptions options) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setFormat((Format)this.csvFormat(options));
        if (options.maxNumberOfColumns() != null) {
            settings.setMaxColumns(options.maxNumberOfColumns().intValue());
        }
        return new CsvParser(settings);
    }

    private CsvFormat csvFormat(CsvReadOptions options) {
        CsvFormat format = new CsvFormat();
        if (options.separator() != null) {
            format.setDelimiter(options.separator().charValue());
        }
        if (options.lineEnding() != null) {
            format.setLineSeparator(options.lineEnding());
        }
        return format;
    }

    public List<ColumnType> getTypeArray() {
        return this.typeArray;
    }
}

