/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.util.LevenshteinDistance;
import tech.tablesaw.util.StringUtils;

public interface StringMapFunctions
extends Column<String> {
    default public StringColumn upperCase() {
        StringColumn newColumn = StringColumn.create(this.name() + "[ucase]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            if (value == null) {
                newColumn.append(StringColumnType.missingValueIndicator());
                continue;
            }
            newColumn.append(value.toUpperCase());
        }
        return newColumn;
    }

    default public StringColumn lowerCase() {
        StringColumn newColumn = StringColumn.create(this.name() + "[lcase]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(value.toLowerCase());
        }
        return newColumn;
    }

    default public StringColumn trim() {
        StringColumn newColumn = StringColumn.create(this.name() + "[trim]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(value.trim());
        }
        return newColumn;
    }

    default public StringColumn replaceAll(String regex, String replacement) {
        StringColumn newColumn = StringColumn.create(this.name() + "[repl]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(value.replaceAll(regex, replacement));
        }
        return newColumn;
    }

    default public StringColumn replaceFirst(String regex, String replacement) {
        StringColumn newColumn = StringColumn.create(this.name() + "[repl]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(value.replaceFirst(regex, replacement));
        }
        return newColumn;
    }

    default public StringColumn substring(int start, int end) {
        StringColumn newColumn = StringColumn.create(this.name() + "[sub]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(value.substring(start, end));
        }
        return newColumn;
    }

    default public StringColumn substring(int start) {
        StringColumn newColumn = StringColumn.create(this.name() + "[sub]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(value.substring(start));
        }
        return newColumn;
    }

    default public StringColumn abbreviate(int maxWidth) {
        String defaultAbbrevMarker = "...";
        StringColumn newColumn = StringColumn.create(this.name() + "[abbr]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(StringUtils.abbreviate(value, "...", maxWidth));
        }
        return newColumn;
    }

    default public StringColumn format(String formatString) {
        StringColumn newColumn = StringColumn.create(this.name() + "[formatted]");
        for (int r = 0; r < this.size(); ++r) {
            newColumn.append(String.format(formatString, this.getString(r)));
        }
        return newColumn;
    }

    default public IntColumn parseInt() {
        IntColumn newColumn = IntColumn.create(this.name() + "[parsed]");
        for (int r = 0; r < this.size(); ++r) {
            newColumn.append(Integer.parseInt(this.getString(r)));
        }
        return newColumn;
    }

    default public StringColumn padEnd(int minLength, char padChar) {
        StringColumn newColumn = StringColumn.create(this.name() + "[pad]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(Strings.padEnd((String)value, (int)minLength, (char)padChar));
        }
        return newColumn;
    }

    default public StringColumn padStart(int minLength, char padChar) {
        StringColumn newColumn = StringColumn.create(this.name() + "[pad]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.append(Strings.padStart((String)value, (int)minLength, (char)padChar));
        }
        return newColumn;
    }

    default public StringColumn commonPrefix(Column<?> column2) {
        StringColumn newColumn = StringColumn.create(this.name() + column2.name() + "[prefix]");
        for (int r = 0; r < this.size(); ++r) {
            String value1 = this.getString(r);
            String value2 = column2.getString(r);
            newColumn.append(Strings.commonPrefix((CharSequence)value1, (CharSequence)value2));
        }
        return newColumn;
    }

    default public StringColumn commonSuffix(Column<?> column2) {
        StringColumn newColumn = StringColumn.create(this.name() + column2.name() + "[suffix]");
        for (int r = 0; r < this.size(); ++r) {
            String value1 = this.getString(r);
            String value2 = column2.getString(r);
            newColumn.append(Strings.commonSuffix((CharSequence)value1, (CharSequence)value2));
        }
        return newColumn;
    }

    default public DoubleColumn distance(Column<?> column2) {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + column2.name() + "[distance]");
        for (int r = 0; r < this.size(); ++r) {
            String value1 = this.getString(r);
            String value2 = column2.getString(r);
            newColumn.append(LevenshteinDistance.getDefaultInstance().apply(value1, value2));
        }
        return newColumn;
    }

    default public StringColumn join(String separator, Column<?> ... columns) {
        StringColumn newColumn = StringColumn.create(this.name() + "[column appended]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String result = this.getString(r);
            for (Column<?> stringColumn : columns) {
                result = result + separator + stringColumn.get(r);
            }
            newColumn.set(r, result);
        }
        return newColumn;
    }

    default public StringColumn concatenate(String append) {
        StringColumn newColumn = StringColumn.create(this.name() + "[append]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            newColumn.set(r, this.getString(r) + append);
        }
        return newColumn;
    }

    default public StringColumn replaceAll(String[] regexArray, String replacement) {
        StringColumn newColumn = StringColumn.create(this.name() + "[repl]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            for (String regex : regexArray) {
                value = value.replaceAll(regex, replacement);
            }
            newColumn.set(r, value);
        }
        return newColumn;
    }

    default public StringColumn tokenizeAndSort(String separator) {
        StringColumn newColumn = StringColumn.create(this.name() + "[sorted]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            Splitter splitter = Splitter.on((String)separator);
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            Collections.sort(tokens);
            value = String.join((CharSequence)separator, tokens);
            newColumn.set(r, value);
        }
        return newColumn;
    }

    default public DoubleColumn countTokens(String separator) {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[token count]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            Splitter splitter = Splitter.on((String)separator);
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            newColumn.set(r, tokens.size());
        }
        return newColumn;
    }

    default public StringColumn uniqueTokens(String separator) {
        return this.tokens(separator).unique();
    }

    default public StringColumn tokens(String separator) {
        StringColumn newColumn = StringColumn.create(this.name() + "[token count]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            Splitter splitter = Splitter.on((String)separator);
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            for (String token : tokens) {
                newColumn.append(token);
            }
        }
        return newColumn;
    }

    default public DoubleColumn length() {
        DoubleColumn newColumn = DoubleColumn.create(this.name() + "[length]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            newColumn.set(r, this.getString(r).length());
        }
        return newColumn;
    }

    default public StringColumn tokenizeAndSort() {
        StringColumn newColumn = StringColumn.create(this.name() + "[sorted]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.whitespace());
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            Collections.sort(tokens);
            value = String.join((CharSequence)" ", tokens);
            newColumn.set(r, value);
        }
        return newColumn;
    }

    default public StringColumn tokenizeAndRemoveDuplicates(String separator) {
        StringColumn newColumn = StringColumn.create(this.name() + "[without duplicates]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            Splitter splitter = Splitter.on((String)separator);
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            String result = tokens.stream().distinct().collect(Collectors.joining(separator));
            newColumn.set(r, result);
        }
        return newColumn;
    }
}

