/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.function.Function;
import tech.tablesaw.columns.strings.StringColumnType;

public class StringColumnFormatter {
    private final Function<String, String> formatter;
    private String missingString = "";

    public StringColumnFormatter() {
        this.formatter = null;
    }

    public StringColumnFormatter(Function<String, String> formatFunction) {
        this.formatter = formatFunction;
    }

    public StringColumnFormatter(Function<String, String> formatFunction, String missingString) {
        this.formatter = formatFunction;
        this.missingString = missingString;
    }

    public String format(String value) {
        if (StringColumnType.missingValueIndicator().equals(value)) {
            return this.missingString;
        }
        if (this.formatter == null) {
            return value;
        }
        return this.formatter.apply(value);
    }

    public String toString() {
        return "StringColumnFormatter{format=" + this.formatter + ", missingString='" + this.missingString + '\'' + '}';
    }
}

