/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDate;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.DateAndTimePredicates;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.filtering.predicates.IntBiPredicate;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface DateFilters
extends Column<LocalDate> {
    public DateColumn where(Selection var1);

    default public Selection eval(IntPredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data().size(); ++idx) {
            int next = this.data().getInt(idx);
            if (!predicate.test(next)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(IntBiPredicate predicate, int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data().size(); ++idx) {
            int next = this.data().getInt(idx);
            if (!predicate.test(next, value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(IntBiPredicate predicate, DateColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.getIntInternal(idx), otherColumn.getIntInternal(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    public int getIntInternal(int var1);

    default public Selection eval(BiPredicate<LocalDate, LocalDate> predicate, LocalDate valueToCompare) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test((LocalDate)this.get(idx), valueToCompare)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<LocalDate> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test((LocalDate)this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection isMonday() {
        return this.eval(PackedLocalDate::isMonday);
    }

    default public Selection isTuesday() {
        return this.eval(PackedLocalDate::isTuesday);
    }

    default public Selection isWednesday() {
        return this.eval(PackedLocalDate::isWednesday);
    }

    default public Selection isThursday() {
        return this.eval(PackedLocalDate::isThursday);
    }

    default public Selection isFriday() {
        return this.eval(PackedLocalDate::isFriday);
    }

    default public Selection isSaturday() {
        return this.eval(PackedLocalDate::isSaturday);
    }

    default public Selection isSunday() {
        return this.eval(PackedLocalDate::isSunday);
    }

    default public Selection isInJanuary() {
        return this.eval(PackedLocalDate::isInJanuary);
    }

    default public Selection isInFebruary() {
        return this.eval(PackedLocalDate::isInFebruary);
    }

    default public Selection isInMarch() {
        return this.eval(PackedLocalDate::isInMarch);
    }

    default public Selection isInApril() {
        return this.eval(PackedLocalDate::isInApril);
    }

    default public Selection isInMay() {
        return this.eval(PackedLocalDate::isInMay);
    }

    default public Selection isInJune() {
        return this.eval(PackedLocalDate::isInJune);
    }

    default public Selection isInJuly() {
        return this.eval(PackedLocalDate::isInJuly);
    }

    default public Selection isInAugust() {
        return this.eval(PackedLocalDate::isInAugust);
    }

    default public Selection isInSeptember() {
        return this.eval(PackedLocalDate::isInSeptember);
    }

    default public Selection isInOctober() {
        return this.eval(PackedLocalDate::isInOctober);
    }

    default public Selection isInNovember() {
        return this.eval(PackedLocalDate::isInNovember);
    }

    default public Selection isInDecember() {
        return this.eval(PackedLocalDate::isInDecember);
    }

    default public Selection isFirstDayOfMonth() {
        return this.eval(PackedLocalDate::isFirstDayOfMonth);
    }

    default public Selection isLastDayOfMonth() {
        return this.eval(PackedLocalDate::isLastDayOfMonth);
    }

    default public Selection isInQ1() {
        return this.eval(PackedLocalDate::isInQ1);
    }

    default public Selection isInQ2() {
        return this.eval(PackedLocalDate::isInQ2);
    }

    default public Selection isInQ3() {
        return this.eval(PackedLocalDate::isInQ3);
    }

    default public Selection isInQ4() {
        return this.eval(PackedLocalDate::isInQ4);
    }

    default public Selection isInYear(int year) {
        return this.eval(PackedLocalDate::isInYear, year);
    }

    default public Selection isAfter(int value) {
        return this.eval(PackedLocalDate::isAfter, value);
    }

    default public Selection isAfter(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.eval(PackedLocalDate::isAfter, packed);
    }

    default public Selection isBefore(int value) {
        return this.eval(PackedLocalDate::isBefore, value);
    }

    default public Selection isBetweenExcluding(int lowValue, int highValue) {
        return this.eval(PackedLocalDate::isAfter, lowValue).and(this.eval(PackedLocalDate::isBefore, highValue));
    }

    default public Selection isBetweenExcluding(LocalDate lowValue, LocalDate highValue) {
        return this.isBetweenExcluding(PackedLocalDate.pack(lowValue), PackedLocalDate.pack(highValue));
    }

    default public Selection isBetweenIncluding(LocalDate lowValue, LocalDate highValue) {
        return this.isBetweenIncluding(PackedLocalDate.pack(lowValue), PackedLocalDate.pack(highValue));
    }

    default public Selection isBetweenIncluding(int lowValue, int highValue) {
        return this.eval(PackedLocalDate::isOnOrAfter, lowValue).and(this.eval(PackedLocalDate::isOnOrBefore, highValue));
    }

    default public Selection isBefore(LocalDate value) {
        return this.isBefore(PackedLocalDate.pack(value));
    }

    default public Selection isOnOrBefore(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.eval(PackedLocalDate::isOnOrBefore, packed);
    }

    default public Selection isOnOrAfter(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.eval(DateAndTimePredicates.isGreaterThanOrEqualTo, packed);
    }

    default public Selection isEqualTo(LocalDate value) {
        return this.eval(DateAndTimePredicates.isEqualTo, PackedLocalDate.pack(value));
    }

    default public Selection isEqualTo(int packedDate) {
        return this.eval(DateAndTimePredicates.isEqualTo, packedDate);
    }

    default public Selection isEqualTo(DateColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator intIterator = column.intIterator();
        IntListIterator intListIterator = this.data().iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (next == intIterator.nextInt()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isNotEqualTo(DateColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isEqualTo(column));
    }

    default public Selection isOnOrBefore(DateColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isAfter(column));
    }

    default public Selection isOnOrAfter(DateColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isBefore(column));
    }

    default public Selection isAfter(DateColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator intIterator = column.intIterator();
        IntListIterator intListIterator = this.data().iterator();
        while (intListIterator.hasNext()) {
            long next = ((Integer)intListIterator.next()).intValue();
            if (next > (long)intIterator.nextInt()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isBefore(DateColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator intIterator = column.intIterator();
        IntListIterator intListIterator = this.data().iterator();
        while (intListIterator.hasNext()) {
            long next = ((Integer)intListIterator.next()).intValue();
            if (next < (long)intIterator.nextInt()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    default public Selection isMissing() {
        return this.eval(DateAndTimePredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(DateAndTimePredicates.isNotMissing);
    }

    public IntArrayList data();
}

