/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.conversion;

import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.Relation;

public class SmileConverter {
    private final Relation table;

    public SmileConverter(Relation table) {
        this.table = table;
    }

    public AttributeDataset numericDataset(String responseColName) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NUMERIC, this.table.numericColumns().stream().filter(c -> !c.name().equals(responseColName)).collect(Collectors.toList()));
    }

    public AttributeDataset numericDataset(int responseColIndex, int ... variablesColIndices) {
        return this.dataset(this.table.numberColumn(responseColIndex), AttributeType.NUMERIC, this.table.columns(variablesColIndices));
    }

    public AttributeDataset numericDataset(String responseColName, String ... variablesColNames) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NUMERIC, this.table.columns(variablesColNames));
    }

    public AttributeDataset nominalDataset(String responseColName) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NOMINAL, this.table.numericColumns().stream().filter(c -> !c.name().equals(responseColName)).collect(Collectors.toList()));
    }

    public AttributeDataset nominalDataset(int responseColIndex, int ... variablesColIndices) {
        return this.dataset(this.table.numberColumn(responseColIndex), AttributeType.NOMINAL, this.table.columns(variablesColIndices));
    }

    public AttributeDataset nominalDataset(String responseColName, String ... variablesColNames) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NOMINAL, this.table.columns(variablesColNames));
    }

    private AttributeDataset dataset(NumericColumn<?> responseCol, AttributeType type, List<Column<?>> variableCols) {
        List convertedVariableCols = variableCols.stream().map(col -> col.type() == ColumnType.STRING ? col : this.table.nCol(col.name())).collect(Collectors.toList());
        NumericAttribute responseAttribute = type == AttributeType.NOMINAL ? this.colAsNominalAttribute(responseCol) : new NumericAttribute(responseCol.name());
        AttributeDataset dataset = new AttributeDataset(this.table.name(), (Attribute[])convertedVariableCols.stream().map(col -> this.colAsAttribute((Column<?>)col)).toArray(Attribute[]::new), (Attribute)responseAttribute);
        int i = 0;
        while (i < responseCol.size()) {
            int r = i++;
            double[] x = IntStream.range(0, convertedVariableCols.size()).mapToDouble(c -> this.getDouble((Column)convertedVariableCols.get(c), dataset.attributes()[c], r)).toArray();
            dataset.add(x, responseCol.getDouble(r));
        }
        return dataset;
    }

    private double getDouble(Column<?> col, Attribute attr, int r) {
        if (col.type() == ColumnType.STRING) {
            String value = ((StringColumn)col).get(r);
            try {
                return attr.valueOf(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Error converting " + value + " to nominal", e);
            }
        }
        if (col instanceof NumericColumn) {
            return ((NumericColumn)col).getDouble(r);
        }
        throw new IllegalStateException("Error converting " + col.type() + " column " + col.name() + " to Smile");
    }

    private Attribute colAsAttribute(Column<?> col) {
        return col.type() == ColumnType.STRING ? this.colAsNominalAttribute(col) : new NumericAttribute(col.name());
    }

    private NominalAttribute colAsNominalAttribute(Column<?> col) {
        return new NominalAttribute(col.name(), col.unique().mapInto(o -> o.toString(), StringColumn.create(col.name(), col.size())).asObjectArray());
    }

    private static enum AttributeType {
        NUMERIC,
        NOMINAL;

    }
}

