/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.AbstractParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.numbers.ShortColumnType;
import tech.tablesaw.selection.Selection;

public class ShortColumn
extends NumberColumn<Short>
implements CategoricalColumn<Short> {
    private static final ShortColumnType COLUMN_TYPE = ColumnType.SHORT;
    private final ShortComparator descendingComparator = (o2, o1) -> Short.compare(o1, o2);
    private final ShortArrayList data;

    protected ShortColumn(String name, ShortArrayList data) {
        super(COLUMN_TYPE, name);
        this.printFormatter = NumberColumnFormatter.ints();
        this.data = data;
    }

    public static ShortColumn create(String name) {
        return new ShortColumn(name, new ShortArrayList());
    }

    public static ShortColumn create(String name, short[] arr) {
        return new ShortColumn(name, new ShortArrayList(arr));
    }

    public static ShortColumn create(String name, int initialSize) {
        ShortColumn column = new ShortColumn(name, new ShortArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public ShortColumn createCol(String name, int initialSize) {
        return ShortColumn.create(name, initialSize);
    }

    public ShortColumn createCol(String name) {
        return ShortColumn.create(name);
    }

    public static boolean valueIsMissing(int value) {
        return value == ShortColumnType.missingValueIndicator();
    }

    @Override
    public Short get(int index) {
        return this.getShort(index);
    }

    public short getShort(int index) {
        return this.data.getShort(index);
    }

    public ShortColumn subset(int[] rows) {
        ShortColumn c = this.emptyCopy();
        for (int row : rows) {
            c.append(this.getShort(row));
        }
        return c;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public ShortColumn unique() {
        ShortOpenHashSet values = new ShortOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) continue;
            values.add(this.getShort(i));
        }
        ShortColumn column = ShortColumn.create(this.name() + " Unique values");
        ShortIterator shortIterator = values.iterator();
        while (shortIterator.hasNext()) {
            short value = (Short)shortIterator.next();
            column.append(value);
        }
        return column;
    }

    public ShortColumn top(int n) {
        ShortArrayList top = new ShortArrayList();
        short[] values = this.data.toShortArray();
        ShortArrays.parallelQuickSort((short[])values, (ShortComparator)this.descendingComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new ShortColumn(this.name() + "[Top " + n + "]", top);
    }

    public ShortColumn bottom(int n) {
        ShortArrayList bottom = new ShortArrayList();
        short[] values = this.data.toShortArray();
        ShortArrays.parallelQuickSort((short[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new ShortColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public ShortColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        short[] dest = new short[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = ShortColumnType.missingValueIndicator();
        }
        short[] array = this.data.toShortArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new ShortColumn(this.name() + " lag(" + n + ")", new ShortArrayList(dest));
    }

    public ShortColumn removeMissing() {
        ShortColumn result = this.copy();
        result.clear();
        ShortListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            short v = iterator.nextShort();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public ShortColumn append(short i) {
        this.data.add(i);
        return this;
    }

    public ShortColumn append(Short val) {
        this.append((short)val);
        return this;
    }

    @Override
    public ShortColumn emptyCopy() {
        return (ShortColumn)super.emptyCopy();
    }

    @Override
    public ShortColumn emptyCopy(int rowSize) {
        return (ShortColumn)super.emptyCopy(rowSize);
    }

    @Override
    public ShortColumn copy() {
        return new ShortColumn(this.name(), this.data.clone());
    }

    @Override
    public Iterator<Short> iterator() {
        return this.data.iterator();
    }

    public Short[] asObjectArray() {
        Short[] output = new Short[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.getShort(i);
        }
        return output;
    }

    @Override
    public int compare(Short o1, Short o2) {
        return Short.compare(o1, o2);
    }

    public ShortColumn set(int i, Short val) {
        return this.set(i, (short)val);
    }

    public ShortColumn set(int i, short val) {
        this.data.set(i, val);
        return this;
    }

    public ShortColumn append(Column<Short> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        ShortColumn numberColumn = (ShortColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getShort(i));
        }
        return this;
    }

    public ShortColumn append(Column<Short> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.append(((ShortColumn)column).getShort(row));
    }

    public ShortColumn set(int row, Column<Short> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((ShortColumn)column).getShort(sourceRow));
    }

    @Override
    public ShortColumn appendMissing() {
        return this.append(ShortColumnType.missingValueIndicator());
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(COLUMN_TYPE.byteSize()).putShort(this.getShort(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        ShortOpenHashSet uniqueElements = new ShortOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            short val = this.getShort(i);
            if (this.isMissingValue(val)) continue;
            uniqueElements.add(val);
        }
        return uniqueElements.size();
    }

    public int getInt(int row) {
        return this.data.getShort(row);
    }

    @Override
    public double getDouble(int row) {
        short value = this.data.getShort(row);
        if (this.isMissingValue(value)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return value;
    }

    public boolean isMissingValue(short value) {
        return ShortColumnType.isMissingValue(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getShort(rowNumber));
    }

    @Override
    public Column<Short> setMissing(int i) {
        return this.set(i, ShortColumnType.missingValueIndicator());
    }

    @Override
    public void sortAscending() {
        ShortArrays.parallelQuickSort((short[])this.data.elements());
    }

    @Override
    public void sortDescending() {
        ShortArrays.parallelQuickSort((short[])this.data.elements(), (ShortComparator)this.descendingComparator);
    }

    public ShortColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Short) {
            return this.append((short)((Short)obj));
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public ShortColumn appendCell(String value) {
        try {
            return this.append(ShortColumnType.DEFAULT_PARSER.parseShort(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public ShortColumn appendCell(String value, AbstractParser<?> parser) {
        try {
            return this.append(parser.parseShort(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        int value = this.getInt(row);
        if (IntColumnType.isMissingValue(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public ShortColumn inRange(int start, int end) {
        return (ShortColumn)super.inRange(start, end);
    }

    @Override
    public ShortColumn where(Selection selection) {
        return (ShortColumn)super.where(selection);
    }

    @Override
    public ShortColumn lead(int n) {
        return (ShortColumn)super.lead(n);
    }

    public ShortColumn setName(String name) {
        return (ShortColumn)super.setName(name);
    }

    public ShortColumn filter(Predicate<? super Short> test) {
        return (ShortColumn)super.filter(test);
    }

    public ShortColumn sorted(Comparator<? super Short> comp) {
        return (ShortColumn)super.sorted(comp);
    }

    public ShortColumn map(Function<? super Short, ? extends Short> fun) {
        return (ShortColumn)super.map(fun);
    }

    public ShortColumn min(Column<Short> other) {
        return (ShortColumn)super.min(other);
    }

    public ShortColumn max(Column<Short> other) {
        return (ShortColumn)super.max(other);
    }

    public ShortColumn set(Selection condition, Column<Short> other) {
        return (ShortColumn)super.set(condition, other);
    }

    public ShortColumn set(Selection rowSelection, Short newValue) {
        return (ShortColumn)super.set(rowSelection, newValue);
    }

    public ShortColumn first(int numRows) {
        return (ShortColumn)super.first(numRows);
    }

    public ShortColumn last(int numRows) {
        return (ShortColumn)super.last(numRows);
    }

    public ShortColumn sampleN(int n) {
        return (ShortColumn)super.sampleN(n);
    }

    public ShortColumn sampleX(double proportion) {
        return (ShortColumn)super.sampleX(proportion);
    }

    @Override
    public LongColumn asLongColumn() {
        LongArrayList values = new LongArrayList();
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short f = (Short)shortListIterator.next();
            values.add((long)f);
        }
        values.trim();
        return LongColumn.create(this.name(), values.elements());
    }

    @Override
    public FloatColumn asFloatColumn() {
        FloatArrayList values = new FloatArrayList();
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short d = (Short)shortListIterator.next();
            values.add((float)d);
        }
        values.trim();
        return FloatColumn.create(this.name(), values.elements());
    }

    @Override
    public DoubleColumn asDoubleColumn() {
        DoubleArrayList values = new DoubleArrayList();
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short d = (Short)shortListIterator.next();
            values.add((double)d);
        }
        values.trim();
        return DoubleColumn.create(this.name(), values.elements());
    }
}

