/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.AbstractParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.selection.Selection;

public class FloatColumn
extends NumberColumn<Float> {
    private static final FloatColumnType COLUMN_TYPE = ColumnType.FLOAT;
    private final FloatComparator descendingComparator = (o2, o1) -> Float.compare(o1, o2);
    private final FloatArrayList data;

    private FloatColumn(String name, FloatArrayList data) {
        super(COLUMN_TYPE, name);
        this.data = data;
    }

    public static FloatColumn create(String name) {
        return new FloatColumn(name, new FloatArrayList());
    }

    public static FloatColumn create(String name, float[] arr) {
        return new FloatColumn(name, new FloatArrayList(arr));
    }

    public static FloatColumn create(String name, int initialSize) {
        FloatColumn column = new FloatColumn(name, new FloatArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public FloatColumn createCol(String name, int initialSize) {
        return FloatColumn.create(name, initialSize);
    }

    public FloatColumn createCol(String name) {
        return FloatColumn.create(name);
    }

    @Override
    public Float get(int index) {
        return Float.valueOf(this.data.getFloat(index));
    }

    public FloatColumn subset(int[] rows) {
        FloatColumn c = this.emptyCopy();
        for (int row : rows) {
            c.append(this.getFloat(row));
        }
        return c;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public FloatColumn unique() {
        FloatOpenHashSet values = new FloatOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) continue;
            values.add(this.getFloat(i));
        }
        FloatColumn column = FloatColumn.create(this.name() + " Unique values", values.size());
        FloatIterator floatIterator = values.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            column.append(value);
        }
        return column;
    }

    public FloatColumn top(int n) {
        FloatArrayList top = new FloatArrayList();
        float[] values = this.data.toFloatArray();
        FloatArrays.parallelQuickSort((float[])values, (FloatComparator)this.descendingComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new FloatColumn(this.name() + "[Top " + n + "]", top);
    }

    public FloatColumn bottom(int n) {
        FloatArrayList bottom = new FloatArrayList();
        float[] values = this.data.toFloatArray();
        FloatArrays.parallelQuickSort((float[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new FloatColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public FloatColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        float[] dest = new float[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = FloatColumnType.missingValueIndicator();
        }
        float[] array = this.data.toFloatArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new FloatColumn(this.name() + " lag(" + n + ")", new FloatArrayList(dest));
    }

    public FloatColumn removeMissing() {
        FloatColumn result = this.copy();
        result.clear();
        FloatListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            float v = iterator.nextFloat();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public FloatColumn append(float i) {
        this.data.add(i);
        return this;
    }

    public FloatColumn append(Float val) {
        this.append(val.floatValue());
        return this;
    }

    @Override
    public FloatColumn emptyCopy() {
        return (FloatColumn)super.emptyCopy();
    }

    @Override
    public FloatColumn emptyCopy(int rowSize) {
        return (FloatColumn)super.emptyCopy(rowSize);
    }

    @Override
    public FloatColumn copy() {
        return new FloatColumn(this.name(), this.data.clone());
    }

    @Override
    public Iterator<Float> iterator() {
        return this.data.iterator();
    }

    @Override
    public Object[] asObjectArray() {
        Object[] output = new Float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = Float.valueOf(this.getFloat(i));
        }
        return output;
    }

    @Override
    public int compare(Float o1, Float o2) {
        return Float.compare(o1.floatValue(), o2.floatValue());
    }

    public FloatColumn set(int i, Float val) {
        return this.set(i, val.floatValue());
    }

    public FloatColumn set(int i, float val) {
        this.data.set(i, val);
        return this;
    }

    public FloatColumn append(Column<Float> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        FloatColumn numberColumn = (FloatColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getFloat(i));
        }
        return this;
    }

    public FloatColumn append(Column<Float> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.append(((FloatColumn)column).getFloat(row));
    }

    public FloatColumn set(int row, Column<Float> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((FloatColumn)column).getFloat(sourceRow));
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(COLUMN_TYPE.byteSize()).putFloat(this.getFloat(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        FloatOpenHashSet uniqueElements = new FloatOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMissing(i)) continue;
            uniqueElements.add(this.getFloat(i));
        }
        return uniqueElements.size();
    }

    @Override
    public double getDouble(int row) {
        float value = this.data.getFloat(row);
        if (this.isMissingValue(value)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return value;
    }

    public float getFloat(int row) {
        return this.data.getFloat(row);
    }

    public boolean isMissingValue(float value) {
        return FloatColumnType.isMissingValue(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getFloat(rowNumber));
    }

    @Override
    public Column<Float> setMissing(int i) {
        return this.set(i, FloatColumnType.missingValueIndicator());
    }

    @Override
    public void sortAscending() {
        FloatArrays.parallelQuickSort((float[])this.data.elements());
    }

    @Override
    public void sortDescending() {
        FloatArrays.parallelQuickSort((float[])this.data.elements(), (FloatComparator)this.descendingComparator);
    }

    @Override
    public FloatColumn appendMissing() {
        return this.append(FloatColumnType.missingValueIndicator());
    }

    public FloatColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Float) {
            return this.append(((Float)obj).floatValue());
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public FloatColumn appendCell(String value) {
        try {
            return this.append(FloatColumnType.DEFAULT_PARSER.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public FloatColumn appendCell(String value, AbstractParser<?> parser) {
        try {
            return this.append(parser.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        float value = this.getFloat(row);
        if (FloatColumnType.isMissingValue(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public FloatColumn inRange(int start, int end) {
        return (FloatColumn)super.inRange(start, end);
    }

    @Override
    public FloatColumn where(Selection selection) {
        return (FloatColumn)super.where(selection);
    }

    @Override
    public FloatColumn lead(int n) {
        return (FloatColumn)super.lead(n);
    }

    public FloatColumn setName(String name) {
        return (FloatColumn)super.setName(name);
    }

    public FloatColumn filter(Predicate<? super Float> test) {
        return (FloatColumn)super.filter(test);
    }

    public FloatColumn sorted(Comparator<? super Float> comp) {
        return (FloatColumn)super.sorted(comp);
    }

    public FloatColumn map(Function<? super Float, ? extends Float> fun) {
        return (FloatColumn)super.map(fun);
    }

    public FloatColumn min(Column<Float> other) {
        return (FloatColumn)super.min(other);
    }

    public FloatColumn max(Column<Float> other) {
        return (FloatColumn)super.max(other);
    }

    public FloatColumn set(Selection condition, Column<Float> other) {
        return (FloatColumn)super.set(condition, other);
    }

    public FloatColumn set(Selection rowSelection, Float newValue) {
        return (FloatColumn)super.set(rowSelection, newValue);
    }

    public FloatColumn first(int numRows) {
        return (FloatColumn)super.first(numRows);
    }

    public FloatColumn last(int numRows) {
        return (FloatColumn)super.last(numRows);
    }

    public FloatColumn sampleN(int n) {
        return (FloatColumn)super.sampleN(n);
    }

    public FloatColumn sampleX(double proportion) {
        return (FloatColumn)super.sampleX(proportion);
    }

    @Override
    public LongColumn asLongColumn() {
        LongArrayList values = new LongArrayList();
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float f = ((Float)floatListIterator.next()).floatValue();
            values.add((long)f);
        }
        values.trim();
        return LongColumn.create(this.name(), values.elements());
    }

    @Override
    public IntColumn asIntColumn() {
        IntArrayList values = new IntArrayList();
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float d = ((Float)floatListIterator.next()).floatValue();
            values.add((int)d);
        }
        values.trim();
        return IntColumn.create(this.name(), values.elements());
    }

    @Override
    public ShortColumn asShortColumn() {
        ShortArrayList values = new ShortArrayList();
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float d = ((Float)floatListIterator.next()).floatValue();
            values.add((short)d);
        }
        values.trim();
        return ShortColumn.create(this.name(), values.elements());
    }

    @Override
    public DoubleColumn asDoubleColumn() {
        DoubleArrayList values = new DoubleArrayList();
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float d = ((Float)floatListIterator.next()).floatValue();
            values.add((double)d);
        }
        values.trim();
        return DoubleColumn.create(this.name(), values.elements());
    }
}

