/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Paths;

public class CsvWriteOptions {
    private final Writer writer;
    private final boolean header;
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final String lineEnd;

    private CsvWriteOptions(Builder builder) {
        this.writer = builder.writer;
        this.header = builder.header;
        this.separator = builder.separator;
        this.quotechar = builder.quoteChar;
        this.escapechar = builder.escapeChar;
        this.lineEnd = builder.lineEnd;
    }

    Writer writer() {
        return this.writer;
    }

    boolean header() {
        return this.header;
    }

    char separator() {
        return this.separator;
    }

    char escapeChar() {
        return this.escapechar;
    }

    char quoteChar() {
        return this.quotechar;
    }

    String lineEnd() {
        return this.lineEnd;
    }

    public static Builder builder(File file) {
        return new Builder(file);
    }

    public static Builder builder(String fileName) {
        return CsvWriteOptions.builder(new File(fileName));
    }

    public static class Builder {
        private Writer writer;
        private boolean header = true;
        private char separator = (char)44;
        private String lineEnd = "\n";
        private char escapeChar = (char)92;
        private char quoteChar = (char)34;

        public Builder(String fileName) throws IOException {
            File file = Paths.get(fileName, new String[0]).toFile();
            this.writer = new FileWriter(file);
        }

        public Builder(File file) {
            try {
                this.writer = new FileWriter(file);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public Builder(Writer writer) {
            this.writer = writer;
        }

        public Builder(OutputStream stream) {
            this.writer = new OutputStreamWriter(stream);
        }

        public Builder separator(char separator) {
            this.separator = separator;
            return this;
        }

        public Builder quoteChar(char quoteChar) {
            this.quoteChar = quoteChar;
            return this;
        }

        public Builder escapeChar(char escapeChar) {
            this.escapeChar = escapeChar;
            return this;
        }

        public Builder lineEnd(String lineEnd) {
            this.lineEnd = lineEnd;
            return this;
        }

        public Builder header(boolean header) {
            this.header = header;
            return this;
        }

        public CsvWriteOptions build() {
            return new CsvWriteOptions(this);
        }
    }
}

