/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class FloatIndex {
    private final Float2ObjectAVLTreeMap<IntArrayList> index;

    public FloatIndex(FloatColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Float2ObjectOpenHashMap tempMap = new Float2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            float value = column.getFloat(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Float2ObjectAVLTreeMap((Float2ObjectMap)tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(float value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = (IntArrayList)this.index.get(value);
        if (list != null) {
            FloatIndex.addAllToSelection(list, selection);
        }
        return selection;
    }

    public Selection atLeast(float value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Float2ObjectSortedMap tail = this.index.tailMap(value);
        for (IntArrayList keys : tail.values()) {
            FloatIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection greaterThan(float value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Float2ObjectSortedMap tail = this.index.tailMap(value + 1.0E-6f);
        for (IntArrayList keys : tail.values()) {
            FloatIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atMost(float value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Float2ObjectSortedMap head = this.index.headMap(value + 1.0E-6f);
        for (IntArrayList keys : head.values()) {
            FloatIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection lessThan(float value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Float2ObjectSortedMap head = this.index.headMap(value);
        for (IntArrayList keys : head.values()) {
            FloatIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }
}

