/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.conversion;

import java.util.List;
import java.util.stream.Collectors;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.table.Relation;

public class SmileConverter {
    private final Relation table;

    public SmileConverter(Relation table) {
        this.table = table;
    }

    public AttributeDataset numericDataset(String responseColName) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NUMERIC, this.table.numericColumns().stream().filter(c -> !c.name().equals(responseColName)).collect(Collectors.toList()));
    }

    public AttributeDataset numericDataset(int responseColIndex, int ... variablesColIndices) {
        return this.dataset(this.table.numberColumn(responseColIndex), AttributeType.NUMERIC, this.table.numericColumns(variablesColIndices));
    }

    public AttributeDataset numericDataset(String responseColName, String ... variablesColNames) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NUMERIC, this.table.numericColumns(variablesColNames));
    }

    public AttributeDataset nominalDataset(String responseColName) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NOMINAL, this.table.numericColumns().stream().filter(c -> !c.name().equals(responseColName)).collect(Collectors.toList()));
    }

    public AttributeDataset nominalDataset(int responseColIndex, int ... variablesColIndices) {
        return this.dataset(this.table.numberColumn(responseColIndex), AttributeType.NOMINAL, this.table.numericColumns(variablesColIndices));
    }

    public AttributeDataset nominalDataset(String responseColName, String ... variablesColNames) {
        return this.dataset(this.table.numberColumn(responseColName), AttributeType.NOMINAL, this.table.numericColumns(variablesColNames));
    }

    private AttributeDataset dataset(NumericColumn<?> responseCol, AttributeType type, List<NumericColumn<?>> variableCols) {
        NominalAttribute responseAttribute = type == AttributeType.NOMINAL ? new NominalAttribute(responseCol.name()) : new NumericAttribute(responseCol.name());
        AttributeDataset data = new AttributeDataset(this.table.name(), (Attribute[])variableCols.stream().map(col -> new NumericAttribute(col.name())).toArray(Attribute[]::new), (Attribute)responseAttribute);
        int i = 0;
        while (i < responseCol.size()) {
            int r = i++;
            double[] x = variableCols.stream().mapToDouble(c -> c.getDouble(r)).toArray();
            data.add(x, responseCol.getDouble(r));
        }
        return data;
    }

    private static enum AttributeType {
        NUMERIC,
        NOMINAL;

    }
}

