/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleRBTreeSet;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import org.apache.commons.math3.stat.correlation.KendallsCorrelation;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.aggregate.NumericAggregateFunction;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.NumberFilters;
import tech.tablesaw.columns.numbers.NumberMapFunctions;
import tech.tablesaw.columns.numbers.NumberPredicates;
import tech.tablesaw.columns.numbers.NumberRollingColumn;
import tech.tablesaw.columns.numbers.Stats;
import tech.tablesaw.filtering.predicates.DoubleBiPredicate;
import tech.tablesaw.filtering.predicates.DoubleRangePredicate;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface NumericColumn<T>
extends Column<T>,
NumberMapFunctions,
NumberFilters {
    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public double[] asDoubleArray() {
        double[] output = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.getDouble(i);
        }
        return output;
    }

    @Override
    default public Selection eval(DoublePredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            double next = this.getDouble(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    default public Selection eval(DoubleBiPredicate predicate, DoubleColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.getDouble(idx), otherColumn.getDouble(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    @Override
    default public Selection eval(DoubleBiPredicate predicate, Number number) {
        double value = number.doubleValue();
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            double next = this.getDouble(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    default public Selection eval(BiPredicate<Number, Number> predicate, Number number) {
        double value = number.doubleValue();
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            double next = this.getDouble(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    default public Selection eval(DoubleRangePredicate predicate, Number rangeStart, Number rangeEnd) {
        double start = rangeStart.doubleValue();
        double end = rangeEnd.doubleValue();
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            double next = this.getDouble(idx);
            if (!predicate.test(next, start, end)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    default public Selection isIn(Number ... numbers) {
        return this.isIn(Arrays.stream(numbers).mapToDouble(Number::doubleValue).toArray());
    }

    @Override
    default public Selection isIn(double ... doubles) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        DoubleRBTreeSet doubleSet = new DoubleRBTreeSet(doubles);
        for (int i = 0; i < this.size(); ++i) {
            if (!doubleSet.contains(this.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isNotIn(Number ... numbers) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(numbers));
        return results;
    }

    @Override
    default public Selection isNotIn(double ... doubles) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(doubles));
        return results;
    }

    @Override
    default public Selection isMissing() {
        return this.eval(NumberPredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(NumberPredicates.isNotMissing);
    }

    default public int count(DoublePredicate test) {
        return this.count(test, this.size());
    }

    default public int count(DoublePredicate test, int max) {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!test.test(this.getDouble(i)) || ++count < max) continue;
            return count;
        }
        return count;
    }

    default public Optional<Double> max(DoubleComparator comp) {
        boolean first = true;
        double d1 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double d2 = this.getDouble(i);
            if (first) {
                d1 = d2;
                first = false;
                continue;
            }
            if (comp.compare(d1, d2) >= 0) continue;
            d1 = d2;
        }
        return first ? Optional.empty() : Optional.of(d1);
    }

    default public Optional<Double> min(DoubleComparator comp) {
        boolean first = true;
        double d1 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double d2 = this.getDouble(i);
            if (first) {
                d1 = d2;
                first = false;
                continue;
            }
            if (comp.compare(d1, d2) <= 0) continue;
            d1 = d2;
        }
        return first ? Optional.empty() : Optional.of(d1);
    }

    default public double reduce(double initial, DoubleBinaryOperator op) {
        double acc = initial;
        for (int i = 0; i < this.size(); ++i) {
            acc = op.applyAsDouble(acc, this.getDouble(i));
        }
        return acc;
    }

    default public Optional<Double> reduce(DoubleBinaryOperator op) {
        boolean first = true;
        double acc = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double d = this.getDouble(i);
            if (first) {
                acc = d;
                first = false;
                continue;
            }
            acc = op.applyAsDouble(acc, d);
        }
        return first ? Optional.empty() : Optional.of(acc);
    }

    default public <R> Column<R> mapInto(DoubleFunction<? extends R> fun, Column<R> into) {
        for (int i = 0; i < this.size(); ++i) {
            try {
                into.append(fun.apply(this.getDouble(i)));
                continue;
            }
            catch (Exception e) {
                into.appendMissing();
            }
        }
        return into;
    }

    @Override
    default public NumericColumn<T> where(Selection selection) {
        return (NumericColumn)this.subset(selection.toArray());
    }

    default public Double summarize(Selection selection, NumericAggregateFunction function) {
        Column column = this.where(selection);
        return (Double)function.summarize(column);
    }

    @Override
    default public double sum() {
        return (Double)AggregateFunctions.sum.summarize(this);
    }

    default public double product() {
        return (Double)AggregateFunctions.product.summarize(this);
    }

    default public double mean() {
        return (Double)AggregateFunctions.mean.summarize(this);
    }

    default public double median() {
        return (Double)AggregateFunctions.median.summarize(this);
    }

    default public double quartile1() {
        return (Double)AggregateFunctions.quartile1.summarize(this);
    }

    default public double quartile3() {
        return (Double)AggregateFunctions.quartile3.summarize(this);
    }

    default public double percentile(double percentile) {
        return AggregateFunctions.percentile(this, percentile);
    }

    default public double range() {
        return (Double)AggregateFunctions.range.summarize(this);
    }

    default public double max() {
        return (Double)AggregateFunctions.max.summarize(this);
    }

    default public double min() {
        return (Double)AggregateFunctions.min.summarize(this);
    }

    default public double variance() {
        return (Double)AggregateFunctions.variance.summarize(this);
    }

    default public double populationVariance() {
        return (Double)AggregateFunctions.populationVariance.summarize(this);
    }

    default public double standardDeviation() {
        return (Double)AggregateFunctions.stdDev.summarize(this);
    }

    default public double sumOfLogs() {
        return (Double)AggregateFunctions.sumOfLogs.summarize(this);
    }

    default public double sumOfSquares() {
        return (Double)AggregateFunctions.sumOfSquares.summarize(this);
    }

    default public double geometricMean() {
        return (Double)AggregateFunctions.geometricMean.summarize(this);
    }

    default public double quadraticMean() {
        return (Double)AggregateFunctions.quadraticMean.summarize(this);
    }

    default public double kurtosis() {
        return (Double)AggregateFunctions.kurtosis.summarize(this);
    }

    default public double skewness() {
        return (Double)AggregateFunctions.skewness.summarize(this);
    }

    default public double pearsons(NumericColumn<?> otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new PearsonsCorrelation().correlation(x, y);
    }

    default public double spearmans(NumericColumn<?> otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new SpearmansCorrelation().correlation(x, y);
    }

    default public double kendalls(NumericColumn<?> otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new KendallsCorrelation().correlation(x, y);
    }

    @Override
    default public Table summary() {
        return this.stats().asTable();
    }

    default public Stats stats() {
        return Stats.create(this);
    }

    @Override
    default public NumberRollingColumn rolling(int windowSize) {
        return new NumberRollingColumn(this, windowSize);
    }

    @Override
    default public NumericColumn<T> lead(int n) {
        Column numberColumn = this.lag(-n);
        numberColumn.setName(this.name() + " lead(" + n + ")");
        return numberColumn;
    }

    @Override
    public NumericColumn<T> lag(int var1);

    @Override
    public double getDouble(int var1);

    default public LongColumn asLongColumn() {
        return (LongColumn)this.copy();
    }

    default public IntColumn asIntColumn() {
        return (IntColumn)this.copy();
    }

    default public FloatColumn asFloatColumn() {
        return (FloatColumn)this.copy();
    }

    default public DoubleColumn asDoubleColumn() {
        return (DoubleColumn)this.copy();
    }

    default public ShortColumn asShortColumn() {
        return (ShortColumn)this.copy();
    }
}

