/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.util.StringUtils;

public class RollingColumn {
    private final Column column;
    private final int window;

    public RollingColumn(Column column, int window) {
        this.column = column;
        this.window = window;
    }

    public NumberColumn mean() {
        return (NumberColumn)this.calc(AggregateFunctions.mean);
    }

    public NumberColumn median() {
        return (NumberColumn)this.calc(AggregateFunctions.median);
    }

    public NumberColumn geometricMean() {
        return (NumberColumn)this.calc(AggregateFunctions.geometricMean);
    }

    public NumberColumn sum() {
        return (NumberColumn)this.calc(AggregateFunctions.sum);
    }

    public NumberColumn pctChange() {
        return (NumberColumn)this.calc(AggregateFunctions.pctChange);
    }

    private String generateNewColumnName(AggregateFunction function) {
        boolean useSpaces = this.column.name().matches("\\s+");
        String separator = useSpaces ? " " : "";
        return this.column.name() + separator + (useSpaces ? function.functionName() : StringUtils.capitalize(function.functionName())) + separator + this.window;
    }

    public Column<?> calc(AggregateFunction function) {
        Column<Double> result = function.returnType().create(this.generateNewColumnName(function));
        for (int i = 0; i < this.window - 1; ++i) {
            result.appendMissing();
        }
        for (int origColIndex = 0; origColIndex < this.column.size() - this.window + 1; ++origColIndex) {
            BitmapBackedSelection selection = new BitmapBackedSelection();
            selection.addRange(origColIndex, origColIndex + this.window);
            Object answer = function.summarize(this.column.subset(selection));
            if (answer instanceof Number) {
                Number number = (Number)answer;
                result.append(number.doubleValue());
                continue;
            }
            result.append((Double)answer);
        }
        return result;
    }
}

