/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;

public class CsvReadOptions {
    private final File file;
    private final Reader reader;
    private final String tableName;
    private final ColumnType[] columnTypes;
    private final boolean header;
    private final char separator;
    private final boolean sample;
    private final String dateFormat;
    private final String dateTimeFormat;
    private final String timeFormat;
    private final Locale locale;
    private final String missingValueIndicator;

    private CsvReadOptions(Builder builder) {
        this.file = builder.file;
        this.reader = builder.reader;
        this.tableName = builder.tableName;
        this.columnTypes = builder.columnTypes;
        this.header = builder.header;
        this.separator = builder.separator;
        this.sample = builder.sample;
        this.dateFormat = builder.dateFormat;
        this.timeFormat = builder.timeFormat;
        this.dateTimeFormat = builder.dateTimeFormat;
        this.missingValueIndicator = builder.missingValueIndicator;
        this.locale = builder.locale == null ? Locale.getDefault() : builder.locale;
    }

    public static Builder builder(File file) {
        return new Builder().file(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return CsvReadOptions.builder(new File(fileName));
    }

    public static Builder builder(InputStream stream, String tableName) {
        return CsvReadOptions.builder(new InputStreamReader(stream), tableName);
    }

    public static Builder builder(Reader reader, String tableName) {
        Builder builder = new Builder();
        return builder.reader(reader).tableName(tableName);
    }

    public File file() {
        return this.file;
    }

    public Reader reader() {
        return this.reader;
    }

    public String tableName() {
        return this.tableName;
    }

    public ColumnType[] columnTypes() {
        return this.columnTypes;
    }

    public boolean header() {
        return this.header;
    }

    public char separator() {
        return this.separator;
    }

    public boolean sample() {
        return this.sample;
    }

    public String missingValueIndicator() {
        return this.missingValueIndicator;
    }

    public Locale locale() {
        return this.locale;
    }

    public DateTimeFormatter dateTimeFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateTimeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale);
    }

    public DateTimeFormatter timeFormatter() {
        if (Strings.isNullOrEmpty((String)this.timeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.timeFormat, this.locale);
    }

    public DateTimeFormatter dateFormatter() {
        if (Strings.isNullOrEmpty((String)this.dateFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
    }

    public static class Builder {
        private File file;
        private Reader reader;
        private String tableName = "";
        private boolean header = true;
        private char separator = (char)44;
        private boolean sample = true;
        private ColumnType[] columnTypes;
        private String dateFormat;
        private String timeFormat;
        private String dateTimeFormat;
        private Locale locale;
        private String missingValueIndicator;

        public Builder file(File file) {
            this.file = file;
            this.tableName = file.getName();
            return this;
        }

        public Builder reader(Reader reader) {
            this.reader = reader;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public Builder header(boolean header) {
            this.header = header;
            return this;
        }

        public Builder missingValueIndicator(String missingValueIndicator) {
            this.missingValueIndicator = missingValueIndicator;
            return this;
        }

        public Builder separator(char separator) {
            this.separator = separator;
            return this;
        }

        public Builder sample(boolean sample) {
            this.sample = sample;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public CsvReadOptions build() {
            return new CsvReadOptions(this);
        }
    }
}

